/*
** Copyright 1998 - 2000 Double Precision, Inc.
** See COPYING for distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<ctype.h>
#include	<fcntl.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#include	"imaptoken.h"
#include	"imapwrite.h"

#include	"authlib/auth.h"
#include	"authlib/authmod.h"

static const char rcsid[]="$Id: imaplogin.c,v 1.5 2000/03/26 17:09:43 mrsam Exp $";

FILE *debugfile=0;
extern void mainloop();
extern void capability();
extern int authenticate(const char *);

int main_argc;
char **main_argv;

void rfc2045_error(const char *p)
{
	write(2, p, strlen(p));
	_exit(0);
}

int do_imap_command(const char *tag)
{
struct	imaptoken *curtoken=nexttoken();

	if (strcmp(curtoken->tokenbuf, "LOGOUT") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)   return (-1);
		writes("* BYE Courier-IMAP server shutting down\r\n");
		writes(tag);
		writes(" OK LOGOUT completed\r\n");
		writeflush();
		fprintf(stderr, "INFO: LOGOUT, ip=[%s]\n",
			getenv("TCPREMOTEIP"));
		exit(0);
	}
	if (strcmp(curtoken->tokenbuf, "NOOP") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		writes(tag);
		writes(" OK NOOP completed\r\n");
		return (0);
	}
	if (strcmp(curtoken->tokenbuf, "CAPABILITY") == 0)
	{
		if (nexttoken()->tokentype != IT_EOL)	return (-1);
		capability();
		writes(tag);
		writes(" OK CAPABILITY completed\r\n");
		return (0);
	}

	if (strcmp(curtoken->tokenbuf, "LOGIN") == 0)
	{
	struct imaptoken *tok=nexttoken_nouc();
	char	*userid;
	char	*tagenv;
	char	*passwd;

		switch (tok->tokentype)	{
		case IT_ATOM:
		case IT_NUMBER:
		case IT_QUOTED_STRING:
			break;
		default:
			return (-1);
		}

		userid=strdup(tok->tokenbuf);
		if (!userid)
			write_error_exit(0);
		tok=nexttoken_nouc();
		switch (tok->tokentype)	{
		case IT_ATOM:
		case IT_NUMBER:
		case IT_QUOTED_STRING:
			break;
		default:
			free(userid);
			return (-1);
		}

		tagenv=malloc(sizeof("IMAPLOGINTAG=")+strlen(tag));
		if (!tagenv)	write_error_exit(0);
		strcat(strcpy(tagenv, "IMAPLOGINTAG="), tag);
		passwd=my_strdup(tok->tokenbuf);

		if (nexttoken()->tokentype != IT_EOL)
		{
			free(tagenv);
			free(userid);
			free(passwd);
			return (-1);
		}
		putenv(tagenv);
		authmod_login(main_argc-1, main_argv+1, "imap",
			userid, passwd);
	}

	if (strcmp(curtoken->tokenbuf, "AUTHENTICATE") == 0)
		return (authenticate(tag));

	return (-1);
}

extern void ignorepunct();

int main(int argc, char **argv)
{
const char	*tag=getenv("IMAPLOGINTAG");
const char	*ip;

	ip=getenv("TCPREMOTEIP");
	if (!ip)	exit(9);

#if	IMAP_CLIENT_BUGS

	ignorepunct();

#endif

	if (authmoduser(argc, argv, 60, 5))
	{
		writes("* OK Courier-IMAP ready. Copyright 1998-2000 Double Precision, Inc.  See COPYING for distribution information.\r\n");
		fprintf(stderr, "INFO: Connection, ip=[%s]\n", ip);
	}
	else
	{
		writes(tag ? tag:"");
		writes(" NO Login failed.\r\n");
		fprintf(stderr, "ERR: LOGIN FAILED, ip=[%s]\n", ip);
	}

	writeflush();
	main_argc=argc;
	main_argv=argv;

	mainloop();
	return (0);
}
