/* $Id: elmlib.h,v 1.19.2.1.2.5 1999/11/07 17:33:01 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.19.2.1.2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 *****************************************************************************/

#undef P_
#ifdef __STDC__
#define P_(x) x
#else
#define P_(x) ()
#endif

/* lib/strmcpy.c */

extern char *strmcpy P_((char *, CONST char *));
extern char *strmcat P_((char *, CONST char *));

/* safeopen.c */

extern FILE *safeopen P_((char *));
extern FILE *safeopen_rdwr P_((char *));

/* istrcmp.c */

extern int istrcmp P_((CONST char *, CONST char *));

/* add_site.c */

extern int add_site P_((char *, char *, char *, int));

/* addrmchusr.c */

extern int addr_matches_user P_((char *, char *));

/* atonum.c */

extern int atonum P_((char *));

/* mk_aliases.c */

extern int get_alias P_((FILE *,int));
extern int get_line P_((FILE *,char *,int, int));
extern void de_escape P_((char *));
extern int add_to_hash_table P_((char *,int32));
extern void add_to_table     P_((FILE *,char *, char *, char *, 
				 char *, char *));
extern int check_alias       P_((char *));
extern int check_address     P_((char *));
extern void put_alias        P_((FILE *));
extern int do_newalias       P_((char *, char *,int, int));

/* aliasdb.c */

/* fetch_alias */
extern char *next_addr_in_list P_((char **));

/* mk_lockname */
     
extern char * mk_lockname P_((char *));

/* can_access.c */
/* I don't understand this routine! access -system call uses
 * real uid / gid anyway!!!!!!!!!!!!!!
 *
 *                                - K E H <hurtta@ozone.FMI.FI>
 */

extern int can_access P_((char *,int));

/* can_open.c */

extern int can_open P_((CONST char *, CONST char *));

/* chloc.c */

/* Is this really needed? This does same than strchr or index, except
 *  that return type is different.
 *
 *                          - K E H <hurtta@ozone.FMI.FI>
 */

/* Argument (second) can't be char because there is both prototype and
 * non-prototype declaration.
 */
extern int chloc  P_((char *,int));
extern int qchloc P_((char *, int));

/* date_util.c */

extern int cvt_dayname_to_daynum     P_((char *,int *));
extern int cvt_monthname_to_monthnum P_((char *,int *));
extern int cvt_yearstr_to_yearnum    P_((char *,int *));
extern int cvt_mmddyy_to_dayofyear   P_((int, int, int, int*));
extern int cvt_timezone_to_offset    P_((char *str,int *, int));
extern int cvt_numtz_to_mins         P_((char *));
extern int cvt_timestr_to_hhmmss     P_((char *, int *, int *, int *));
extern long make_gmttime             P_((int, int, int, int, int, int));

/* dispaddr.c */
#ifdef ANSI_C
struct header_rec;           /* Needed for prototype */
#endif

typedef void decode_who P_((int class, char *ptr, int size));
extern int DisplayAddress  P_((struct header_rec *,char *,int, decode_who));

/* errno.c */

extern char *error_description P_((int));

/* expnad.c */

extern int expand P_((char *, int));

/* gcos_name.c */

extern char * gcos_name          P_((char *, char *));

/* get_tz.c */

extern int get_tz_mins   P_((void));
extern CONST char *get_tz_name P_((struct tm *));

/* getaddr.c */

extern void free_rfc822tokenized   P_((char **res));
/* Removes comments from vector: */
extern void remove_space_tokenized P_((char ** tokenized));
extern char **rfc822_tokenize      P_((CONST char *line));

extern struct addr_item {
  char *addr;
  char *fullname;
  char *comment;
} * break_down_address P_((CONST char *buffer, decode_who decoder));

extern void  free_addr_items P_((struct addr_item *list));

/* getaddrfrm.c */

extern void get_address_from P_((char *, char *, int size));

/* getarpdate.c */

extern char * get_arpa_date P_((void));

/* getfullnam.c */

extern char * get_full_name P_((char *));

/* getword.c */

extern int get_word P_((CONST char *,int,char *,int));

/* getword.c */

extern char * header_cmp P_((char *, char *, char *));

/* in_list.c */

/* in_list should use quoted -variants (strtokq, ...)
 *                            - K E H <hurtta@ozone.FMI.FI>
 */
extern int in_list   P_((char *, CONST char *));
extern int globmatch P_(( char *, char *));

/* in_string.c */

/* Is that needed? This is almost same as strstr (except return type).
 *                                     - K E H <hurtta@ozone.FMI.FI> 
 */
extern int in_string P_((char *, char *));

/* ldstate.c */

/* load_folder_state_file */

/* len_next.c */

extern int len_next_part P_((CONST char *));

/* mail_gets.c */

extern int mail_gets P_((char *,int,FILE *));

/* move_left.c */

extern void move_left P_((char *,int));

/* okay_address.c */

extern int okay_address_l P_((CONST struct addr_item *address, 
			      CONST struct addr_item *return_address));
/* opt_utils.c */

#ifndef GETHOSTNAME
extern int gethostname P_((char *,int));
#endif

extern int gethostdomain P_((char *,int));

#ifndef HAS_CUSERID
extern char *cuserid P_((char *));
#ifndef L_cuserid
#define L_cuserid 9
#endif
#endif

#ifndef STRTOK
extern char *strtok  P_((char *, char *));
#endif

#ifndef STRPBRK
extern char *strpbrk     P_((char *, char *));
#endif

#ifndef STRSPN
extern int strspn        P_((char *, char *));
#endif

#ifndef STRCSPN
extern int strcspn       P_((char *, char *));
#endif

#ifndef TEMPNAM
extern char *tempnam     P_((char *, char *));
#endif

#ifndef GETOPT
extern int getopt P_((int,char	**, char *));
#endif

#ifndef RENAME
int rename P_((CONST char *, CONST char *fname));
#endif

/* parsarpdat.c */

extern int parse_date_time P_((CONST char *str, 
			       char *time_zone, int size_time_zone,
			       time_t *tz_offset, time_t *time_result));

extern int parse_arpa_date P_((char *str,
			       struct header_rec *entry));

/* This perhaps should go away.   - K E H <hurtta@ozone.FMI.FI> */

extern void decode_who_none P_((int class, char *ptr, int size));
extern void parse_arpa_who P_((char *, char *,decode_who, int));

/* posixsig.c */

#ifdef POSIX_SIGNALS
extern SIGHAND_TYPE (*posig_signal  P_((int, 
					SIGHAND_TYPE (*fun)P_((int))
					))
		     )P_((int));
#endif
#if defined(BSD_TYPE) && !defined(WEXITSTATUS)
typedef union wait S__;
#else
typedef int        S__;
#endif

extern int my_wait P_((int pid, S__ *statptr)); 
extern int convert_status P_((S__ status,int *exit_code));

/* putenv.c */
#ifndef PUTENV
extern int putenv   P_((char *));
#endif

/* realfrom.c */

/* real_from */

/* qstrings.c */

extern char *qstrpbrk   P_((char *, char *));
extern int qstrspn      P_((char *, char *));
extern int qstrcspn     P_((char *, char *));

/* remfirstwd.c */

void remove_first_word     P_((char *));
void remove_header_keyword P_((char *));

/* reverse.c */

extern void reverse P_((char *));

/* safemalloc.c */

extern void dflt_safe_malloc_fail_handler P_((char *proc,unsigned));
extern void (*safe_malloc_fail_handler)   P_((char *proc,unsigned));

extern malloc_t safe_malloc  P_((unsigned));
extern malloc_t safe_realloc P_((malloc_t,unsigned));
extern char *safe_strdup     P_((CONST char *));

/* shiftlower.c */

extern char *shift_lower     P_((CONST char *));

/* strfcpy */

extern char *strfcpy P_((char *, CONST char *, int));
extern char *strfcat P_((char *, CONST char *, int));

/* strincmp.c */

/* Is this needed? This is same than strncasecmp 
 *        - K E H <hurtta@ozone.FMI.FI>
 */

extern int strincmp P_((CONST char *, CONST char *, int));

/* striparens.c */

extern char *strip_parens P_((CONST char *s));
extern char *get_parens   P_((CONST char *s));

/* strstr.c */

/* Why there is both in_string and strstr????
 *     - K E H <hurtta@ozone.FMI.FI>
 */

#ifndef STRSTR
extern char *strstr P_((char *,char *)); 
#endif

/* strtokq.c */

/* Why there is ' -- it is not quote character in mail.
 *    - K E H <hurtta@ozone.FMI.FI>
 */
extern char *strtokq P_((char *, char *,int));

/* tail_of.c */

extern int tail_of   P_((char *, char *, char *, int));

/* validname.c */

/* This is quite bogus   - K E H <hurtta@ozone.FMI.FI> */
int valid_name       P_((char *));

/* lib/charset.c */

#define SET_valid   0x0001 /* make possible to 'clear' previous defination */
#define SET_mark    0x0002 /* mark used by charset_compatfunc and          */
#define SET_printed 0x0004
#define SET_nodata  0x0008

#define MAX_charcode_parts 1

typedef struct charcode_info {
    uint16                      flags;
    char                    *   MIME_name;    
    struct charcode_info    *   parts [MAX_charcode_parts];
} * charset_t;

extern charset_t MIME_name_to_charset P_((char *name,int create));
extern int charset_compatfunc P_((char **value, int enter));
extern int charset_ok_p P_((charset_t ptr));
extern int load_charset_map_info P_((charset_t *buffer, CONST char *data));
extern int get_charset_map_info P_((char *buffer, CONST char *data,
				    int size));
extern int charset_superset_of P_((charset_t charset, charset_t subset));

extern struct locale_map_item {
    char       *match;
    charset_t  charset;
} * load_locale_map P_((CONST char *filename));
extern void dump_locale_map P_((FILE *f, struct locale_map_item *map));
extern char * mime_parse_content_opts P_((char *str));


/* lib/read_rc.c */

extern struct locale_map_item  * system_locale_map;
extern struct locale_map_item  * user_locale_map;

extern void locale_init P_((void));     /* sets locale and elm_msg_cat */
extern void user_init P_((void));       /* get username and home directory */
extern int init_defaults P_((void));
extern int read_rc_file  P_((void));
extern void post_init_check P_((void));  /* read_rc_file calls this */

extern char system_text_file[SLEN];      /* aliases.text */
extern char system_data_file[SLEN];      /* aliases */
extern char system_rc_file[SLEN];        /* elm.rc */
extern char system_mime_types[SLEN];     /* elm.mimetypes */
extern char hostdomfile[SLEN];           /* $lib/domain */
extern char system_mime_charsets[SLEN];  /* elm.mimecharsets */

extern char user_rc_file[SLEN];          /* .elm/elmrc */
extern char user_text_file[SLEN];        /* .elm/aliases.text */
extern char user_data_file[SLEN];        /* .elm/aliases */
extern char user_mime_types[SLEN];       /* .elm/mime.types */
extern char user_mailheaders[SLEN];      /* .elm/elmheaders */
extern char user_mime_charsets[SLEN];    /* .elm/mime.charsets */
extern char defaultfile[SLEN];	         /* name of default folder */
extern char calendar_file[SLEN];	/* name of file for clndr  */
extern char raw_calendar_file[SLEN];	/* unexpanded name of file for clndr  */

extern nl_catd elm_msg_cat;	/* message catalog	    */
extern int  clear_pages;	/* flag: clear screen w/ builtin pgr? */
extern int  title_messages;	/* flag: title message display?       */
extern int  debug;		/* flag: debugging mode on?           */
extern FILE *debugfile;		/* file for debut output    */
extern char home[SLEN];		/* home directory of user  */
extern char username[SLEN];	/* return address name!    */
extern int userid;		/* uid for current user	      */
extern int groupid;		/* groupid for current user   */
#ifdef SAVE_GROUP_MAILBOX_ID
extern int mailgroupid;		/* groupid for current user   */
#endif

/* *** Readed from elmrc: */

extern int  alias_sortby;	/* how to sort aliases        */
extern char alternative_editor[SLEN];/* the 'other' editor    */
extern struct addr_rec *alternative_addresses;	/* how else do we get mail? */
extern int  always_del;		/* flag: always delete marked msgs?   */
extern int  always_keep;	/* flag: always keep unread msgs?     */
extern int  always_store;	/* flag: always store read mail?      */
extern int  arrow_cursor;	/* flag: use "->" regardless?	      */
extern int  question_me;	/* flag: ask questions as we leave?   */
extern int  prompt_for_cc;	/* flag: prompt user for 'cc' value?  */
#ifdef USE_PGP
extern int pgp_askpgpsig;   /* Should pgp ask userid to sign messages with? */
extern int pgp_sign_type;   /* 0 = application/pgp
			       1 = text/plain
			       2 = text/x-pgp
			     */
enum pgp_version { pgp_none = 0, pgp2 = 1, pgp5 = 2, gpg = 3,
                   PGP_NUM };
extern enum pgp_version send_pgp_version; /* preferred pgp version*/
#endif
extern char attribution[SLEN];  /* attribution string for replies     */
extern int  auto_copy;		/* flag: auto copy source into reply? */
#ifdef BACKGROUD_PROCESSES       
extern int background_wait_time; /* If > 0 background mailer after
				  * this number of seconds
				  */
#endif
/* extern int  bounceback;	*/   /* flag: bounce copy off remote?      */
extern int  builtin_lines;	/* int use builtin pager?             */
extern char raw_charset[SLEN];	/* name of character set */
extern charset_t charset;	/* pointer to character set */
extern char config_options[SLEN];	/* which options are in o)ptions */
extern int  confirm_append;	/* flag: confirm append to folder?    */
extern int  confirm_create;	/* flag: confirm create new folder?   */
extern int  confirm_files;	/* flag: confirm files for append?    */
extern int  confirm_folders;	/* flag: confirm folders for create?  */
extern int  convert_comment;    /* flag: convert comment to fullname ?  */
extern int  auto_cc;		/* flag: mail copy to yourself?       */
extern char display_locale[SLEN];	/* LC_CTYPE locale (character set) */
extern char raw_display_charset[SLEN];
extern char default_display_charset[SLEN];
extern charset_t display_charset;	/* name of character set */
#ifdef USE_DSN
extern int DSN_success;         /* flag: Ask successfull DSNes      */
#endif
extern char e_editor[SLEN];	/* "~e" editor...   */
extern char editor[SLEN];	/* default editor for mail */
extern char raw_editor[SLEN];	/* unexpanded default editor for mail */
extern char escape_char;	/* '~' or something else...    */
extern int  force_name;		/* flag: save by name forced?	      */
extern int  allow_forms;	/* flag: are AT&T Mail forms okay?    */
extern char full_username[SLEN];/* Full username - gecos   */
extern char hostdomain[SLEN];	/* name of domain we're in */
extern char hostfullname[SLEN]; /* name of FQDN we're in */
extern char hostname[SLEN];	/* name of machine we're on*/
extern int  keep_empty_files;	/* flag: keep empty files??	      */
#ifdef USE_PGP
extern int pgp_keeppass;    /* should Elm keep the passphrase? */
#endif
/* extern int  hp_terminal; */	/* flag: are we on an hp terminal?    */
extern char local_signature[SLEN];/* local msg signature file   */
extern char raw_local_signature[SLEN];/* unexpanded local msg signature file */
extern int lockfolders;         /* Lock folder when open */
extern int lock_in_copy;        /* Lock folder when copied to it */
extern char folders[SLEN];	/* folder home directory   */
extern char raw_folders[SLEN];	/* unexpanded folder home directory   */
extern int  mail_permissions;	/* int: permissions for mailbox files   */
extern int  mini_menu;		/* flag: display menu?     	      */
extern char raw_metamail_path[SLEN];
extern char metamail_path[SLEN];  /* Metamail path or "none" if no metamail */
extern int  metoo;		/* flag: copy me on mail to alias?    */
extern int mimeforward;
extern int  move_when_paged;	/* flag: move when '+' or '-' used?   */
extern int  names_only;		/* flag: display names but no addrs?  */
extern int allow_no_encoding;       /* 1: Allow 8bit without -B8BITMIME
                                     * 2: Allow binary without -BBINARYMIME
                                     *    and 8bit without -B8BITMIME */
extern int allow_no_hdrencoding;    /* TRUE, if header encoding is 
				     * not required */
extern int  noheader;		/* flag: copy + header to file?       */
extern int  noheaderfwd;	/* flag: copy + header to file?(fwd)  */
extern int pagealternative;
extern int pagemultipart;
extern int pagesigned;
extern char pager[SLEN];	/* what pager to use...    */
extern char raw_pager[SLEN];	/* unexpanded what pager to use...    */
#ifdef USE_PGP
extern char pgp2_path[SLEN];    /* Pgp2 path or "none" if no pgp2 */
extern char raw_pgp2_path[SLEN];
extern char pgp5_dir[SLEN];   /* pgp5 binary directory or "none" if no pgp5 */
extern char raw_pgp5_dir[SLEN];
extern char gpg_path[SLEN];
extern char raw_gpg_path[SLEN];
#endif
extern int  point_to_new;	/* flag: start pointing at new msgs?  */
extern char allowed_precedences[SLEN];	/* list of precedences user may specify */
extern char prefixchars[SLEN];	/* prefix char(s) for msgs */
extern char printout[SLEN];	/* how to print messages   */
extern char raw_printout[SLEN];	/* unexpanded how to print messages   */
extern int  prompt_after_pager;	/* flag: prompt after pager exits     */
extern int  quote_forward;	/* flag: fwd'd msgs quoted like replies */
extern int  readdatapercentinc;	/* data percent increment during new mbox read */
extern int  readmsginc;		/* msg cnt increment during new mbox read */
extern char recvd_mail[SLEN];	/* folder for storing received mail	*/
extern char raw_recvdmail[SLEN];/* unexpanded recvd_mail name */
extern char remote_signature[SLEN];/* remote msg signature file */
extern char raw_remote_signature[SLEN];/* unexpanded remote msg signature file*/
extern int req_mime_bodyencoding;
extern int req_mime_hdrencoding;
extern int  resolve_mode;	/* flag: resolve before moving mode?  */
extern int  save_by_name;  	/* flag: save mail by login name?     */
extern char sent_mail[SLEN];	/* name of file to save copies to */
extern char raw_sentmail[SLEN];	/* unexpanded name of file to save to */
extern char shell[SLEN];	/* default system shell    */
extern char raw_shell[SLEN];	/* unexpanded default system shell    */
#ifdef USE_PGP
extern int pgp_noarmor;     /* Should Elm display text before PGP armor */
#endif
extern int  showto;
extern int  sig_dashes;		/* flag: put dashes above signature?  */
extern int  sleepmsg;		/* time to sleep for messages being overwritten on screen */
/* extern int  hp_softkeys; */	/* flag: are there softkeys?          */
extern int  sortby;		/* how to sort folders	      */
extern long elm_timeout;        /* seconds for main level timeout     */
extern int sort_thread_max_time; /* Number of days which can considered 
				    be same thread */
extern char temp_dir[SLEN];     /* name of temp directory */
extern char raw_temp_dir[SLEN]; /* unexpanded name of temp directory */
#ifdef USE_PGP
extern int pgp_keeppass;         /* should Elm keep the passphrase in*/
#endif
extern int  user_level;		/* flag: how knowledgable is user?    */
extern int  use_tite;		/* flag: use termcap/terminfo ti/te?  */
extern char v_editor[SLEN];	/* "~v" editor...   */
extern int  elm_filter;		/* flag: weed out header lines?	      */
extern int  send_mime_plain;    /* Send text/plain US-ASCII as MIME?  */
extern char *weedlist[MAX_IN_WEEDLIST];
extern int  weedcount;		/* how many headers to check?        */

/* lib/output.c */

#define FRM(format)  format,format
#define CATGETS(cat,set,def,format) format,catgets(cat,set,def,format) 

typedef int err_handler P_((CONST char *str));
extern int lib_error P_((CONST char * format, CONST char *msg, ...));
extern void set_error_handler P_((err_handler *h));

extern char *elm_vmessage P_((int max_alloc,
			      CONST char *format, CONST char *msg, 
			      va_list args));
extern char *elm_message P_((CONST char * format, CONST char *msg, ...));
extern int elm_sfprintf P_((char *buffer, int size,
			   CONST char * format, CONST char *msg, ...));


/* lib/forwarded.c */

void forwarded P_((char *buffer, struct header_rec *entry));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
