
static char rcsid[] = "@(#)$Id: edit.c,v 1.5 1998/12/21 12:52:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.5 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This routine is for allowing the user to edit their current folder
    as they wish.

**/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

extern int errno;

char   *error_description();
long   bytes();

#ifdef ALLOW_MAILBOX_EDITING

static void copy_failed_emergency_exit(cur_folder, edited_file)
char *cur_folder, *edited_file;
{
	int err = errno;

	MoveCursor(elm_LINES, 0);
	Raw(OFF);

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntCopyMailfile,
			  "\nCouldn't copy %s to mail file %s!\n"),
		  cur_folder, edited_file);

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCheckOutMail,
			  "\nYou'll need to check out %s for your mail.\n"),
		  edited_file);
	lib_error(FRM("** %s. **\n"), 
		  error_description(err));

	unlock(0,current_folder);			       /* ciao!*/
	emergency_exit(0);
}

edit_mailbox()
{
	/** Allow the user to edit their folder, always resynchronizing
	    afterwards.   Due to intense laziness on the part of the
	    programmer, this routine will invoke $EDITOR on the entire
	    file.  The mailer will ALWAYS resync on the folder
	    even if nothing has changed since, not unreasonably, it's
	    hard to figure out what occurred in the edit session...

	    Also note that if the user wants to edit their incoming
	    mailbox they'll actually be editing the tempfile that is
	    an exact copy.  More on how we resync in that case later
	    in this code.
	**/

	char	edited_file[SLEN], buffer[SLEN];
	int	len;

	if (!current_folder)
	  return;

	if(current_folder->folder_type == SPOOL) {
	  if(save_file_stats(current_folder->cur_folder) != 0) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPermFolder,
			      "Problems saving permissions of folder %s!"), 
		      current_folder->cur_folder);
	    sleep_message();
	    return(0);
	  }
	}

	strfcpy(edited_file,
		(current_folder->folder_type == NON_SPOOL ? 
		 current_folder->cur_folder : 
		 current_folder->cur_tempfolder),
		sizeof edited_file);
	if (edit_a_file(edited_file) == 0) {
	    return (0);
	}

	if (!reopen_folder_lock_sessionlock(current_folder)) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntOpenFolder,
			    "Couldn't open %s for reading!  Edit LOST!"), 
		    current_folder->cur_folder);
	  return(1);
	}

	if (current_folder->folder_type == SPOOL) {	/* uh oh... now the toughie...  */
	  if (bytes(current_folder->cur_folder) != 
	      current_folder->mailfile_size) {

	     /* SIGH.  We've received mail since we invoked the editor
		on the folder.  We'll have to do some strange stuff to
	        remedy the problem... */

	     PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
					    ElmWarnNewMailRecv,
					    "Warning: new mail received..."));
	     CleartoEOLN();

	     if (0 != fseek(current_folder->fh_temp,0,SEEK_END)) {
	       lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntSeekTemp,
				 "Couldn't seek to end of temp file. Edit LOST!"));
	       return(1);
	     }

	     if (fseek(current_folder->fh_folder, 
		       current_folder->mailfile_size, 0) == -1) {
	       dprint(1, (debugfile,
			  "Couldn't seek to end of cur_folder (offset %ld) (%s)\n",
			current_folder->mailfile_size, "edit_mailbox"));
	       lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCouldntSeekEnd,
				 "Couldn't seek to end of folder.  Edit LOST!"));

	       unlock(0,current_folder);
	       return(1);
	     }

	     /** Now we can finally stream the new mail into the tempfile **/

	     while ((len = mail_gets(buffer, SLEN, 
				     current_folder ->fh_folder)) != 0)
	       if (fwrite(buffer, 1, len, current_folder ->fh_temp) != len) {
	         copy_failed_emergency_exit(current_folder->cur_folder, 
					    current_folder->cur_tempfolder);
	       }

	     if (0 != fflush(current_folder->fh_temp)) {
	       copy_failed_emergency_exit(current_folder->cur_folder, 
					  current_folder->cur_tempfolder);
	     }
 	   } 

#ifdef SAVE_GROUP_MAILBOX_ID
      	   setgid(mailgroupid);
#endif

	   /* remove real mail_file and then
	    * link or copy the edited mailfile to real mail_file */

	   if (copy_to_folder(current_folder->fh_temp,current_folder) != 0) {
	     copy_failed_emergency_exit(current_folder->cur_folder, 
					current_folder->cur_tempfolder);
	   }

	   /* restore file permissions before removing lock */
	   
	   if(restore_file_stats(current_folder->cur_folder) != 1) {
	     lib_error(CATGETS(elm_msg_cat, ElmSet, ElmProblemsRestoringPerms,
			       "Problems restoring permissions of folder %s!"),
		       current_folder->cur_folder);
	     sleep_message();
	   }

#ifdef SAVE_GROUP_MAILBOX_ID
	   setgid(groupid);
#endif

	   unlock(0,current_folder);
	   lib_error(CATGETS(elm_msg_cat, ElmSet, ElmChangesIncorporated,
			     "Changes incorporated into new mail..."));

	} else
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmResyncingNewVersion,
			    "Resynchronizing with new version of folder..."));

	if (sleepmsg > 0)
		sleep(sleepmsg);
	ClearScreen();
	newmbox(current_folder->cur_folder, FALSE);
	showscreen();
	return(1);
}

#endif

int
edit_a_file(editfile)
char *editfile;
{
	/** Edit a file.  This routine is used by edit_mailbox()
	    and edit_aliases_text().  It gets all the editor info
	    from the elmrc file.
	**/

	char     buffer[SLEN];

	PutLineX(elm_LINES-1,0, CATGETS(elm_msg_cat, ElmSet, ElmInvokeEditor,
					"Invoking editor..."));

	if (strcmp(editor, "builtin") == 0 || strcmp(editor, "none") == 0) {
	  if (in_string(alternative_editor, "%s"))
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM(alternative_editor), editfile);
	  else
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("%s %s"), alternative_editor, editfile);
	} else {
	  if (in_string(editor, "%s"))
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM(editor), editfile);
	  else
	    elm_sfprintf(buffer, sizeof buffer,
			 FRM("%s %s"), editor, editfile);
	}

	Raw(OFF);

	if (system_call(buffer, SY_ENAB_SIGHUP) == -1) {
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmProblemsInvokingEditor,
			    "Problems invoking editor %s!"), 
		    alternative_editor);
	  Raw(ON);
	  if (sleepmsg > 0)
		sleep(sleepmsg);
	  return(0);
	}

	Raw(ON);
	/* a location not near the next request, so an absolute is used */
	SetXYLocation(0, 40);

	return(1);
}
