
static char rcsid[] = "@(#)$Id: init.c,v 1.3.6.1 1999/08/27 04:06:11 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.3.6.1 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/***** Initialize - read in all the defaults etc etc 
*****/

#include "headers.h"
#include "patchlevel.h"
#include "s_elm.h"

#include "me.h"

static void get_term_chars P_((void));

#ifdef TERMIOS
#  include <termios.h>
   typedef struct termios term_buff;
#else
# ifdef TERMIO
#  include <termio.h>
#  define tcgetattr(fd,buf)	ioctl((fd),TCGETA,(buf))
   typedef struct termio term_buff;
# else
#  include <sgtty.h>
typedef struct {
  struct sgttyb sgttyb;
  struct tchars tchars;
#ifdef TIOCLGET
  struct ltchars ltchars;
#endif
} term_buff;
static int tcgetattr P_((int,term_buff *));  /* Prototype */
# endif
#endif

#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

#include <errno.h>

extern int errno;		/* system error number on failure */
extern char version_buff[];

char *error_description();

#ifndef I_UNISTD 
char *getlogin();
unsigned short getgid(), getuid(); 
struct passwd *getpwuid();
#endif

char *get_full_name();

SIGHAND_TYPE
#ifdef SIGTSTP
	sig_user_stop(), sig_return_from_user_stop(),
#endif
#ifdef SIGWINCH
	winch_signal(),
#endif
	quit_signal(), term_signal(), ill_signal(),
	fpe_signal(), segv_signal(),
#ifdef SIGBUS
	bus_signal(),
#endif
	alarm_signal(), pipe_signal(), hup_signal(),
	usr1_signal(), usr2_signal() ;

extern void init_opts_menu();
extern void malloc_failed_exit();

void initialize(requestedmfile, size)
     char *requestedmfile;	/* first mail file to open, empty if the default */
     int size;
{
	register int init_scr_return; 
	char buffer[SLEN], *cp;

#if defined(SIGVEC) & defined(SV_INTERRUPT)
	struct sigvec alarm_vec;
#endif /* defined(SIGVEC) & defined(SV_INTERRUPT) */

	elm_sfprintf(version_buff, sizeof version_buff,
		     FRM("%s PL%s"), VERSION, PATCHLEVEL);
	def_ans_yes = catgets(elm_msg_cat, ElmSet, ElmYes, "y");
	def_ans_no = catgets(elm_msg_cat, ElmSet, ElmNo, "n");
	nls_deleted = catgets(elm_msg_cat, ElmSet, ElmTitleDeleted, "[deleted]");
	nls_form = catgets(elm_msg_cat, ElmSet, ElmTitleForm, "Form");
	nls_message = catgets(elm_msg_cat, ElmSet, ElmTitleMessage, "Message");
	nls_to = catgets(elm_msg_cat, ElmSet, ElmTitleTo, "To");
	nls_from = catgets(elm_msg_cat, ElmSet, ElmTitleFrom, "From");
	nls_page = catgets(elm_msg_cat, ElmSet, ElmTitlePage, "  Page %d");
	change_word = catgets(elm_msg_cat, ElmSet, ElmChange, "change");
	save_word = catgets(elm_msg_cat, ElmSet, ElmSave, "save");
	copy_word = catgets(elm_msg_cat, ElmSet, ElmCopy, "copy");
	cap_save_word = catgets(elm_msg_cat, ElmSet, ElmCapSave, "Save");
	cap_copy_word = catgets(elm_msg_cat, ElmSet, ElmCapCopy, "Copy");
	saved_word = catgets(elm_msg_cat, ElmSet, ElmSaved, "saved");
	copied_word = catgets(elm_msg_cat, ElmSet, ElmCopied, "copied");
	strfcpy(item, catgets(elm_msg_cat, ElmSet, Elmitem, "message"),
		sizeof item);
	strfcpy(items, catgets(elm_msg_cat, ElmSet, Elmitems, "messages"),
		sizeof items);
	strfcpy(Item, catgets(elm_msg_cat, ElmSet, ElmItem, "Message"),
		sizeof Item);
	strfcpy(Items, catgets(elm_msg_cat, ElmSet, ElmItems, "Messages"),
		sizeof Items);
	strfcpy(Prompt, catgets(elm_msg_cat, ElmSet, ElmPrompt, "Command: "),
		sizeof Prompt);

	/*
	 * Install the error trap to take if xmalloc() or friends fail.
	 */
	safe_malloc_fail_handler = malloc_failed_exit;

	init_opts_menu();
	init_scr_return = InitScreen();

	out_util_setup();
	/* save original user and group ids */
	userid  = getuid();
	groupid = getgid();	
#ifdef SAVE_GROUP_MAILBOX_ID
	mailgroupid = getegid();
	setgid(groupid);
#endif

	/* make all newly created files private */
	original_umask = umask(077);

	/* get username and home directory */
	user_init();

#ifdef DEBUG
	if (debug) {		/* setup for dprint() statements! */
	  char newfname[SLEN], filename[SLEN];
	  debugfile = stderr;

	  elm_sfprintf(filename, sizeof filename,
		       FRM("%s/%s"), 
		       home, DEBUGFILE);
	  if (access(filename, ACCESS_EXISTS) == 0) {	/* already one! */
	    sprintf(newfname,"%s/%s", home, OLDEBUG);
	    (void) rename(filename, newfname);
	  }

	  /* Note what we just did up there: we always save the old
	     version of the debug file as OLDEBUG, so users can mail
	     copies of bug files without trashing 'em by starting up
	     the mailer.  Dumb, subtle, but easy enough to do!
 	  */

	  if (0 != can_open(filename,"w") || 
	      (debugfile = fopen(filename, "w")) == NULL) {
	    debug = 0;	/* otherwise 'leave' will try to log! */
	    leave(fprintf(stderr, catgets(elm_msg_cat, ElmSet, ElmCouldNotOpenDebugFile,
					  "Could not open file %s for debug output!\n"),
			  filename));
	  }
	  (void) elm_chown(filename, userid, groupid); /* file owned by user */
	  
	  fprintf(debugfile, 
		  "Debug output of the ELM program (at debug level %d).  Version %s\n\n",
		  debug, version_buff);
	}
#endif

	/*
	 * If debug level is fairly low, ignore keyboard signals
	 * until the screen is set up.
	 */
	if (debug < 5) {
	  signal(SIGINT,  SIG_IGN);
	  signal(SIGQUIT, SIG_IGN);
	}

	if(!check_only && !batch_only) {
	  if (init_scr_return < 0) {
	    if (init_scr_return == -1) {
	      printf(catgets(elm_msg_cat, ElmSet, ElmNoTerm,
"Sorry, but you must specify what type of terminal you're on if you want to\n\
run the \"elm\" program. (You need your environment variable \"TERM\" set.)\n"));
	      dprint(1,(debugfile,"No $TERM variable in environment!\n"));
	    }
	    else if (init_scr_return == -2) {
	      printf(catgets(elm_msg_cat, ElmSet, ElmBadTerm,
"You need a cursor-addressable terminal to run \"elm\" and I can't find any\n\
kind of termcap entry for \"%s\" - check your \"TERM\" setting...\n"),
		   getenv("TERM"));
	      dprint(1,
		(debugfile,"$TERM variable is an unknown terminal type!\n"));
	    } else {
	      printf(catgets(elm_msg_cat, ElmSet, ElmTermInitFailed,
		"Failed trying to initialize your terminal entry: unknown return code %d\n"), init_scr_return);
	      dprint(1, (debugfile, "Initscreen returned unknown code: %d\n",
		  init_scr_return));
	    }
	    exit(1);	/* all the errors share this exit statement */
	  }
	}

	if (debug < 5) {	/* otherwise let the system trap 'em! */
	  signal(SIGQUIT, quit_signal);		/* Quit signal 	            */
	  signal(SIGTERM, term_signal); 	/* Terminate signal         */
	  signal(SIGILL,  ill_signal);		/* Illegal instruction      */
	  signal(SIGFPE,  fpe_signal);		/* Floating point exception */
#ifdef SIGBUS
	  signal(SIGBUS,  bus_signal);		/* Bus error  		    */
#endif
	  signal(SIGSEGV, segv_signal);		/* Segmentation Violation   */
	  signal(SIGHUP,  hup_signal);		/* HangUp (line dropped)    */
	  signal(SIGUSR1, usr1_signal);		/* User request 1	    */
	  signal(SIGUSR2, usr2_signal);		/* User request 2	    */
	}
	else {
	  dprint(3,(debugfile,
  "\n*** Elm-Internal Signal Handlers Disabled due to debug level %d ***\n\n",
		    debug));
	}
#if !defined(POSIX_SIGNALS) & defined(SIGVEC) & defined(SV_INTERRUPT)
	bzero((char *) &alarm_vec, sizeof(alarm_vec));
	alarm_vec.sv_handler = alarm_signal;
	alarm_vec.sv_flags = SV_INTERRUPT;
	sigvec (SIGALRM, &alarm_vec, (struct sigvec *)0);	/* Process Timer Alarm	    */
#else /* defined(SIGVEC) & defined(SV_INTERRUPT) */
	signal(SIGALRM, alarm_signal);		/* Process Timer Alarm      */
#endif /* defined(SIGVEC) & defined(SV_INTERRUPT) */
	signal(SIGPIPE, pipe_signal);		/* Illegal Pipe Operation   */
#ifdef SIGTSTP
	signal(SIGTSTP, sig_user_stop);		/* Suspend signal from tty  */
	signal(SIGCONT, sig_return_from_user_stop);	/* Continue Process */
#endif
#ifdef SIGWINCH
	signal(SIGWINCH, winch_signal);		/* change screen size */
#endif

#ifdef BACKGROUD_PROCESSES
	init_backgroud_handling();
#endif

	get_term_chars();


	/* Determine options that might be set in the global elmrc */
	if (init_defaults() != 0) {
	  sleep(1);
	}

	/* Determine options that might be set in the .elm/elmrc */
	if (read_rc_file() != 0) {
	  sleep(1);
	  if (!batch_only && !write_elmrc) {
	    printf("Fix .elm/elmrc or let elm rebuild elmrc with option '-w'\n");
	    exit(1);
	  }
	}
	
	if (!Check_attachments())
	  exit(1);

	/* Check if .elm and Mail directories exists */
	directory_check();

	if (write_elmrc) {
	  save_options();
	  sleep(1);
	}

	/* Now that we've read the rc file we can enter RAW mode */
	if (!batch_only && !check_only)
	    Raw(ON);

	/* Determine the mail file to read */
	if (*requestedmfile == '\0')
	  strfcpy(requestedmfile, defaultfile, size);
	else if(!expand_filename(requestedmfile, FALSE,
				 size)) {
	    Raw(OFF);
	    exit(0);
        }
	if (check_size)
	  if(check_mailfile_size(requestedmfile) != 0) {
	      Raw(OFF);
	      exit(0);
	  }

	/* check for permissions only if not send only mode file */
	if (! mail_only) {
	  if ((errno = can_access(requestedmfile, READ_ACCESS)) != 0) {
	    if (strcmp(requestedmfile, defaultfile) != 0 || errno != ENOENT) {
	      Raw(OFF);
	      dprint(1, (debugfile,
		    "Error: given file %s as folder - unreadable (%s)!\n", 
		    requestedmfile, error_description(errno)));
	      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantOpenFolderRead,
				"Can't open folder '%s' for reading!\n"),
			requestedmfile);
	      exit(1);
	    }
	  }
	}

	/** check to see if the user has defined a LINES or COLUMNS
	    value different to that in the termcap entry (for
	    windowing systems, of course!) **/

	ScreenSize(&elm_LINES, &elm_COLUMNS);

	/* WARNING: elm_LINES and elm_COLUMNS are inconsistent!
	 *
	 * elm_LINES    == number of lines in screen -1
	 * elm_COLUMNS  == number of rows in screen
	 *
	 *
	 * Check code in MoveCursor!
	 *
	 * row          == 0 .. elm_LINES
	 * col          == 0 .. elm_COLUMNS-1
	 *
	 *
	 * Who was this smart programmer!!!!!!!!!!!!!!!!!!!!!
	 *
	 *                         - K E H <hurtta@ozone.FMI.FI>
	 */

	if ((cp = getenv("LINES")) != NULL && isdigit(*cp)) {
	  sscanf(cp, "%d", &elm_LINES);
	  elm_LINES -= 1; 
	}

	if ((cp = getenv("COLUMNS")) != NULL && isdigit(*cp))
	  sscanf(cp, "%d", &elm_COLUMNS);

	/** fix the shell if needed **/

	if (shell[0] != '/') {
	   elm_sfprintf(buffer, sizeof buffer,
			FRM("/bin/%s"), 
			shell);
	   strfcpy(shell, buffer, sizeof shell);
	}

	/** clear the screen **/
	if(!check_only && !batch_only)
	  ClearScreen();

	if (! mail_only && ! check_only) {
	  if (mini_menu)
	    headers_per_page = elm_LINES - 13;
	  else
	    headers_per_page = elm_LINES -  8;	/* 5 more headers! */

	  if (headers_per_page <= 0) {
	    Raw(OFF);
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmWindowSizeTooSmall,
			      "The window is too small to run Elm.  It must have at least %d rows"),
		 1 + elm_LINES - headers_per_page);
	    exit(1);
	  }
	  newmbox(requestedmfile, FALSE);	/* read in the folder! */
	}

#ifdef DEBUG
	if (debug >= 2 && debug < 10) {
	  fprintf(debugfile,
"hostname = %-20s \tusername = %-20s \tfullname = %-20s\n",
	         hostname, username, full_username);

	  fprintf(debugfile,
"home     = %-20s \teditor   = %-20s \trecvd_mail  = %-20s\n",
		 home, editor, recvd_mail);

	  fprintf(debugfile,
		  "folders  = %-20s \tprintout = %-20s\n",
		  folders, printout);
	
	  fprintf(debugfile,
"sent_mail = %-20s \tprefix   = %-20s \tshell    = %-20s\n\n",
		sent_mail, prefixchars, shell);
	
	  if (local_signature[0])
	    fprintf(debugfile, "local_signature = \"%s\"\n",
			local_signature);
	  if (remote_signature[0])
	    fprintf(debugfile, "remote_signature = \"%s\"\n",
			remote_signature);
	  if (local_signature[0] || remote_signature[0])
	    fprintf(debugfile, "\n");
	}
#endif
}

static void get_term_chars()
{
	/** This routine sucks out the special terminal characters
	    ERASE and KILL for use in the input routine.  The meaning 
            of the characters are (dare I say it?) fairly obvious... **/

	term_buff term_buffer;

	if (tcgetattr(STANDARD_INPUT,&term_buffer) == -1) {
	  dprint(1, (debugfile,
		   "Error: %s encountered on ioctl call (get_term_chars)\n", 
		   error_description(errno)));
	  /* set to defaults for terminal driver */
	  backspace = BACKSPACE;
	  kill_line = ctrl('U');
	  word_erase = ctrl('W');
 	  interrupt_char = 0177;	/* DEL */
 	  reprint_char = ctrl('R');
 	  eof_char = ctrl('D');
	}
	else {
#if defined(TERMIO) || defined(TERMIOS)
	  backspace = term_buffer.c_cc[VERASE];
	  kill_line = term_buffer.c_cc[VKILL];
#if   defined(TERMIOS) && defined(VWERASE)
	  word_erase = term_buffer.c_cc[VWERASE];
#else
	  word_erase = ctrl('W');
#endif
 	  interrupt_char = term_buffer.c_cc[VINTR];
#if defined(TERMIOS) && defined(VREPRINT)
	  reprint_char = term_buffer.c_cc[VREPRINT];
#else
	  reprint_char = ctrl('R');
#endif
	  eof_char = term_buffer.c_cc[VEOF];
#else
	  backspace = term_buffer.sgttyb.sg_erase;
	  kill_line = term_buffer.sgttyb.sg_kill;
#ifdef     TIOCLGET
 	  word_erase = term_buffer.ltchars.t_werasc;
	  reprint_char = term_buffer.ltchars.t_rprntc;
#else
	  word_erase = ctrl('W');
	  reprint_char = ctrl('R');
#endif
	  interrupt_char = term_buffer.tchars.t_intrc;
	  eof_char = term_buffer.tchars.t_eofc;
#endif
	}
}

#if !defined(TERMIO) && !defined(TERMIOS)
static int
tcgetattr(fd, buf)
     int fd;
     term_buff *buf;
{
	if (ioctl(fd, TIOCGETP, &buf->sgttyb) < 0)
	  return(-1);
	if (ioctl(fd, TIOCGETC, &buf->tchars) < 0)
	  return(-1);
#ifdef TIOCLGET
	if (ioctl(fd, TIOCLGET, &buf->ltchars) < 0)
	  return(-1);
#endif
	return(0);
}
#endif

