/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "mime.h"

static gchar base64_chars[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
extern GList *mime_parts;

gchar *decode_base64 (gchar *data, gint *length)
{
   /* This function is Copyright (C) 1999 by Jussi Junni of GnoMail */
   gchar *output, *workspace, *p;
   gulong pos = 0;
   gint i, a[4], len = 0;

   g_return_val_if_fail (data != NULL, NULL);

   workspace = g_new (gchar, (strlen (data) / 4) * 3 + 1);
   memset (workspace, 0, (strlen (data) / 4) * 3 + 1);

   while (*data && len < *length)
   {
      for (i = 0; i < 4; i++, data++, len++)
      {
         if ((p = strchr (base64_chars, *data)))
            a[i] = (gint)(p - base64_chars);
         else
            i--;
      }

      workspace[pos]     = (((a[0] << 2) & 0xfc) | ((a[1] >> 4) & 0x03));
      workspace[pos + 1] = (((a[1] << 4) & 0xf0) | ((a[2] >> 2) & 0x0f));
      workspace[pos + 2] = (((a[2] << 6) & 0xc0) | (a[3] & 0x3f));
  
      if (a[2] == 64 && a[3] == 64)
      {
         workspace[pos + 1] = 0;
         pos -= 2;
      }
      else
      {
         if (a[3] == 64)
         {
            workspace[pos + 2] = 0;
            pos--;
         }
      }
      pos += 3;
   }

   output = g_new (gchar, pos + 1);
   memcpy (output, workspace, pos);

   *length = pos;

   g_free (workspace);
    
   return output;
}

gchar *encode_base64(gchar *message, gint *length)
{
	gchar *encoded, *index, buffer[3];
	gint pos, len;

	encoded = g_malloc(sizeof(char)*(gint)(*length * 1.40)); /* it gets 33% larger */
	pos = 0;
	len = 0;
	index = message;
	while(index-message < *length)
	{
		memcpy(buffer, index, 3);
		
		*(encoded+pos)   = base64_chars[(buffer[0] >> 2) & 0x3f];
		*(encoded+pos+1) = base64_chars[((buffer[0] << 4) & 0x30) | 
					((buffer[1] >> 4) & 0xf)];
		*(encoded+pos+2) = base64_chars[((buffer[1] << 2) & 0x3c) |
					((buffer[2] >> 6) & 0x3)];
		*(encoded+pos+3) = base64_chars[buffer[2] & 0x3f];

		len += 4;

		/* base64 can only have 76 chars per line */
		if (len >= 76)
		{
			*(encoded + pos + 4) = '\n';
			pos++;
			len = 0;
		}

		pos += 4;
		index += 3;
	}

	/* if there were less then a full triplet left, we pad the remaining
	 * encoded bytes with = */
	if (*length % 3 == 1) {
		*(encoded+pos-1) = '=';
		*(encoded+pos-2) = '=';
	}
	if (*length % 3 == 2) {
		*(encoded+pos-1) = '=';
	}
	
	*(encoded+pos) = '\n';
	*(encoded+pos+1) = '\0';
	
	*length = strlen(encoded);
	
	return encoded;
}

gchar *decode_quoted_printable (gchar *message, gint *length)
{
   gchar *buffer, *index, ch[2];
   gint i = 0, temp;

   buffer = g_malloc(*length + 1);
   index = message;

   while(index - message < *length)
   {
      if(*index == '=')
      {
         index++;
         if(*index != '\n')
         {
            sscanf(index, "%2x", &temp);
            sprintf(ch, "%c", temp);
            buffer[i] = ch[0];
         }
         else
            buffer[i] = index[1];
         i++;
         index += 2;
      }
      else
      {
         buffer[i] = *index;
         i++;
         index++;
      }
   }
   buffer[i] = '\0';

   *length = strlen(buffer);

   return buffer;
}

gint mime_detect (gchar *message)
{
   gchar *version;
   gchar *buffer;
   gint major, minor;

   /* if we detect the MIME-Version: field, this message is mime formatted */
   version = mailbox_get_mesg_header_field(message, "MIME-Version:");
   if (version == NULL)
      return 0;

   buffer = get_field(version, 1, '.');
   major = atoi(buffer);
   g_free(buffer);
   buffer = get_field(version, 2, '.');
   minor = atoi(buffer);
   g_free(buffer);

   /* if the version isn't 1.0 this is either some old mail or in the future
    * a mail with a newer mime spec that we dont support. We just output
    * a warning and try to parse it anyway. */
   if (major != 1 || minor != 0)
      printf(_("Warning: unknown Mime-Version %d.%d\n"), major, minor);

	return 1;
}

/* this parses the mime mail, and puts the parts into a GList */
gint mime_parse(gchar *message)
{
   gchar *content_type, *content_transfer_e, *index, *body, *boundary_pos;
   gchar type[64], subtype[64], parameter[128], boundary[128];
   gint i, pos, ret;
   struct mime_part *part;
   GList *tmp;

   tmp = mime_parts;
   while(tmp != NULL)
   {
      g_free(tmp->data);
      tmp = tmp->next;
   }
   if(mime_parts != NULL)
   {
      g_list_free(mime_parts);
      mime_parts = NULL;
   }

   /* if there aren't a Content-Type: field, we assume text/plain, so
    * mime_get_first_text() will find it */
   content_type = mailbox_get_mesg_header_field(message, "Content-Type:");
   if(content_type != NULL)
      mime_parse_content_type(content_type, type, subtype, parameter);
   else
   {
      strcpy(type, "text");
      strcpy(subtype, "plain");
   }

   if(!g_strcasecmp(type, "multipart"))
   {
      ret = mime_get_parameter_value(parameter, "boundary", boundary);
      /* no boundary? if this happens someone is sending us broken mail */
      if(!ret)
         return 0;
      
      body = strstr(message, "\n\n") + 2;
      i = 0;
      while((index = strstr(body + i, boundary)) != NULL)
      {
         /* this is the end marking boundary, which has two - appended. */
         if(*(index + strlen(boundary)) == '-' && *(index + strlen(boundary) + 1) == '-')
            break;

         part = g_malloc0(sizeof(struct mime_part));
         part->pos = strstr(index, "\n\n") + 2 - message;
         content_type = mailbox_get_mesg_header_field(index + strlen(boundary), "Content-Type:");
         if(content_type != NULL)
            mime_parse_content_type(content_type, type, subtype, parameter);
         else
         {
            strcpy(type, "text");
            strcpy(subtype, "plain");
         }
         content_transfer_e = mailbox_get_mesg_header_field(index + strlen(boundary), "Content-Transfer-Encoding:");
         		
         if(content_transfer_e != NULL)
            strncpy(part->encoding, content_transfer_e, 63);
         else
            strcpy(part->encoding,"7bit");
         strncpy(part->type, type, 63);
         strncpy(part->subtype, subtype, 63);
         strncpy(part->parameter, parameter, 127);
         
         i = index - body + strlen(boundary);
         boundary_pos = strstr(body + i, boundary);
         /* some mailers apperently doesn't put an end boundary marker */
         if (boundary_pos == NULL)
         {
         	boundary_pos = body + i;
         	while(*boundary_pos != '\0')
         		boundary_pos++;
         }
         
         part->len = boundary_pos - (strstr(index, "\n\n") + 2) - 2;
         mime_parts = g_list_append(mime_parts, part);
      }
   }
   else
   {
      part = g_malloc0(sizeof(struct mime_part));
      pos = strstr(message, "\n\n") - message;
      strncpy(part->type, type, 63);
      strncpy(part->subtype, subtype, 63);
      strncpy(part->parameter, parameter, 127);
      content_transfer_e = mailbox_get_mesg_header_field(message, "Content-Transfer-Encoding:");

      if(content_transfer_e != NULL)
         strncpy(part->encoding, content_transfer_e, 63);
      else
         strcpy(part->encoding, "7bit");
      part->pos = pos + 2;
      index = message + part->pos;
      i = 0;
      while(*index != '\0')
      {
         i++;
         index++;
      }
      part->len = i; 
      mime_parts = g_list_append(mime_parts, part);
   }

   return 1;
}

/* returns the num:th part (if existant) */
gchar *mime_get_part(gchar *message, gint num, gint *in_len)
{
   gchar *part, *index, *temp, *ptr, *decoded;
   GList *tmp;
   gint i, len;
   struct mime_part *m_part;

   i = 1;
   tmp = mime_parts;
   while(tmp != NULL && i != num)
   {
      i++;
      tmp = tmp->next;
   }

   if (i < num || tmp == NULL)
      return (gchar *)NULL;

   m_part = tmp->data;

   part = g_malloc(m_part->len + 1);

   index = message + m_part->pos;

   if(!g_strcasecmp(((struct mime_part *)tmp->data)->encoding, "base64"))
   {
      len = m_part->len;
      /* remove all enters, decode_base64 doesn't like them */
      for(temp = index, i = 0; *temp != '\0' && i < len; temp++, i++)
      {
         if(*temp == '\n')
         {
            for(ptr = temp; *ptr != '\0'; ptr++)
               *ptr = *(ptr + 1);
            len--;
         }
      }

      //len = len - 1;
      decoded = decode_base64(index, &len);
      memcpy(part, decoded, len);
      part[len] = '\0';
      g_free(decoded);
      *in_len = len;
   }
   else
      if(!g_strcasecmp(((struct mime_part *)tmp->data)->encoding, "quoted-printable"))
      {
         len = m_part->len;
         decoded = decode_quoted_printable(index, &len);
         strcpy(part, decoded);
         g_free(decoded);
         *in_len = len;
      }
      else
      {
         i = 0;
         while(*index != '\0' && i < m_part->len)
         {
            part[i] = *index;
            index++;
            i++;
         }
         part[i] = '\0';
         *in_len = strlen(part);
      }

   return (gchar *)part;
}

gint mime_parse_content_type(gchar *content_type, gchar *type, gchar *subtype, gchar *parameter)
{
   gchar *index, *start;
   gint len, i;

   if(content_type == NULL)
      return 0;

   len = strlen(content_type);

   start = index = content_type;

   /* copy the type */
   i = 0;
   while(*index != '/' && index - start < len)
   {
      type[i] = *index;
      i++;
      index++;
   }
   type[i] = '\0';

   /* copy the subtype */
   index++;
   i = 0;
	while(*index != ';' && index - start < len)
   {
      subtype[i] = *index;
      index++;
      i++;
   }
   subtype[i] = '\0';

   index++;
   while(isspace(*index))
      index++;

   /* copy the parameters */
   i = 0;
   while(*index != '\0' && index - start < len)
   {
      parameter[i] = *index;
      index++;
      i++;
   }
   parameter[i] = '\0';

   return 1;
}

gint mime_get_parameter_value (gchar *parameter, gchar *in_name, gchar *out)
{
   gchar *index, name[64], val[128];
   gint i, found, len;

   index = parameter;
   len = strlen(parameter);
   while(*index != '\0' && index - parameter < len)
   {
      found = 0;
      /* skip until a ascii char */
      while(!isalnum(*index))
      {
		index++;
      }
      
      i = 0;
      while(*index != '=' && i < 63)
      {
         name[i] = *index;
         index++;
         i++;
      }
      name[i]='\0';

      if(!g_strcasecmp(in_name, name))
      {
         found=1;
      }
		
      index++;
      /* parameters can be either name=val or name="val", we can handle both */
      if(*index != '"')
      {
         i = 0;
         while(*index != ';' && i < 127)
         {
            val[i] = *index;
            index++;
            i++;
         }
         val[i] = '\0';
         if(found)
         {
            strncpy(out, val, 127);
            out[127] = '\0';
            return 1;
         }
      }
      else
      {
         index++;
         i = 0;
         while(*index != '"' && i < 127)
         {
            val[i] = *index;
            index++;
            i++;
         }
         val[i] = '\0';

         if (found)
         {
            strncpy(out, val, 127);
            out[127] = '\0';
            return 1;
         }
         
        
      }
		index += 2;		
   }

   return 0;	
}

/* returns the number of the first text/ part */
gint mime_get_first_text(void)
{
   GList *tmp;
   gint i;

   i = 1;
   tmp = mime_parts;
   while(tmp != NULL)
   {
      if(!g_strcasecmp(((struct mime_part *)tmp->data)->type, "text"))
         return i;
		i++;
      tmp = tmp->next;
   }

   return 0;
}

/* generates a random boundary */
gchar *mime_get_boundary (void)
{
	static gchar boundary[128];
	gchar *index;
	gint i;

	srand(time(NULL) + getpid());
	memset(boundary, 0, sizeof(boundary));
	
	sprintf(boundary, "spruce");
	index = boundary + 6;
	i = 0;
	while (i < 20)
	{
		*(index+i) = (rand() % 26) + 65;
		i++;
	}
	*(index+i) = '\0';
	
	return boundary;
}

gint mime_insert_part (gchar **message, gint index, gchar *boundary, gchar *file)
{
	FILE *fp;
	struct stat st;
	gint ret, i, x;
	guint size;
	gchar *buffer, *encoded;
	gchar content_type[64];
	gchar content_transfer_encoding[64];

	ret = stat(file, &st);
	if (ret < 0) {
		printf (_("Couldn't stat %s"), file);
		return 0;
	}

	size = st.st_size;
	
	/* this should be autodetected , so we would use text/plain and quoted-printable
	 * for attached text files and so on */
	g_snprintf(content_type, 64, "application/octet-stream; name=\"%s\"", g_basename(file));
	strcpy(content_transfer_encoding, "base64");

	fp = fopen(file, "rt");
	if (fp == NULL)
	{
		printf(_("Couldn't open %s\n"), file);
		return 0;
	}

	/* todo: it isn't very convinient to load all the file into memory at once 
	 * if the file is very large, 10 meg or something. (But who 
	 * would attach such a file?) */
	buffer = g_malloc0(sizeof(char) * (size + 1));

	fread (buffer, 1, size, fp);
	fclose(fp);
	buffer[size] = '\0';

	encoded = encode_base64(buffer, &size);
	g_free(buffer);
	

	/* we realloc the string so it can hold the encoded data + the boundary + 
	 * the part header */
	message[0] = g_realloc (message[0], strlen(message[0]) + strlen(boundary) + strlen(encoded) + strlen(content_type) + strlen(content_transfer_encoding) + strlen(g_basename(file)) + 100);

	i = x = 0;
	/* ok, here goes the part header */
	i += sprintf(message[0]+index+i, "--%s\n", boundary);
	i += sprintf(message[0]+index+i, "Content-Type: %s\nContent-Transfer-Encoding: %s\n", content_type, content_transfer_encoding);
	i += sprintf(message[0]+index+i, "Content-Disposition: attachment; filename=\"%s\"\n\n", g_basename(file));

	while (*(encoded+x) != '\0')
	{
		*(message[0]+index+i) = *(encoded+x);
		i++;
		x++;
	}
	*(message[0]+index+i) = '\0';

	g_free(encoded);
	
	return strlen(message[0]+index);
}
