/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "server.h"

gint Resolve (Server *server)
{
   /* Resolves server->hostname to it's corresponding IPv4 IP address.
    * The IP address is stored in server->ip if successful.
    * Returns SUCCESS (1) or ERROR (0).
   */
   struct hostent *ptr_host;

   if ( (ptr_host = gethostbyname(server->hostname)) == NULL)
      return ERROR;

   memcpy(&server->sin.sin_addr, ptr_host->h_addr, ptr_host->h_length);
   g_snprintf(server->ip, sizeof(server->ip), "%s", inet_ntoa(server->sin.sin_addr));

   return SUCCESS;
}

gint resolve (gchar *host_ip, gchar *hostname)
{
   /* Resolves "hostname" to it's corresponding IPv4 IP address.
    * The IP address is stored in *host_ip if successful.
    * Returns SUCCESS (1) or ERROR (0).
   */
   struct hostent *ptr_host;
   struct sockaddr_in sin;

   if ( (ptr_host = gethostbyname(hostname)) == NULL)
      return ERROR;
	
	memcpy(&sin.sin_addr, ptr_host->h_addr, ptr_host->h_length);
   g_snprintf(host_ip, sizeof(host_ip), "%s", inet_ntoa(sin.sin_addr));

   return SUCCESS;
}

gint ipv4_resolve (gchar *host_ip, gchar *hostname)
{
   /* resolve the hostname into an actual IPv4 address */
   gint ip1, ip2, ip3, ip4;
   struct hostent *ptr_host;      /* pointer to remote host */

   /* separate the parts of the ip */
   if (sscanf(hostname, "%d.%d.%d.%d", &ip1, &ip2, &ip3, &ip4) != 4)
   {
      /* uh-oh, there weren't 4 parts to the ip... */
      ptr_host = gethostbyname(hostname);   /* lets see if we can find the host */
      if (ptr_host == NULL)                 /* if the ip doesn't resolve */
         return ERROR;

      /* print the ip into a string */
      sprintf(host_ip, "%d.%d.%d.%d", (unsigned char) ptr_host->h_addr_list[0][0],
              (unsigned char) ptr_host->h_addr_list[0][1], 
              (unsigned char) ptr_host->h_addr_list[0][2], 
              (unsigned char) ptr_host->h_addr_list[0][3]);
   } 
   else                           /* there were 4 parts to the ip... */
      strcpy(host_ip, hostname);     /* lets copy it into the host variable */

   return SUCCESS;
}
