# $Id: entry.tcl,v 1.17 1998/09/30 00:36:37 cthulhu Exp $ 
#
#

#
# Displays the entry line
#

proc displayEntry {mother nextone sheet} {
    source [xxl_library]/globalvars.tcl
    global entryFont

    frame $mother.entry

    entry $mother.entry.active -relief sunken \
            -textvariable activeText($sheet)  -width 50 -bg white \
            -cursor pencil -font $entryFont
    bind $mother.entry.active <Enter> \
	{HelpMessage "Data entry area - use to insert text, data and formulas"}

    button $mother.entry.delete -image cross_bm \
            -command {set globalState normal ; nextCell}      
    bind $mother.entry.delete <Enter> \
	{HelpMessage "Cancel data entry"}
    button $mother.entry.check -image check_bm \
            -command {stateMachine %W returnInEntry}
    bind $mother.entry.check <Enter> \
	{HelpMessage "Click to insert data in currently selected cell"}
    pack $mother.entry -side left -anchor w -before $nextone
    


    label $mother.entry.help_msg -textvariable helpMessage -fg blue
    pack $mother.entry.active $mother.entry.delete $mother.entry.check \
	$mother.entry.help_msg -side left 
    set helpMessage Ready
    set auxHelpMessage Ready

    bind $mother.entry.active <Return> \
            "stateMachine %W returnInEntry"
    bind $mother.entry.active <Key-equal> \
            "stateMachine %W equal %A"
    bind $mother.entry.active <Key> \
            "stateMachine %W keyInEntry %A"
    bind $mother.entry.active <ButtonPress-1> \
            "stateMachine %W PressInEntry"

    createCompositeBindings Entry
}

proc createCompositeBindings { widget } {
    bind $widget <Escape>\'a {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'e {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'i {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'o {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'u {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\~a {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\~o {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\,c {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\`a {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\^a {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\^e {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }

    bind $widget <Escape>\'A {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'E {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'I {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'O {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\'U {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\~A {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\~O {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\,C {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\`A {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\^A {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }
    bind $widget <Escape>\^E {
        set x [%W index insert] ; 
        %W icursor [expr $x-1] ; 
        %W delete insert ; 
        %W insert insert  ; 
        break ;
    }



}

proc insertTextInEntry {mother text flag} {
    global position size


    if {$flag == 0} {
        set position [$mother.entry.active index insert]
        $mother.entry.active insert $position $text
    } else {
        $mother.entry.active delete $position [expr $position+$size]
        $mother.entry.active icursor $position
        $mother.entry.active insert $position $text
    }
    set size [string length $text]
}


#
#$Log: entry.tcl,v $
#Revision 1.17  1998/09/30 00:36:37  cthulhu
#auxHelpMessage now starts at Ready.
#
#Revision 1.16  1998/08/24 18:33:44  cthulhu
#Added tooltips.
#
#Revision 1.15  1998/08/06 21:08:30  aml
#Released alpha version of Abacus.
#
#Revision 1.14  1997/03/27 10:00:34  aml
#Started implementing graphs.
#Fixed bug in tkCanvasPs.c
#Created bindings for composite characters in Portuguese.
#
#Revision 1.13  1997/01/07 01:07:40  aml
#Error propagation for formulas fixed.
#Edit operations in place.
#
#Revision 1.12  1996/12/11 21:39:56  aml
#Sumif implemented.
#Diverse time functions implemented.
#Fixed needtoscroll2 to avoid out of control scroll.
#
#Revision 1.11  1996/11/22 16:29:09  aml
#First cut at transforming canvas into a true cell widget.
#Text, lines and rectangles are now relative to row and colunm numbers.
#It still has a bug with wrong estimation of column widths.
#
#Revision 1.10  1996/09/04 14:29:50  aml
#Fixed double redrawing of sheets that was taking place.
#Fixed a item reference problem when the sheet is redrawn.
#Fixed misplacement of row labels.
#Created first version of format toolbar.
#
#Revision 1.9  1996/08/29 12:05:21  aml
#Fixed problem with initialization of formulas.
#Insertion in entry is now done properly.
#Focus is slightly better handled.
#Fixed serious problem when canvas changes name and old
#references exist. Also removed double call to redraw that
#was slowing things a lot.
#
#Revision 1.8  1996/04/27 11:12:33  aml
#Inserted check and delete button.
#Font selection widget created.
#Fixed bug canvas_information destructor.
#
#Revision 1.7  1996/04/23 09:42:48  aml
#Data structures for ordered scans of rows and columns are in place.
#Cell overlap is working.
#Forward cell dependences inserted. Automatic recalculation created.
#Uniformizaed label entry procedure.
#
#Revision 1.6  1996/02/16 23:09:31  aml
#Improved user interf state machine.
#Centralized range definitions.
#Range defined outiside current view work properly.
#
# Revision 1.5  1996/02/13  21:55:18  aml
# Fixed problems with change to elf.
# RangeCopy created. Works !
# Pressed mouse leaving canvas will cause scroll. Works, but needs to
# keep moving.
#
# Revision 1.4  1996/01/27  23:10:24  aml
# CellCopy created.
# CellGet fixed.
# Tcl range operators created.
# User interface improved. Cell references and ranges
# can now be defined with the mouse.
#
# Revision 1.3  1996/01/10  18:53:40  aml
# Fixed limited integer range of cells.
# Fixed incorrect code in spreadsheet type.
# Users interface improved. Cursors and mouse clicks
# now work in the most basic modes.
#
# Revision 1.2  1995/12/14  12:13:02  aml
# Version 0.4.2
#
# Revision 1.1  1995/12/06  12:02:15  aml
# Initial revision
#
#
