.\"
.\" Copyright (c) 1993 David I. Bell and Landon Curt Noll
.\" Original man page dated 15nov93
.\" Copyright (c) 1999 David I. Bell and Landon Curt Noll
.\" Permission is granted to use, distribute, or modify this source,
.\" provided that this copyright notice remains intact.
.\"
.\" calculator by David I. Bell
.\" man page by Landon Noll
.TH calc 1 "^..^" "15Oct1999"
.SH NAME
calc \- arbitrary precision calculator
.SH SYNOPSIS
\fIcalc\fP
.RB [ \-c ]
.RB [ \-C ]
.RB [ \-d ]
.RB [ -D\ \&calc_debug[:lib_debug:[user_debug]] ]
.br
.in +5n
.RB [ \-e ]
.RB [ \-h ]
.RB [ \-i ]
.RB [ \-m\ \&mode ]
.RB [ \-n ]
.RB [ \-p ]
.RB [ \-q ]
.RB [ \-u ]
.RB [ \-v ]
.br
.RB [ calc_cmd\ \&.\|.\|. ]
.in -5n
.SH DESCRIPTION
\&
.br
CALC COMMAND LINE
.PP

.TP
.B \-c
Continue reading command lines even after an execution
error has caused the abandonment of a line.
.sp 1
For example:
.sp 1
.in +5n
.nf
calc read many_errors.cal
.fi
.in -5n
.sp 1
will cause
.B calc
to abort on the first error, whereas:
.sp 1
.in +5n
.nf
calc -c read many_errors.cal
.fi
.in -5n
.sp 1
will
cause
.B calc
to try to process each line being read
despite the errors that it encounters.
.sp 1
By default, calc startup scripts ($CALCRC) are silently
ignored if not found.
This flag will report missing
startup scripts unless
.B \-d
is also given.

.TP
.B \-C
Permit the execution of custom builtin functions.  Without
this flag, calling the custom() builtin function will
simply generate an error.
.sp 1
Use if this flag may cause
.B calc
to execute functions that
are non-standard and that are not portable.  Custom builtin
functions are disabled by default for this reason.

.TP
.B \-d
Disable the printing of the opening title.  The printing
of library debug and informational messages is also disabled
as if \fBconfig("lib_debug", 0)\fP had been executed.
.sp 1
For example:
.sp 1
.in +5n
calc 'read qtime; qtime(2)'
.in -5n
.sp 1
will output something like:
.sp 1
.in +5n
.nf
qtime(utc_hr_offset) defined
It's nearly ten past six.
.fi
.in -5n
.sp 1
whereas:
.sp 1
.in +5n
.nf
calc -d 'read qtime; qtime(2)'
.fi
.in -5n
.sp 1
will just say:
.sp 1
.in +5n
.nf
It's nearly ten past six.
.fi
.in -5n
.sp 1
This flag disables the reporting of missing calc
startup scripts ($CALCRC).

.TP
.BR -D " calc_debug[:lib_debug:[user_debug]]"
Force the initial value of config("calc_debug"),
config("lib_debug") and config("user_debug").
.sp 1
The : separated strings are interpreted as signed 32 bit values.
After an optional leading sign a leading zero indicates octal
conversion, and a leading ``0x'' or ``0X'' hexadecimal
conversion.  Otherwise, decimal conversion is assumed.
.sp 1
By default,
.I calc_debug
is 0,
.I lib_debug
is 3 and
.I lib_debug
is 0.
.sp 1
For more information use the following
.B calc
command:
.sp 1
.in +5n
.nf
help config
.fi
.in -5n

.TP
.B \-e
Ignore any environment variables on startup.
The getenv() builtin will still return values, however.

.TP
.B \-h
Print a help message.  This option implies
.BR \-q .
This
is equivalent to the
.B calc
command help help.
The help facility is disabled unless the mode is 5 or 7.
See
.BR \-m .

.TP
.B \-i
Become interactive if possible.
Be default, if
.I calc_cmd
args are given,
.B calc
will execute them and exit.
This flag args are given,
.B calc
will execute them and exit.
This flag will cause
.B calc
to drop into interactive mode after the
commands are executed.
.sp 1
For example:
.sp 1
.in +5n
.nf
calc 2+5
.fi
.in -5n
.sp 1
will print the value 7 and exit whereas:
.sp 1
.in +5n
.nf
calc -i 2+5
.fi
.in -5n
.sp 1
will print the value 7 and prompt the user for more
.B calc
commands.

.TP
.BR \-m " mode"
This flag sets the permission mode of
.BR calc .
It controls the ability for
.B calc
to open files and execute programs.
.I Mode
may be a number from 0 to 7.
.sp 1
The mode value is interpreted in a way similar to that
of the
.BR chmod (1)
octal mode:
.sp 1
.in +5n
.nf
0  do not open any file, do not execute progs
1  do not open any file
2  do not open files for reading, do not execute progs
3  do not open files for reading
4  do not open files for writing, do not execute progs
5  do not open files for writing
6  do not execute any program
7  allow everything (default mode)
.fi
.in -5n
.sp 1
If one wished to run
.B calc
from a privileged user, one might want to use
.BR \-m " 0"
in an effort to make
.B calc
somewhat more secure.
.sp 1
Mode bits for reading and writing apply only on an
open.
Files already open are not effected.
Thus if one wanted to use the
.BR \-m " 0"
in an effort to make
.B calc
somewhat more secure, but still wanted to read and write a specific
file, one might want to do in
.BR sh (1),
.BR ksh (1),
.BR bash (1)-like
shells:
.sp 1
.in +5n
.nf
calc -m 0 3<a.file
.fi
.in -5n
.sp 1
Files presented to
.B calc
in this way are opened in an
unknown mode.
.B Calc
will attempt to read or write them if directed.
.sp 1
If the mode disables opening of files for reading, then
the startup library scripts are disabled as of
.B \-q
was given.
The reading of key bindings is also disabled
when the mode disables opening of files for reading.

.TP
.B \-n
Use the new configuration defaults instead of the old
default classic defaults.
This flag as the same effect
as executing \fBconfig("all", "newcfg")\fP at startup time.

.TP
.B \-p
Pipe processing is enabled by use of
.BR \-p .
For example:
.sp 1
.in +5n
.nf
calc -p '2^21701-1' | fizzbin
.fi
.in -5n
.sp 1
In pipe mode,
.B calc
does not prompt, does not print leading
tabs and does not print the initial header.
The
.B \-p
flag overrides
.BR \-i .

.TP
.B \-q
Disable the use of the $CALCRC startup scripts.

.TP
.B \-u
Disable buffering of stdin and stdout.

.TP
.B \-v
Print the
.B calc
version number and exit.
.PP
Without
.IR calc_cmd ,
.B calc
operates interactively.
If one or more
.I calc_cmd
are given on the command line,
.B calc
will execute them and exit.
If
.B \-i
is given,
.B calc
will attempt to become interactive
even of one or more
.I calc_cmd
are given on the command line.
.PP
Normally on startup,
.B calc
attempts to execute a collection of
library scripts.
The environment variable $CALCRC (if non-existent
then a compiled in value) contains a :  separated list of startup
library scripts.
No error conditions are produced if these startup
library scripts are not found.
.PP
If the mode disables opening of files for reading, then the startup
library scripts are disabled as of
.B \-q
was given and $CALCRC as well
as the default compiled in value are ignored.
.PP
Filenames are subject to ``~'' expansion (see below).
The
environment variable $CALCPATH (if non-existent then a compiled in
value) contains a : separated list of search directories.
If a
file does not begin with /, ~ or ./, then it is searched for under
each directory listed in the $CALCPATH.
It is an error if no such
readable file is found.
.PP
.B Calc
treats all open files, other than stdin, stdout and
stderr as files available for reading and writing.
One may
present
.B calc
with an already open file using
.BR sh (1),
.BR ksh (1),
.BR bash (1)-like
shells is to:
.sp 1
.in +5n
calc 3<open_file 4<open_file2
.in -5n
.sp 1
For more information use the following
.B calc
commands:
.sp 1
.in +5n
.nf
help help
help overview
help usage
help environment
help config
.fi
.in -5n
.sp 1
.PP
DATA TYPES
.PP
Fundamental builtin data types include integers, real numbers,
rational numbers, complex numbers and strings.
.PP
By use of an object, one may define an arbitrarily complex
data types.
One may define how such objects behave a wide range of
operations such as addition, subtraction,
multiplication, division, negation, squaring, modulus,
rounding, exponentiation, equality, comparison, printing
and so on.
.PP
For more information use the following
.B calc
commands:
.PP
.in 1.0i
help types
.br
help obj
.br
show objfuncs
.in -1.0i
.PP
VARIABLES
.PP
Variables in \fIcalc\fP are typeless.
In other words, the fundamental type of a variable is determined by its content.
Before a variable is assigned a value it has the value of zero.
.PP
The scope of a variable may be global, local to a file, or local to a
procedure.
Values may be grouped together in a matrix, or into a
a list that permits stack and queue style operations.
.PP
For more information use the following
.B calc
commands:
.PP
.in 1.0i
help variable
.br
help mat
.br
help list
.br
show globals
.in -1.0i
.PP
INPUT/OUTPUT
.PP
A leading ``0x'' implies a hexadecimal value,
a leading ``0b'' implies a binary value,
and a ``0'' followed by a digit implies an octal value.
Complex numbers are indicated by a trailing ``i'' such as in ``3+4i''.
Strings may be delimited by either a pair of single or double quotes.
By default, \fIcalc\fP prints values as if they were floating point numbers.
One may change the default to print values in a number of modes
including fractions, integers and exponentials.
.PP
A number of stdio-like file I/O operations are provided.
One may open, read, write, seek and close files.
Filenames are subject to ``\~'' expansion to home directories
in a way similar to that of the Korn or C-Shell.
.PP
For example:
.PP
.in 1.0i
~/.calcrc
.br
~chongo/lib/fft_multiply.cal
.in -1.0i
.PP
For more information use the following
.B calc
command:
.PP
.in 1.0i
help file
.in -1.0i
.PP
CALC LANGUAGE
.PP
The \fIcalc\fP language is a C-like language.
The language includes commands such as variable declarations,
expressions, tests, labels, loops, file operations, function calls.
These commands are very similar to their counterparts in C.
.PP
The language also include a number of commands particular
to \fIcalc\fP itself.
These include commands such as function definition, help,
reading in library scripts, dump files to a file, error notification,
configuration control and status.
.PP
For more information use the following
.B calc
command:
.PP
.in 1.0i
help command
.br
help statement
.br
help expression
.br
help operator
.br
help config
.in -1.0i
.PP
.SH FILES
\&
.br
.PD 0
.TP 20
${LIBDIR}/*.cal
library scripts shipped with
.B calc
.br
.sp
.TP 20
${LIBDIR}/help/*
help files
.br
.sp
.TP 20
${LIBDIR}/bindings
command line editor bindings
.sp
.SH ENVIRONMENT
\&
.br
.PD 0
.TP 5
CALCPATH
A :-separated list of directories used to search for
scripts filenames that do not begin with /, ./ or ~.
.br
.sp
Default value: ${CALCPATH}
.br
.sp
.TP 5
CALCRC
On startup (unless \-h or \-q was given on the command
line),
.B calc
searches for files along this :-separated
environment variable.
.br
.sp
Default value: ${CALCRC}
.br
.sp
.TP 5
CALCBINDINGS
On startup (unless \fI\-h\fP or \fI\-q\fP was given on the command
line, or \fI\-m\fP disallows opening files for reading),
.B calc
reads
key bindings from the filename specified
by this environment variable.
.br
.sp
Default value: ${CALCBINDINGS}
.sp
This variable is not used if calc was compiled with GNU-readline support.
In that case, the standard readline mechanisms (see readline(3)) are used.
.sp
.SH CREDIT
\&
.br
The majority of
.B calc
was written by David I. Bell.
.sp
.B Calc
The Calc primary mirror, calc mailing list and calc bug report
processing is performed by Landon Curt Noll.
.sp
Landon Curt Noll maintains the master reference source, performs
release control functions as well as other calc maintenance functions.
.sp
Thanks for suggestions and encouragement from Peter Miller,
Neil Justusson, and Landon Noll.
.sp
Thanks to Stephen Rothwell for writing the original version of
hist.c which is used to do the command line editing.
.sp
Thanks to Ernest W. Bowen for supplying many improvements in
accuracy and generality for some numeric functions.  Much of
this was in terms of actual code which I gratefully accepted.
Ernest also supplied the original text for many of the help files.
.sp
Portions of this program are derived from an earlier set of
public domain arbitrarily precision routines which was posted
to the net around 1984.  By now, there is almost no recognizable
code left from that original source.
.sp
Most of this source and binary has one of the following copyrights:
.sp
.in +0.5i
Copyright (c) 19xx David I. Bell
.br
Copyright (c) 19xx David I. Bell and Landon Curt Noll
.br
Copyright (c) 19xx Landon Curt Noll
.br
Copyright (c) 19xx Ernest Bowen and Landon Curt Noll
.in -0.5i
.sp
Permission is granted to use, distribute, or modify this source,
provided that this copyright notice remains intact.
.sp
Send comments, suggestions, bug fixes, enhancements
and interesting
.B calc
scripts that you would like you see included
in future distributions to:
.sp
.in +0.5i
.nf
calc-tester at postofc dot corp dot sgi dot com

[[ Replace 'at' with @, 'dot' is with . and remove the spaces ]]
.fi
.in -0.5i
.sp
Bug reports are sent to:
.in +0.5i
.nf
calc-bugs at postofc dot corp dot sgi dot com

[[ Replace 'at' with @, 'dot' is with . and remove the spaces ]]
.fi
.in -0.5i
.sp
See the
.I BUGS
source file or use the 
.I calc
command:
.sp
.in +0.5i
.nf
help bugs
.fi
.in -0.5i
.sp
for more information about bug reporting.
.sp
Landon Noll maintains the the
.B calc
web site is located at:
.sp
.in +0.5i
http://reality.sgi.com/chongo/tech/comp/calc/
.in -0.5i
.sp
One may join the
.B calc
testing group by sending a request to:
.sp
.in +0.5i
.nf
calc-tester-request at postofc dot corp dot sgi dot com

[[ Replace 'at' with @, 'dot' is with . and remove the spaces ]]
.fi
.in -0.5i
.sp
Your message body (not the subject) should consist of:
.sp
.in +0.5i
.nf
subscribe calc-tester address
end
name your_full_name
.fi
.in -0.5i
.sp
where "address" is your EMail address and "your_full_name"
is your full name.
.sp
Share and Enjoy! :\-)
