/* complex_math.h   include file for complex math calls
Ken Stephenson, 8/91 */

#define float double

typedef struct {float re,im;}  complex;

typedef struct {complex a,b,c,d; int flip;} Mobius; 
	/* flip=0 ==> orientation preserving, else reversing */

extern float cAbs(/*complex*/);
extern float Arg(/*complex*/);
extern float inv_dist(/*complex,float,complex,float*/);
extern complex cadd(/*complex,complex*/);
extern complex cmult(/*complex,complex*/);
extern complex cdiv(/*complex,complex*/);
extern complex csub(/*complex,complex*/);
extern complex cconj(/*complex*/);
extern complex cexp(/*float,float*/);
extern complex clog(/*complex*/);
extern complex mob_trans(/*complex,complex*/);
extern complex mob_norm(/*complex,complex,complex*/);
extern complex mob_norm_inv(/*complex,complex,complex*/);
extern complex mob_rotate(/*complex,float*/);
extern complex mobius(/*&Mobius,complex,int*/);
extern complex det(/*Mobius*/);
extern Mobius matrix_product(/*Mobius,Mobius*/);
extern Mobius apply_mobius(/*Mobius,Mobius,int*/);
extern Mobius zero_inf(/*complex,complex,float,float,float */);
