

/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "droite.h"

extern liste_elem liste_figure;
extern GdkFont *fontobject;
extern GdkGC *font_gc;
extern int h_ecran, w_ecran;

// Common methods for droite object
vecteur_s droite_c::
normal (void)
{
  vecteur_s n;
  double m;
  n.x = -p.a.y + p.b.y;
  n.y = p.a.x - p.b.x;
  m = sqrt (n.x * n.x + n.y * n.y);
  if (m == 0)
    m = 1;
  n.x /= m;
  n.y /= m;
  return n;
}
vecteur_s droite_c::
directeur (void)
{
  vecteur_s d;
  double m;
  d.x = p.a.x - p.b.x;
  d.y = p.a.y - p.b.y;
  m = sqrt (d.x * d.x + d.y * d.y);
  if (m == 0)
    m = 1;
  d.x /= m;
  d.y /= m;
  return d;
}
double droite_c::
longueur (void)
{
  droite_s co;
  co = coordonnees ();
  co.a = co.a - co.b;
  return sqrt (co.a * co.a);
}
void droite_c::
init_nom (void)
{
  char tmp[8];
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this line %1"));
  strinsmsg (nom_type, nom, "%1");
}
void droite_c::
dessine (GdkPixmap * ecran, char force)
{
  long signed c[2][2], xa, xb, ya, yb;
  double b, d, x, y;
  char pt = 0;
  droite_s co;
  vecteur_s u;
  if ((masque == OBJET_MACRO) || (masque == TRUE && force == FALSE) || existe == FALSE)
    return;
  co = coordonnees ();
  u = directeur ();
  co.b.x = co.a.x + 10 * u.x;
  co.b.y = co.a.y + 10 * u.y;
  xa = ECRx (co.a.x);
  ya = ECRy (co.a.y);
  xb = ECRx (co.b.x);
  yb = ECRy (co.b.y);
  if (co.a.x == co.b.x && co.a.y == co.b.y)
    return;
  if (fabs (co.a.x - co.b.x) < 1E-20)
    {
      c[0][0] = c[1][0] = xa;
      c[0][1] = 0;
      c[1][1] = h_ecran;
      pt = 2;
    }
  else
    {
      d = (double) (co.a.y - co.b.y) / (co.a.x - co.b.x);	// pente

      if (d == 0)
	{
	  c[0][0] = 0;
	  c[0][1] = c[1][1] = ya;
	  c[1][0] = w_ecran;
	  pt = 2;
	}
      else
	{
	  b = (double) (co.a.y - d * co.a.x);	// ordonnee a  l'origine

	  y = d * MON_L + b;
	  if (y >= MON_B && y < MON_T)
	    {
	      c[pt][0] = 0;
	      c[pt][1] = ECRy (y);
	      pt++;
	    }
	  y = d * MON_R + b;
	  if (y >= MON_B && y < MON_T)
	    {
	      c[pt][0] = w_ecran;
	      c[pt][1] = ECRy (y);
	      pt++;
	    }
	  x = (MON_T - b) / d;
	  if (x >= MON_L && x < MON_R && pt < 2)
	    {
	      c[pt][0] = ECRx (x);
	      c[pt][1] = 0;
	      pt++;
	    }
	  x = (MON_B - b) / d;
	  if (x >= MON_L && x < MON_R && pt < 2)
	    {
	      c[pt][0] = ECRx (x);
	      c[pt][1] = h_ecran;
	      pt++;
	    }
	}
    }
  if (pt < 2)
    return;
  switch (epaisseur)
    {
    case 0:
      dotted_line (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur, 1);
      break;
    case 1:
      dotted_line (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur, 2);
      break;
    case 2:
      gline (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur);
      break;
    case 3:
      thick_line (ecran, c[0][0], c[0][1], c[1][0], c[1][1], couleur, EPAIS);
      break;
    }
}
double droite_c::
pente (void)
{
  if (p.a.x == p.b.x)
    return (1E100);
  else
    return ((p.a.y - p.b.y) / (p.a.x - p.b.x));
}
char droite_c::
appartient (int xm, int ym)
{
  droite_s co;
  vecteur_s n;
  double x, y;
  n = normal ();
  if (n.x == 0 && n.y == 0)
    return M1->appartient (xm, ym);
  co = coordonnees ();
  x = MONx (xm) - co.a.x;	// si c'est trop lent, stocker les

  y = MONy (ym) - co.a.y;	// coordonees ecrans lors de l'affichage de la figure

  if (ABS (x * n.x + y * n.y) >= RI)
    return FALSE;
  return TRUE;
}
param_droite droite_c::
parametre (void)
{
  param_droite para;
  vecteur_s direc;
  droite_s co;
  direc = directeur ();
  co = coordonnees ();
  para.a = direc.y;
  para.b = -direc.x;
  para.c = -(para.a * co.a.x + para.b * co.a.y);
  return para;
}
//
// Classe 'droite1' droite definie par deux points
// Si nom est null l'objet retrouve son nom par defaut
void droite1::
init_nom (void)
{
  if (masque == OBJET_MACRO)
    return;
  strcpy (nom_type, _ ("this line %1"));
  if ((strlen (M1->nom) + strlen (M2->nom) + 3) <= LONGUEUR_NOM && strlen (M1->nom) != 0 && strlen (M2->nom) != 0)
    {
      sprintf (nom, "(%s%s)", M1->nom, M2->nom);
    }
  strinsmsg (nom_type, nom, "%1");
}
char droite1::
dependance (figure_c * fig)
{
  return (M1 == fig || M2 == fig);
}
droite_s droite1::
coordonnees (void)
{
  p.a = M1->p;
  p.b = M2->p;
  return p;
}
void droite1::
actualise (void)
{
  if (!M1->existe || !M2->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p.a = M1->coordonnees ();
  p.b = M2->coordonnees ();
  if (ECRx (p.a.x) == ECRx (p.b.x) && ECRy (p.a.y) == ECRy (p.b.y))
    existe = FALSE;
}
void droite_c::
move (int xm, int ym)
{
}
liste_elem *droite1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) M2);
  return liste_parent;
}
void droite1::
move (int xm, int ym)
{
  M1->move (xm, ym);
  M2->move (xm, ym);
  actualise ();
}
void droite1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) M2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void droite1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  M2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// Classe droite parallele
char droite_parallele1::
dependance (figure_c * fig)
{
  return (M1 == fig || parallele == fig);
}
droite_s droite_parallele1::
coordonnees (void)
{
  vecteur_s u;
  p.a = M1->p;
  u = directeur ();
  p.b.x = p.a.x + u.x * 10;
  p.b.y = p.a.y + u.y * 10;
  return p;
}
void droite_parallele1::
actualise (void)
{
  if (!M1->existe || !parallele->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
vecteur_s droite_parallele1::
normal (void)
{
  return (parallele->normal ());
}
vecteur_s droite_parallele1::
directeur (void)
{
  return (parallele->directeur ());
}
double droite_parallele1::
pente (void)
{
  return (parallele->pente ());
}
liste_elem *droite_parallele1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) parallele);
  return liste_parent;
}
void droite_parallele1::
move (int xm, int ym)
{
  M1->move (xm, ym);
  actualise ();
}
void droite_parallele1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
//droite_c
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
//droite_parallele1
  pos = liste_figure.position ((void *) parallele);
  fwrite (&pos, 1, sizeof (pos), f);
}
void droite_parallele1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
//droite_c
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
//droite_parallele1
  fread (&pos, 1, sizeof (pos), f);
  parallele = (droite_c *) liste_figure.lire (pos);
  init_nom ();
}
// Classe droite parallele a droite define par deux points
char droite_parallele2::
dependance (figure_c * fig)
{
  return (M1 == fig || p1 == fig || p2 == fig);
}
droite_s droite_parallele2::
coordonnees (void)
{
  vecteur_s u;
  p.a = M1->p;
  u = directeur ();
  p.b.x = p.a.x + u.x * 10;
  p.b.y = p.a.y + u.y * 10;
  return p;
}
void droite_parallele2::
actualise (void)
{
  if (!M1->existe || !p1->existe || !p2->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  if (ECRx (p1->p.x) == ECRx (p2->p.x) && ECRy (p1->p.y) == ECRy (p2->p.y))
    existe = FALSE;
}
vecteur_s droite_parallele2::
normal (void)
{
  double dum;
  vecteur_s n;
  n = directeur ();
  dum = n.y;
  n.y = n.x;
  n.x = -dum;
  return n;
}
vecteur_s droite_parallele2::
directeur (void)
{
  vecteur_s d;
  double m;
  d.x = p1->p.x - p2->p.x;
  d.y = p1->p.y - p2->p.y;
  m = sqrt (d.x * d.x + d.y * d.y);
  if (m == 0)
    m = 1;
  d.x /= m;
  d.y /= m;
  return d;
}
double droite_parallele2::
pente (void)
{
  if (p.a.x == p.b.x)
    return (1E100);
  else
    return ((p.a.y - p.b.y) / (p.a.x - p.b.x));
}
liste_elem *droite_parallele2::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) p1);
  liste_parent->ajoute ((void *) p2);
  return liste_parent;
}
void droite_parallele2::
move (int xm, int ym)
{
  M1->move (xm, ym);
  actualise ();
}
void droite_parallele2::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
//droite_c
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
//droite_parallele2
  pos = liste_figure.position ((void *) p1);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) p2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void droite_parallele2::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
//droite_c
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
//droite_parallele2
  fread (&pos, 1, sizeof (pos), f);
  p1 = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  p2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
//
// Classe droite orthogonale
char droite_orthogonale1::
dependance (figure_c * fig)
{
  return (M1 == fig || orthogonale == fig);
}
droite_s droite_orthogonale1::
coordonnees (void)
{
  vecteur_s u;
  p.a = M1->p;
  u = directeur ();
  p.b.x = p.a.x + u.x * 10;
  p.b.y = p.a.y + u.y * 10;
  return p;
}
void droite_orthogonale1::
actualise (void)
{
  if (!M1->existe || !orthogonale->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
}
vecteur_s droite_orthogonale1::
normal (void)
{
  return (orthogonale->directeur ());
}
vecteur_s droite_orthogonale1::
directeur (void)
{
  return (orthogonale->normal ());
}
double droite_orthogonale1::
pente (void)
{
  double dum;
  dum = orthogonale->pente ();
  if (dum == 0)
    return (1E100);
  if (dum == 1E100)
    return (0);
  return (-1 / dum);
}
liste_elem *droite_orthogonale1::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) orthogonale);
  return liste_parent;
}
void droite_orthogonale1::
move (int xm, int ym)
{
  M1->move (xm, ym);
  actualise ();
}
void droite_orthogonale1::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
//droite_c
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
//droite_orthogonale1
  pos = liste_figure.position ((void *) orthogonale);
  fwrite (&pos, 1, sizeof (pos), f);
}
void droite_orthogonale1::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
//droite_c
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
//droite_orthogonale1
  fread (&pos, 1, sizeof (pos), f);
  orthogonale = (droite_c *) liste_figure.lire (pos);
  init_nom ();
}
//      Classe droite orthogonale a droite define       par deux        points
char droite_orthogonale2::
dependance (figure_c * fig)
{
  return (M1 == fig || p1 == fig || p2 == fig);
}
droite_s droite_orthogonale2::
coordonnees (void)
{
  vecteur_s u;
  p.a = M1->p;
  u = directeur ();
  p.b.x = p.a.x + u.x * 10;
  p.b.y = p.a.y + u.y * 10;
  return p;
}
void droite_orthogonale2::
actualise (void)
{
  if (!M1->existe || !p1->existe || !p2->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  if (ECRx (p1->p.x) == ECRx (p2->p.x) && ECRy (p1->p.y) == ECRy (p2->p.y))
    existe = FALSE;
}
vecteur_s droite_orthogonale2::
directeur (void)
{
  double dum;
  vecteur_s n;
  n = normal ();
  dum = n.y;
  n.y = n.x;
  n.x = -dum;
  return n;
}
vecteur_s droite_orthogonale2::
normal (void)
{
  vecteur_s d;
  double m;
  d.x = p1->p.x - p2->p.x;
  d.y = p1->p.y - p2->p.y;
  m = sqrt (d.x * d.x + d.y * d.y);
  if (m == 0)
    m = 1;
  d.x /= m;
  d.y /= m;
  return d;
}
double droite_orthogonale2::
pente (void)
{
  if (p.a.x == p.b.x)
    return (0);
  else
    return ((p.a.y - p.b.y) / (p.a.x - p.b.x));
}
liste_elem *droite_orthogonale2::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) M1);
  liste_parent->ajoute ((void *) p1);
  liste_parent->ajoute ((void *) p2);
  return liste_parent;
}
void droite_orthogonale2::
move (int xm, int ym)
{
  M1->move (xm, ym);
  actualise ();
}
void droite_orthogonale2::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
//droite_c
  pos = liste_figure.position ((void *) M1);
  fwrite (&pos, 1, sizeof (pos), f);
  fwrite (&p, 1, sizeof (p), f);
//droite_orthogonale2
  pos = liste_figure.position ((void *) p1);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) p2);
  fwrite (&pos, 1, sizeof (pos), f);
}
void droite_orthogonale2::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
//droite_c
  fread (&pos, 1, sizeof (pos), f);
  M1 = (point_c *) liste_figure.lire (pos);
  fread (&p, 1, sizeof (p), f);
//droite_orthogonale2
  fread (&pos, 1, sizeof (pos), f);
  p1 = (point_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  p2 = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// Transformed line
// By reflexion
char reflexion_droite::
dependance (figure_c * fig)
{
  return (axe == fig || droite == fig);
}
droite_s reflexion_droite::
coordonnees (void)
{
  droite_s co, co1;
  co = droite->coordonnees ();
  co1.a = reflexion_p (axe, co.a);
  co1.b = reflexion_p (axe, co.b);
  return co1;
}
void reflexion_droite::
actualise (void)
{
  if (!droite->existe || !axe->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s reflexion_droite::
normal (void)
{
  return reflexion_v (axe, droite->normal ());
}
vecteur_s reflexion_droite::
directeur (void)
{
  return reflexion_v (axe, droite->directeur ());
}
liste_elem *reflexion_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) axe);
  liste_parent->ajoute ((void *) droite);
  return liste_parent;
}
void reflexion_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) axe);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) droite);
  fwrite (&pos, 1, sizeof (pos), f);
}
void reflexion_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  axe = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  droite = (droite_c *) liste_figure.lire (pos);
  init_nom ();
}
// By symetry
char symetrie_droite::
dependance (figure_c * fig)
{
  return (symetrie == fig || droite == fig);
}
droite_s symetrie_droite::
coordonnees (void)
{
  droite_s co, co1;
  point_s c;
  c = 2 * (symetrie->coordonnees ());
  co = droite->coordonnees ();
  co1.a = c - co.a;
  co1.b = c - co.b;
  return co1;
}
void symetrie_droite::
actualise (void)
{
  if (!droite->existe || !symetrie->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s symetrie_droite::
normal (void)
{
  return droite->normal ();
}
vecteur_s symetrie_droite::
directeur (void)
{
  return droite->directeur ();
}
liste_elem *symetrie_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) droite);
  liste_parent->ajoute ((void *) symetrie);
  return liste_parent;
}
void symetrie_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) symetrie);
  fwrite (&pos, 1, sizeof (pos), f);
}
void symetrie_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  droite = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  symetrie = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By translation
char translation_droite::
dependance (figure_c * fig)
{
  return (v == fig || droite == fig);
}
droite_s translation_droite::
coordonnees (void)
{
  droite_s co, co1;
  vecteur_s t;
  t = v->vecteur ();
  co = droite->coordonnees ();
  co1.a = co.a + t;
  co1.b = co.b + t;
  return co1;
}
void translation_droite::
actualise (void)
{
  if (!droite->existe || !v->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s translation_droite::
normal (void)
{
  return droite->normal ();
}
vecteur_s translation_droite::
directeur (void)
{
  return droite->directeur ();
}
liste_elem *translation_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) droite);
  liste_parent->ajoute ((void *) v);
  return liste_parent;
}
void translation_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
}
void translation_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  droite = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (vecteur_c *) liste_figure.lire (pos);
  init_nom ();
}
// By rotation
char rotation_droite::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || droite == fig);
}
droite_s rotation_droite::
coordonnees (void)
{
  droite_s co, co1;
  co = droite->coordonnees ();
  co1.a = rotation_p (c, v, co.a);
  co1.b = rotation_p (c, v, co.b);
  return co1;
}
void rotation_droite::
actualise (void)
{
  if (!droite->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s rotation_droite::
normal (void)
{
  return rotation_v (v, droite->normal ());
}
vecteur_s rotation_droite::
directeur (void)
{
  return rotation_v (v, droite->directeur ());
}
liste_elem *rotation_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) droite);
  liste_parent->ajoute ((void *) c);
  liste_parent->ajoute ((void *) v);
  return liste_parent;
}
void rotation_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void rotation_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  droite = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
// By homothetie
char homothetie_droite::
dependance (figure_c * fig)
{
  return (v == fig || c == fig || droite == fig);
}
droite_s homothetie_droite::
coordonnees (void)
{
  droite_s co, co1;
  co = droite->coordonnees ();
  co1.a = c->p + (co.a - c->p) * v->val;
  co1.b = c->p + (co.b - c->p) * v->val;
  return co1;
}
void homothetie_droite::
actualise (void)
{
  if (!droite->existe || !v->existe || !c->existe)
    {
      existe = FALSE;
      return;
    }
  existe = TRUE;
  p = coordonnees ();
}
vecteur_s homothetie_droite::
normal (void)
{
  return (droite->normal ());
}
vecteur_s homothetie_droite::
directeur (void)
{
  return (droite->directeur ());
}
liste_elem *homothetie_droite::
parents (liste_elem * liste_parent)
{
  liste_parent->vide ();
  liste_parent->ajoute ((void *) droite);
  liste_parent->ajoute ((void *) c);
  liste_parent->ajoute ((void *) v);
  return liste_parent;
}
void homothetie_droite::
sauve_disk (FILE * f)
{
  int pos;
  sauver_parametre_base (f, this);
  fwrite (&p, 1, sizeof (p), f);
  pos = liste_figure.position ((void *) droite);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) v);
  fwrite (&pos, 1, sizeof (pos), f);
  pos = liste_figure.position ((void *) c);
  fwrite (&pos, 1, sizeof (pos), f);
}
void homothetie_droite::
lire_disk (FILE * f)
{
  int pos;
  lire_parametre_base (f, this);
  fread (&p, 1, sizeof (p), f);
  fread (&pos, 1, sizeof (pos), f);
  droite = (droite_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  v = (valeur_c *) liste_figure.lire (pos);
  fread (&pos, 1, sizeof (pos), f);
  c = (point_c *) liste_figure.lire (pos);
  init_nom ();
}
