/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>


#include "complexe.h"
#include "geoclass.h"
#include "mode_obj.h"
#include "graphic.h"
#include "traite.h"

extern liste_elem liste_figure, liste_figure_libre;
extern GdkPixmap *current_screen;
extern GdkColor tab_couleur[];
extern GdkGC *object_gc, *font_gc;
extern GdkFont *fontobject;
extern int h_ecran, w_ecran;

// Definition des fonctions membres des classes heritiere de type point
// Definition des operateurs
vecteur_s operator + (vecteur_s v1, vecteur_s v2)
{				// v1+v2

  vecteur_s r;
  r.x = v1.x + v2.x;
  r.y = v1.y + v2.y;
  return r;
}
vecteur_s operator - (vecteur_s v1)
{				// -v1

  vecteur_s r;
  r.x = -v1.x;
  r.y = -v1.y;
  return r;
}
vecteur_s operator - (vecteur_s v1, vecteur_s v2)
{				// v1-v2

  vecteur_s r;
  r.x = v1.x - v2.x;
  r.y = v1.y - v2.y;
  return r;
}
double operator *(vecteur_s v1, vecteur_s v2)
{				// v1*v2
  // produit scalaire

  double r;
  r = v1.x * v2.x + v1.y * v2.y;
  return r;
}
vecteur_s operator *(vecteur_s v1, double k)
{				// v1*k

  vecteur_s r;
  r.x = k * v1.x;
  r.y = k * v1.y;
  return r;
}
vecteur_s operator *(double k, vecteur_s v1)
{				// k*v1

  vecteur_s r;
  r.x = k * v1.x;
  r.y = k * v1.y;
  return r;
}
vecteur_s operator / (vecteur_s v1, double k)
{				// v1/k

  vecteur_s r;
  r.x = v1.x / k;
  r.y = v1.y / k;
  return r;
}


//Definition des fonctions membres de la classe liste chainee
liste_elem::
liste_elem (liste_elem & l)
{
  int nb;
  lecture = debut = courant = new (elem);
  nb_elem = 0;
  l.init_lire ();
  nb = l.nb_elem;
  while (nb != 0)
    {
      ajoute (l.lire (0));
      nb--;
    }
}
int liste_elem::
ajoute (void *fig)
{
  courant->fig = fig;
  courant->suivant = new (elem);
  courant = courant->suivant;
  nb_elem++;
  return (nb_elem);
}
int liste_elem::
supprime (void *fig)
{
  elem *p, *prec;
  int position = 0;
  p = prec = debut;
  while (p->suivant != NULL)
    {
      position++;
      if (p->fig == fig)
	break;
      prec = p;
      p = p->suivant;
    }
  if (p->fig == fig)
    {
      if (p == debut)
	debut = p->suivant;
      else
	prec->suivant = p->suivant;
      delete (p);
      nb_elem--;
      return (position);
    }
  return (0);
}
int liste_elem::
position (void *fig)
{
  int position = 1;
  elem *p;
  p = debut;
  while (p->suivant != NULL)
    {
      if (p->fig == fig)
	break;
      position++;
      p = p->suivant;
    }
  if (p->fig == fig)
    return (position);
  return (0);
}
void liste_elem::
init_lire (void)
{
  lecture = debut;
}
void *liste_elem::
lire (int pos)
{
  void *fig;
  elem *p;
  if (pos == 0)
    {
      if (lecture != NULL)
	{
	  fig = lecture->fig;
	  lecture = lecture->suivant;
	  return (fig);
	}
      else
	{
	  lecture = debut->suivant;
	  return (debut->fig);
	}
    }
  else
    {
      p = debut;
      if (pos > nb_elem)
	return NULL;
      for (int a = 1; a != pos; a++)
	{
	  p = p->suivant;
	  if (p == NULL)
	    return (NULL);
	}
      return (p->fig);
    }
}
void liste_elem::
vide (void)
{
//      vide la liste chaine
  elem *p, *q;
  p = debut->suivant;
  while (p != NULL)
    {
      q = p->suivant;
      delete (p);
      p = q;
    }
  lecture = courant = debut;
  debut->fig = NULL;
  debut->suivant = NULL;
  nb_elem = 0;
}
// Fonctions assocciees a liste_elem
char
contenue (liste_elem & l1, liste_elem & l2)
{
  char rep = TRUE;
  int nb1 = l1.nb_elem, nb2 = l2.nb_elem;
  if (nb1 > nb2)
    return FALSE;
  l1.init_lire ();
  while (nb1 != 0 && rep)
    {
      if (l2.position (l1.lire (0)) == 0)
	rep = FALSE;
      nb1--;
    }
  return rep;
}
liste_elem & concatene (liste_elem & l1, liste_elem & l2)
{
  int nb = l2.nb_elem;
  void *fig;
  l2.init_lire ();
  while (nb != 0)
    {
      fig = l2.lire (0);
      if (l1.position (fig) == 0)
	l1.ajoute (fig);
      nb--;
    }
  return l1;
}
char
liste_elem_egale (liste_elem & l1, liste_elem & l2)
{
  int nb1 = l1.nb_elem, nb2 = l2.nb_elem;
  void *fig1, *fig2;
  if (nb1 != nb2)
    return FALSE;
  l1.init_lire ();
  l2.init_lire ();
  while (nb1-- != 0)
    {
      fig1 = l1.lire (0);
      fig2 = l2.lire (0);
      if (fig1 != fig2)
	return FALSE;
    }
  return TRUE;
}

//      Dfinition      des fonctions membres de la classe macro
int macro::
ajoute (int *parent, int type_objet, void *objet, int flag, int signe)
{
  courant->fig = objet;
  courant->liste_parent = parent;
  courant->type = type_objet;
  courant->param_f = flag;
  courant->signe = signe;
  courant->suivant = new (noyau_macro);
  courant = courant->suivant;
  nb_noyau++;
  return (nb_noyau);
}
int macro::
position (void *fig)
{
  int position = 0;
  noyau_macro *p;
  p = debut;
  while (p->suivant != NULL)
    {
      position++;
      if (p->fig == fig)
	break;
      p = p->suivant;
    }
  if (p->fig == fig)
    return (position);
  return (0);
}
void macro::
init_lire (void)
{
  lecture = debut;
}
noyau_macro *macro::
lire (int pos)
{
  noyau_macro *noyau;
  if (pos == 0)
    {
      if (lecture != NULL)
	{
	  noyau = lecture;
	  lecture = lecture->suivant;
	  return (noyau);
	}
      else
	{
	  lecture = debut->suivant;
	  return (debut);
	}
    }
  else if (pos > 0)
    {
      noyau = debut;
      for (int a = 1; a != pos; a++)
	{
	  noyau = noyau->suivant;
	  if (noyau == NULL)
	    return (NULL);
	}
      return (noyau);
    }
  else
    return (NULL);
}
void macro::
vide (void)
{
//      vide la liste chaine
  noyau_macro *p, *q;
  p = debut->suivant;
  while (p != NULL)
    {
      q = p->suivant;
      delete[]p->liste_parent;
      delete (p);
      p = q;
    }
  lecture = courant = debut;
  debut->fig = NULL;
  debut->suivant = NULL;
  nb_noyau = 0;
}

//      Definition des  fonctions associees

//      Image   par reflexion d'un point
point_s
reflexion_p (droite_c * axe, point_s p1)
{
  vecteur_s n, d, u, ux, uy;
  droite_s co;
  d = axe->directeur ();
  n = axe->normal ();
  co = axe->coordonnees ();
  u.x = p1.x - co.a.x;
  u.y = p1.y - co.a.y;
  ux = (u * d) * d;
  uy = (u * n) * n;
  u = ux - uy;			// u'

  p1 = u + co.a;		// u'=p1-co.a

  return p1;
}
//      Image   par reflexion d'un vecteur
vecteur_s
reflexion_v (droite_c * axe, vecteur_s v)
{
  vecteur_s n, d, ux, uy;
  d = axe->directeur ();
  n = axe->normal ();
  ux = (v * d) * d;
  uy = (v * n) * n;
  v = ux - uy;			// u'

  return v;
}
// Image d'un point par rotation
point_s
rotation_p (point_c * centre, valeur_c * angle, point_s pt)
{
  Complex rot, c, zm;
  point_s ce;
  double val;
  ce = centre->coordonnees ();
  zm = Complex (pt.x, pt.y);
  c = Complex (ce.x, ce.y);
  val = angle->valeur ();
  rot = Complex (cos (val), sin (val));
  zm = (zm - c) * rot + c;
  ce.x = real (zm);
  ce.y = imag (zm);
  return ce;
}
// Image d'un vecteur par rotation
vecteur_s
rotation_v (valeur_c * angle, vecteur_s v)
{
  Complex rot, zm;
  point_s ce;
  double val;
  zm = Complex (v.x, v.y);
  val = angle->valeur ();
  rot = Complex (cos (val), sin (val));
  zm = zm * rot;
  ce.x = real (zm);
  ce.y = imag (zm);
  return ce;
}

// Lecture/sauvegarde des parametres de bases de objets geometriques
char
lire_parametre_base (FILE * f, figure_c * fig)
{
  fread (&(fig->couleur), 1, sizeof (fig->couleur), f);
  fread (&(fig->masque), 1, sizeof (fig->masque), f);
  fread (&(fig->epaisseur), 1, sizeof (fig->epaisseur), f);
  fread (&(fig->style), 1, sizeof (fig->style), f);
  fread (&(fig->type), 1, sizeof (fig->type), f);
  fread (&(fig->existe), 1, sizeof (fig->existe), f);
  fread (fig->nom, 1, LONGUEUR_NOM * sizeof (fig->nom[0]), f);
  return TRUE;
}
char
sauver_parametre_base (FILE * f, figure_c * fig)
{
  fwrite (&(fig->couleur), 1, sizeof (fig->couleur), f);
  fwrite (&(fig->masque), 1, sizeof (fig->masque), f);
  fwrite (&(fig->epaisseur), 1, sizeof (fig->epaisseur), f);
  fwrite (&(fig->style), 1, sizeof (fig->style), f);
  fwrite (&(fig->type), 1, sizeof (fig->type), f);
  fwrite (&(fig->existe), 1, sizeof (fig->existe), f);
  fwrite (fig->nom, 1, LONGUEUR_NOM * sizeof (fig->nom[0]), f);
  return TRUE;
}
