/*
 *  Dr Geo an interactive geometry software
 * (C) Copyright Hilaire Fernandes  1997-1999
 * hilaire.fernandes@iname.com 
 * 
 *
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef gui_h
#define gui_h

// The number of modes from the toolbars, took from 0
#define NUMBER_MODE 31

// Here the possible modes form the toolbars
enum toolbarmode
  {
    POINT_MODE,
    POINT_MILIEU_MODE,
    POINT_INTER_MODE,
    POINT_REPERE_MODE,
    DROITE_MODE,
    DEMI_DROITE_MODE,
    SEGMENT_MODE,
    VECTEUR_MODE,
    CERCLE_MODE,
    ARC_CERCLE_MODE,
    LIEU_POINT_MODE,
    DROITE_PARALLELE_MODE,
    DROITE_ORTHOGONALE_MODE,
    REFLEXION_MODE,
    SYMETRIE_MODE,
    TRANSLATION_MODE,
    ROTATION_MODE,
    HOMOTHETIE_MODE,
    NUMERIQUE_MODE,
    ANGLE_MODE,
    COORDONNEES_MODE,
    MACRO_ENREGISTRE_MODE,	// record the input object
     MACRO_ENREGISTREF_MODE,	// record the output objects
     MACRO_PLAY_MODE,
    SOURIS_SELECT_MODE,
    MISE_EN_FORME_MODE,
    OPTION_DRGEO_MODE,
    EFFACE_OBJET_MODE,
    SAUVEGARDE_MODE,
    OUVERTURE_MODE,
    NOUVEAU_MODE
  };


int init_gui (void);
void init_other_widget (void);

// Dclarations des fonctions
void set_tool_bar (void);
void set_sub_menu (void);
void hide_sub_menu (void);


// click event on the main menu
void point_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void lines_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void transformation_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void value_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void macro_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void other_event (GtkWidget * widget, GdkEvent * event, gpointer data);

// click event on the sub menu
// point sub menu
void free_point_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void middle_point_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void intersection_point_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void point_coordinate_point_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// line sub menu
void line_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void half_line_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void segment_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void vectrex_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void circle_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void arc_circle_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void locus_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// transformation sub menu
void parallel_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void perpendicular_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void asymetry_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void csymetry_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void translation_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void rotation_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void homothetie_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// numeric sub menu
void distance_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void angle_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void coordinate_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// macro sub menu
void bmacro_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void rmacro_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// other sub menu
void move_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void styles_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void preferences_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void eraser_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void new_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void save_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void load_event (GtkWidget * widget, GdkEvent * event, gpointer data);
void quit_event (GtkWidget * widget, GdkEvent * event, gpointer data);

// style dialog
void color_button_event (GtkWidget * widget, gpointer data);
void shape_button_event (GtkWidget * widget, gpointer data);
void size_button_event (GtkWidget * widget, gpointer data);
void fill_button_event (GtkWidget * widget, gpointer data);
void entry_change_name_event (GtkWidget * widget, gpointer data);
void entry_change_expression_event (GtkWidget * widget, gpointer data);
void delete_dialog_event (GtkWidget * widget, gpointer data);
void hide_dialog_event (GtkWidget * called_widget, gpointer widget);
void adjust_style_dialog ();

// erase dialog
void erase_event (GtkWidget * widget, gpointer data);
void close_erase_dialog (GtkWidget * widget, gpointer data);
// new figure dialog
void newfigure_event (GtkWidget * widget, gpointer data);
// build macro dialog
void buildmacro_event (GtkWidget * widget, gpointer data);
void buildmacro_delete_event (GtkWidget * widget, gpointer data);
// exec macro window
void execmacro_event (GtkWidget * widget, gpointer data);
void macrolist_event (GtkWidget * widget, gint row, gint col, GdkEventButton * event, gpointer data);
// value edit dialog
void value_edit_event (GtkWidget * widget, gpointer data);

// what to do when mouse motion on the figure
void motion_on_figure_area_event (GtkWidget * widget, GdkEventMotion * event, gpointer data);
void delete_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// what to do when a mouse click on the figure
gint click_on_figure_event (GtkWidget * widget, GdkEventButton * event, gpointer data);
// refresh the drawing area
gint expose_event (GtkWidget * widget, GdkEventExpose * event, gpointer data);
gint configure_event (GtkWidget * widget, GdkEvent * event, gpointer data);
// set the message on the status bar
void set_statusbar_msg (int status);
// adjust the rule
void set_range_rules (void);
// adjuste the rule when main window scrollbars change
void figure_adjustment_event (GtkAdjustment * adj, gpointer data);
#endif
