/*  -------------------------------------------------------------------

This program is the property of:

                             Cornell University 
                        Center for Applied Mathematics 
                              Ithaca, NY 14853

and may be used, modified and distributed freely, subject to the 
following restrictions:

       Any product which incorporates source code from the dstool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.

DsTool is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of FITNESS 
FOR A PARTICULAR PURPOSE.  The software is provided as is without 
any obligation on the part of Cornell faculty, staff or students to 
assist in its use, correction, modification or enhancement.

  -----------------------------------------------------------------  */
/*
 * geomview_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `geomview.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "geomview_cui.h"

/*
 * Initialize an instance of object `window1'.
 */
geomview_window1_objects *
geomview_window1_objects_initialize(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (geomview_window1_objects *) calloc(1, sizeof (geomview_window1_objects))))
		return (geomview_window1_objects *) NULL;
	if (!ip->window1)
		ip->window1 = geomview_window1_window1_create(ip, owner);
	if (!ip->controls1)
		ip->controls1 = geomview_window1_controls1_create(ip, ip->window1);
	if (!ip->window_number)
		ip->window_number = geomview_window1_window_number_create(ip, ip->controls1);
	if (!ip->view)
		ip->view = geomview_window1_view_create(ip, ip->controls1);
/*
	if (!ip->hor)
		ip->hor = geomview_window1_hor_create(ip, ip->controls1,1);
	if (!ip->ver)
		ip->ver = geomview_window1_ver_create(ip, ip->controls1,1);
	if (!ip->depth)
		ip->depth = geomview_window1_depth_create(ip, ip->controls1,1);
*/
	if (!ip->destination)
		ip->destination = geomview_window1_destination_create(ip, ip->controls1);
	if (!ip->directory)
		ip->directory = geomview_window1_directory_create(ip, ip->controls1);
	if (!ip->filename)
		ip->filename = geomview_window1_filename_create(ip, ip->controls1);
	return ip;
}

/*
 * Create object `window1' in the specified instance.
 */
Xv_opaque
geomview_window1_window1_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 395,
		XV_HEIGHT, 256,
		XV_LABEL, "Geomview Panel",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls1' in the specified instance.
 */
Xv_opaque
geomview_window1_controls1_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `window_number' in the specified instance.
 */
Xv_opaque
geomview_window1_window_number_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	geomview_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 4,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Window Number:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, geomview_text_notify,
		NULL);
	return obj;
}

/*
 * Create object `View' in the specified instance.
 */
Xv_opaque
geomview_window1_view_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	extern void		view_button_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 264,
		XV_Y, 16,
		PANEL_LABEL_STRING, "View",
		PANEL_NOTIFY_PROC, view_button_notify,
		NULL);
	return obj;
}

/*
 * Create object `hor' in the specified instance.
 */
Xv_opaque
geomview_window1_hor_create(ip, owner,n)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
	int		n;
{
	extern int		geomview_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		PANEL_CHOICE_NROWS, n,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Hor:",
		PANEL_NOTIFY_PROC, geomview_settings_notify,
		PANEL_CHOICE_STRING, 0, " ",
		NULL);
	return obj;
}

/*
 * Create object `Ver' in the specified instance.
 */
Xv_opaque
geomview_window1_ver_create(ip, owner,n)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
	int		n;
{
	extern int		geomview_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		PANEL_CHOICE_NROWS, n,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Ver:",
		PANEL_NOTIFY_PROC, geomview_settings_notify,
		PANEL_CHOICE_STRING, 0, " ",
		NULL);
	return obj;
}

/*
 * Create object `Depth' in the specified instance.
 */
Xv_opaque
geomview_window1_depth_create(ip, owner,n)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
	int		n;
{
	extern int		geomview_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		PANEL_CHOICE_NROWS, n,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Depth:",
		PANEL_NOTIFY_PROC, geomview_settings_notify,
		PANEL_CHOICE_STRING, 0, " ",
		NULL);
	return obj;
}

/*
 * Create object `Destination' in the specified instance.
 */
Xv_opaque
geomview_window1_destination_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	extern int		geomview_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 144,
		PANEL_CHOICE_NCOLS, 2,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Destination:",
		PANEL_CHOICE_STRINGS,
			"Geomview",
			"File",
			NULL,
		PANEL_NOTIFY_PROC, geomview_settings_notify,
		NULL);
	return obj;
}

/*
 * Create object `Directory' in the specified instance.
 */
Xv_opaque
geomview_window1_directory_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	geomview_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 184,
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Directory:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, geomview_text_notify,
		NULL);
	return obj;
}

/*
 * Create object `Filename' in the specified instance.
 */
Xv_opaque
geomview_window1_filename_create(ip, owner)
	geomview_window1_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	geomview_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 216,
		PANEL_VALUE_DISPLAY_LENGTH, 24,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Filename:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, geomview_text_notify,
		NULL);
	return obj;
}

