/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "color.h"

void
MergeUnder( f, b, t )
    register ColorA *f, *b, *t;
{
    register float a = 1.0 - b->a;

    t->r = a * f->r + b->r;
    t->g = a * f->g + b->g;
    t->b = a * f->b + b->b;
    t->a = a * f->a + b->a;
}

void
MergeUnderN( f, b, t, n )
    register ColorA *f, *b, *t;
    register int n;
{
    register float a;
    
    while( n-- ) {
	a = 1.0 - b->a;
	t->r = a * f->r + b->r;
	t->g = a * f->g + b->g;
	t->b = a * f->b + b->b;
	t->a = a * f->a + b->a;
	f++;
	b++;
	t++;
    }
}
