/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /u/fowler/RCS/plclass.c,v 1.19 1993/02/17 01:59:50 fowler Exp $ */


/*
 * Initialize the PolyList class record.
 */

#include	"polylistP.h"


static GeomClass *aPolyListMethods = NULL;

int	PolyListPresent = 1;

static char polylistName[] = "polylist";

char *
PolyListName()
{
	return polylistName;
}

GeomClass      *
PolyListMethods()
{
	if (!aPolyListMethods)
	{
		aPolyListMethods = GeomClassCreate(polylistName);
		aPolyListMethods->name = (GeomNameFunc *) PolyListName;
		aPolyListMethods->methods = (GeomMethodsFunc *) PolyListMethods;
		aPolyListMethods->draw = (GeomDrawFunc *) PolyListDraw;
		aPolyListMethods->bound = (GeomBoundFunc *) PolyListBound;
		aPolyListMethods->boundsphere = 
		  (GeomBoundSphereFunc *) PolyListSphere;
		aPolyListMethods->evert = (GeomEvertFunc *) PolyListEvert;
		aPolyListMethods->create = (GeomCreateFunc *) PolyListCreate;
		aPolyListMethods->copy = (GeomCopyFunc *) PolyListCopy;
		aPolyListMethods->fsave = (GeomFSaveFunc *) PolyListFSave;
		aPolyListMethods->Delete = (GeomDeleteFunc *) PolyListDelete;
		aPolyListMethods->fload = (GeomFLoadFunc *) PolyListFLoad;
		aPolyListMethods->pick = (GeomPickFunc *) PolyListPick;
		aPolyListMethods->transform = 
		  (GeomTransformFunc *) PolyListTransform;
		aPolyListMethods->transformto = 
		  (GeomTransformToFunc *) PolyListTransformTo;
	}
	return aPolyListMethods;
}
