/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef TLISTPDEFS
#define TLISTPDEFS

#include "tlist.h"
#include "bboxP.h"

#define TLISTMAGIC	 GeomMagic ('t', 1)

/*
 * A Transformation List is a collection of 4x4 transformation matrices.
 * May take as argument another Tlist (or List of TList's);
 * if so, we act as the outer product: all our elements multiplied by
 *  all those in the given tlist.
 */

struct Tlist {
    GEOMFIELDS
    int   	nelements;
    Transform 	*elements;
    Geom 	*tlist;		/* More transformations: take product */
    Handle	*tlisthandle;
};

extern char *TlistName( void );
extern Tlist *TlistCreate( Tlist *existing, GeomClass *Class, va_list args );
extern Tlist *TlistCopy( Tlist *t);
extern void TlistDelete( Tlist * );
extern Geom *TlistImport( Pool *p );
extern int  TlistExport( Tlist *tl, Pool *p );

#endif /*TLISTPDEFS*/
