/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#include <libintl.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define _(string) dgettext (PACKAGE, string) /* Shortcut for translating a string. */


typedef enum
{
    REGRESSION_NONE,
    REGRESSION_LINEAR,			    /* y = B + M * x      */
    REGRESSION_LOGARITHMIC,		    /* y = B + M * log(x) */
    REGRESSION_EXPONENTIAL,		    /* y = B * exp(M * x) */
    REGRESSION_POWER			    /* y = B * x ^ M      */
} RegressionType;


typedef struct
{
    /* Pointer to the GtkPlot dataset structure */
    GtkPlotData *real_dataset;
    /* Color of function or curve fit */
    GdkColor line_color;
    /* Dataset name */
    char *name;
    /* Error string */
    char *error;
    
    
    /* Pointset specific stuff */
    /* Spreadsheet widget with data */
    GtkSheet *sheet;
    /* regression dataset */
    GtkPlotData *reg_dataset;
    
    /* Notebook item */
    GtkWidget *notebook_item;
    /* Main hbox */
    GtkWidget *hbox1;
    /* Datalabel */
    GtkWidget *datalabel;
    /* Settings dialog (used to determine if it's open) */
    GtkWidget *dlg_data;
    /* Bookmark label */
    GtkWidget *label;

    /* data points for GtkPlot */
    gdouble *x, *y, *bogus;
    
    /* Number of significant figures */
    gint sigfigs;
    /* Dynamically resize plot? */
    gboolean autoresize;
    
    /* Regression stuff */
    RegressionType regrtype;
    gdouble m, b, corr;
    long double mse;
    
    /* Symbol color */
    GdkColor symbol_color;
    /* Connect line (GtkPlotConnector) */
    gint connect;
    /* Usable */
    gboolean usable;
    /* Tab # */
    gint index;
} thing;


typedef struct
{
    /* Pointer to the GtkPlot dataset structure */
    GtkPlotData *real_dataset;
    /* Color of function or curve fit */
    GdkColor line_color;
    /* Name of function */
    char *name;
    /* Error string */
    char *error;

    /* Function specific stuff */

    /* MenuItem */
    GtkWidget *menu_item;
    /* Label on menu item */
    GtkWidget *label;

    /* Is this an active, visible equation? */
    gboolean eqnflag;
    /* The text of the function */
    char *formc;
    /* Calculation stack linked list */
    struct mp_stack *entryidx[2][2];
    /* Index in popup */
    gint index;
    /* Usable */
    gboolean usable;
} func_thing;
