%
% Start up a simulation of a single axon.
%
z_length = 5000;
n_z = 400;
z_spacing = z_length/n_z;
z_grid = (0:z_length/n_z:z_length*(1-1/n_z))' + z_length/(2*n_z);

s_ax = SingleAxon_new(z_grid, 1, 0.8, 70);	% Calls constructor, and
						% returns a pointer
						% which must be supplied
						% on all member accesses.
	

SingleAxon_set_g_syn(s_ax, 0.005);
				% Accesses a public data member.

SingleAxon_initialize(s_ax, -65); % Call a member function.

for j = 1:25
  for i = 1:10
    SingleAxon_save_voltages(s_ax); % Save voltages so we can compute dV/dt.
    SingleAxon_advance(s_ax, 0.05, zeros(length(z_grid), 1));
				% Advance to the next timestep, supplying an
				% extracellular potential which is 0
				% everywhere.
  end
  [ax, h1, h2] = plotyy(z_grid, SingleAxon_get_vm(s_ax), ... % Voltage.
		z_grid, SingleAxon_Im_compartment(s_ax)); % Current.
				% Calls member functions which return a
				% vector.
  set(ax(1), 'YLim', [-80, 40]);
  set(ax(1), 'YTick', -80:20:40);
  set(ax(2), 'YLim', [-0.1, 0.1]);
  set(ax(2), 'YTick', -0.1:0.025:1);
  drawnow;			% Display the plot now.
end

SingleAxon_delete(s_ax);	% Call the destructor and free the memory.
