#    Copyright (C) 1998  Dennis Roddeman
#    email: dennis.roddeman@uibk.ac.at
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#   
#   
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software Foundation
#    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA

proc convert_line {} {

# convert to:
#  one space between words
#  defines filled in

  global tnpath
  source $tnpath/gid/global.tcl

  global line
  if { $tn_switch } { puts "Old line: $line" }

  set line_list [ split $line ]
  set l [llength $line_list]

  set new_line {}
  for {set iline 0} {$iline<$l} {incr iline} {
    set line_part [lindex $line_list $iline]
    set line_part_trimmed [string trim $line_part]
    set idefine 0
    foreach define $define_list {
      set minus_define -$define
      if { $define ==  $line_part_trimmed } {
        set define_strings [lindex $define_strings_list $idefine]
        set line_part_trimmed $define_strings
      } elseif { $minus_define ==  $line_part_trimmed } {
        set define_strings [lindex $define_strings_list $idefine]
        set line_part_trimmed -$define_strings
      }
      incr idefine
    }
    if { $line_part_trimmed!="" } { set new_line "$new_line $line_part_trimmed" }
  }

  set line [string trim $new_line]
  if { $tn_switch } { puts "New line: $line" }

}

proc viewfile { file } {

  global tnpath
  source $tnpath/gid/global.tcl

  if { [ file exists $file ] } {

#     toplevel window
    set w .showfile
    catch {destroy $w}
    toplevel $w
    wm title $w "File: $file"
    wm geometry $w $tn_window_offset
    focus $w

#     main frame
    set f $w.frame
    frame $f -relief groove -borderwidth 2
    pack $f -expand 1 -fill both

#     specials
    frame $f.framespecial -relief flat
    pack $f.framespecial -side bottom -pady 2m -fill x
    button $f.framespecial.done -text "Done" -command " destroy $w "
    button $f.framespecial.readfile -text "Read" -command "viewfile_read $f $file"
    button $f.framespecial.help -text "Help" -command {
      help "Done: ready reading file.\n\nRead: read file again."
    }
    pack $f.framespecial.done $f.framespecial.readfile -side left -anchor w
    pack $f.framespecial.help -side right -anchor e

#     view file
    frame $f.frametext -relief flat
    pack $f.frametext -fill both -side top -expand 1
    text $f.frametext.text -relief raised -yscrollcommand "$f.frametext.scroll set"
    scrollbar $f.frametext.scroll -command "$f.frametext.text yview"
    pack $f.frametext.scroll -side right -fill y
    pack $f.frametext.text -side left -fill both -expand 1
    viewfile_read $f $file

  }

}

proc viewfile_read { f file } {

  $f.frametext.text delete 1.0 end
  set fileid [open $file]
  while {![eof $fileid]} {
     $f.frametext.text insert end [read $fileid 1000]
  }
  close $fileid
  $f.frametext.text yview

}

proc error_show { errortext } {

#     toplevel window
    set w .showerror
    catch {destroy $w}
    toplevel $w
    wm title $w "Error"
    wm geometry $w 300x300
    focus $w

#     main frame
    set f $w.frame
    frame $f -relief groove -borderwidth 2
    pack $f -expand 1 -fill both

#     specials
    frame $f.framespecial -relief flat
    pack $f.framespecial -side bottom -pady 2m -fill x
    button $f.framespecial.ok -text "Ok" -command " destroy $w "
    pack $f.framespecial.ok -side left -anchor w

#     text
    frame $f.frametext -relief flat
    pack $f.frametext -fill both -side top -expand 1
    text $f.frametext.text -relief raised
    pack $f.frametext.text -side left -fill both -expand 1
    $f.frametext.text insert end $errortext

}
