/*
    Copyright (C) 1998  Dennis Roddeman
    email: d.g.roddeman@wb.utwente.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <assert.h>
#include <ctype.h>
#include <float.h>
#include <fstream.h>
#include <iomanip.h>
#include <iostream.h>
#include <math.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "f2c.h"

  // version stuff: NODE and ELEMENT data can have more versions (i.e. meshes)
#define MVERSION 8 // maximum number of versions
#define VERSION_NORMAL 0 // time=t
#define VERSION_START 1 // time=start_time
#define VERSION_NEW 2 // time=t+dt
#define VERSION_TMP 3 // trash version used by several routines
#define VERSION_NEW_MESH_TMP 4 // trash version used by new_mesh
#define VERSION_NEW_MESH_GENERATED 5 // generated mesh in new_mesh
#define VERSION_PRINT 6 // tempory mesh for printing
#define VERSION_MACRO 7 // tempory mesh for control_macro

  // constants
#define MCHAR 100  // maximum length of names
#define MDIM 3 // maximum number of space dimensions
#define MNOL 27 // maximum number of nodes in an element
#define MSTRAIN 6 // maximum number of strain components
#define MTENDON 10 // maximum number of tendons in an element
#define MTYPE 10 // maximum number of types
#define MCALCUL 20 // maximum length of calcul records
#define MRANGE 500 // maximum expanded range length
#define MMAXWELL 50 // maximum number of maxwell chains
#define MTHREAD 64 // maximum number of threads
#define MAXIMUM_NODE 125 // always 125
#define DATA_ITEM_SIZE 120 // maximum length of (almost all) records
#define EPS_ISO 1.e-9  // epsilon for isoparametric coordinates
#define EPS_COORD 1.e-9 // epsilon for coordinates
#define EPS_VOLUME 1.e-6 // epsilon for element volume
#define PIRAD 3.1415929794311523
#define MPOINT MNOL // maximum number of integration points in an element, always MNOL
#define MUKNWN DATA_ITEM_SIZE // maximum number of unknowns
#define MPUKNWN DATA_ITEM_SIZE // maximum number of primary unknowns
#define MPRINC MPUKNWN // maximum number of principal unknowns
#define TN_EXIT_STATUS 0

  // database items + others
#define ADD  1
#define ALL  2
#define AREA  3
#define AREA_ELEMENT_GROUP  4
#define AREA_NODE_DATAITEM  5
#define AVERAGE  6
#define BAR  7
#define BAR2  8
#define BAR3  9
#define BAR4  10
#define BAR5  11
#define BOUNDA  12
#define BOUNDA_FORCE  13
#define BOUNDA_SINE  14
#define BOUNDA_TIME  15
#define BOUNDA_TIME_FILE  16
#define BOUNDA_UNKNOWN  17
#define BRICK  18
#define BUCKLING  19
#define CHANGE  20
#define CHECK  21
#define CHECK_INDEX  22
#define CHECK_NUMBER  23
#define CHECK_USAGE  24
#define CHECK_USAGE_AND_ERROR  25
#define CIRCLE  26
#define CIRCLE_HOLLOW  27
#define CONDIF  28
#define CONDIF_CONVECTION  29
#define CONDIF_CONVECTION_GEOMETRY  30
#define CONDIF_RADIATION  31
#define CONDIF_RADIATION_GEOMETRY  32
#define CONDIF_TEMPERATURE  33
#define CONTACT  34
#define CONTACT_FRICTION  35
#define CONTACT_GEOMETRY  36
#define CONTACT_GEOMETRY_SWITCH  37
#define CONTACT_HEAT_GENERATION  38
#define CONTACT_PENALTY_PRESSURE  39
#define CONTACT_PENALTY_TEMPERATURE  40
#define CONTACT_PENALTY_VELOCITY  41
#define CONTROL  42
#define CONTROL_DATA_DELETE  43
#define CONTROL_DATA_PUT  44
#define CONTROL_DATA_PUT_DOUBLE  45
#define CONTROL_DATA_PUT_INTEGER  46
#define CONTROL_DISTIBUTE  47
#define CONTROL_DISTIBUTE_VALUES  48
#define CONTROL_DISTRIBUTE  49
#define CONTROL_DISTRIBUTE_VALUES  50
#define CONTROL_EIGEN  51
#define CONTROL_EIGEN_SCALE  52
#define CONTROL_EIGEN_VALUES  53
#define CONTROL_MESH_ADJUST_GEOMETRY  54
#define CONTROL_MESH_DELETE_GEOMETRY  55
#define CONTROL_MESH_MACRO  56
#define CONTROL_MESH_MACRO_PARAMETERS  57
#define CONTROL_MESH_MERGE  58
#define CONTROL_MESH_NEW_MESH  59
#define CONTROL_MESH_NEW_MESH_ELEMENT  60
#define CONTROL_MESH_NEW_MESH_REGION  61
#define CONTROL_MESH_REFINE_GLOBALLY  62
#define CONTROL_MESH_REFINE_GLOBALLY_GEOMETRY  63
#define CONTROL_MESH_REFINE_LOCALLY  64
#define CONTROL_MESH_REFINE_LOCALLY_GEOMETRY  65
#define CONTROL_MESH_REFINE_LOCALLY_MINIMUM  66
#define CONTROL_MESH_REFINE_LOCALLY_NOT  67
#define CONTROL_MESH_REFINE_LOCALLY_ONLY  68
#define CONTROL_MESH_REFINE_LOCALLY_UNKNOWN  69
#define CONTROL_MESH_REMESH  70
#define CONTROL_MESH_REMESH_FACTOR  71
#define CONTROL_MESH_RENUMBER  72
#define CONTROL_MESH_SPLIT  73
#define CONTROL_PRINT  74
#define CONTROL_PRINT_DATABASE  75
#define CONTROL_PRINT_DATA_VERSUS_DATA  76
#define CONTROL_PRINT_GID  77
#define CONTROL_PRINT_GMV  78
#define CONTROL_PRINT_GMV_MESH  79
#define CONTROL_PRINT_HISTORY  80
#define CONTROL_PRINT_MATLAB  81
#define CONTROL_PRINT_PLOTMTV  82
#define CONTROL_PRINT_PLOTMTV_MESH  83
#define CONTROL_PRINT_TECPLOT  84
#define CONTROL_PRINT_TECPLOT_MESH  85
#define CONTROL_PRINT_VTK  86
#define CONTROL_RELAXATION_CONDIF_TEMPERATURE  87
#define CONTROL_RELAXATION_GROUNDFLOW_PRESSURE  88
#define CONTROL_RELAXATION_MATERI_VELOCITY  89
#define CONTROL_RELAXATION_WAVE_FSCALAR  90
#define CONTROL_REPEAT  91
#define CONTROL_REPEAT_UNTIL_ITEM  92
#define CONTROL_REPEAT_UNTIL_TOLERANCE  93
#define CONTROL_REPEAT_UNTIL_VALUE  94
#define CONTROL_RESTART  95
#define CONTROL_SOLVER  96
#define CONTROL_TIMESTEP  97
#define CONTROL_TIMESTEP_ITERATIONS  98
#define CONTROL_TIMESTEP_ITERATIONS_AUTOMATIC  99
#define CYLINDER_HOLLOW  100
#define DATABASE  101
#define DELETE  102
#define DEPENDENCY  103
#define DEPENDENCY_DIAGRAM  104
#define DEPENDENCY_ITEM  105
#define DIAGONAL  106
#define DOF  107
#define DOF_LABEL  108
#define DOF_PRINCIPAL  109
#define DOF_SCAL_VEC_MAT  110
#define DOF_TYINGS  111
#define DOF_TYPE  112
#define DOUBLE  113
#define DTIME  114
#define DYNAMIC  115
#define ELEMENT  116
#define ELEMENT_DELETE_FACTOR  117
#define ELEMENT_DELETE_TIMES  118
#define ELEMENT_DISTRIBUTE  119
#define ELEMENT_DISTRIBUTE_VALUES  120
#define ELEMENT_GROUP  121
#define ELEMENT_MATRIX_DELETE  122
#define ELEMENT_MATRIX_STRESS_STIFFNESS_VALUES  123
#define ELEMENT_MATRIX_UNKNOWNS  124
#define ELEMENT_MATRIX_VALUES  125
#define ELEMENT_RHSIDE_DELETE  126
#define ELEMENT_TENDON_DIRECTION  127
#define ELEMENT_TENDON_NUMBER  128
#define ELEMENT_TENDON_STRESS  129
#define ELEMENT_TENDON_VOLUME  130
#define ELEMENT_VOLUME  131
#define EMPTY  132
#define EVERYTHING  133
#define FIXED_IN_SPACE  134
#define FOLLOW_MATERIAL  135
#define FORCE  136
#define FORCE_ELEMENT_EDGE  137
#define FORCE_ELEMENT_EDGE_GEOMETRY  138
#define FORCE_ELEMENT_EDGE_GEOMETRY_NORMAL  139
#define FORCE_ELEMENT_EDGE_NORMAL  140
#define FORCE_ELEMENT_EDGE_TIME  141
#define FORCE_ELEMENT_EDGE_TIME_NORMAL  142
#define FORCE_ELEMENT_VOLUME  143
#define FORCE_ELEMENT_VOLUME_FACTOR  144
#define FORCE_ELEMENT_VOLUME_GEOMETRY  145
#define FORCE_ELEMENT_VOLUME_TIME  146
#define FORCE_GRAVITY  147
#define FORCE_GRAVITY_TIME  148
#define FROM  149
#define GEOMETRY  150
#define GEOMETRY_BOUNDA_FACTOR  151
#define GEOMETRY_CIRCLE  152
#define GEOMETRY_CYLINDER  153
#define GEOMETRY_LINE  154
#define GEOMETRY_NUMBER  155
#define GEOMETRY_POINT  156
#define GEOMETRY_POLYNOMIAL  157
#define GEOMETRY_QUADRILATERAL  158
#define GEOMETRY_SET  159
#define GEOMETRY_SPHERE  160
#define GEOMETRY_TRIANGLE  161
#define GET  162
#define GET_AND_CHECK  163
#define GET_FLOW_RULE  164
#define GET_FLOW_RULE_GRAD  165
#define GET_IF_EXISTS  166
#define GET_YIELD_RULE  167
#define GROUNDFLOW  168
#define GROUNDFLOW_PRESSURE  169
#define GROUNDFLOW_VELOCITY  170
#define GROUP_CONDIF_ABSORPTION  171
#define GROUP_CONDIF_CAPACITY  172
#define GROUP_CONDIF_CONDUCTIVITY  173
#define GROUP_CONDIF_DENSITY  174
#define GROUP_CONDIF_FLOW  175
#define GROUP_GROUNDFLOW_COMPRESSIBILITY  176
#define GROUP_GROUNDFLOW_DENSITY  177
#define GROUP_GROUNDFLOW_PERMEABILITY  178
#define GROUP_INTEGRATION_POINTS  179
#define GROUP_MATERI_DAMAGE_MAZARS  180
#define GROUP_MATERI_DAMPING  181
#define GROUP_MATERI_DENSITY  182
#define GROUP_MATERI_DENSITY_MINIMUM  183
#define GROUP_MATERI_ELASTI_CAMCLAY  184
#define GROUP_MATERI_ELASTI_COMPRESSIBILITY  185
#define GROUP_MATERI_ELASTI_LADE  186
#define GROUP_MATERI_ELASTI_LADE_TMP  187
#define GROUP_MATERI_ELASTI_POISSON  188
#define GROUP_MATERI_ELASTI_TRANSVERSE_ISOTROPY  189
#define GROUP_MATERI_ELASTI_YOUNG  190
#define GROUP_MATERI_EXPANSION_LINEAR  191
#define GROUP_MATERI_EXPANSION_VOLUME  192
#define GROUP_MATERI_FAILURE_DAMAGE  193
#define GROUP_MATERI_FAILURE_STRAIN_PLASTI_KAPPA  194
#define GROUP_MATERI_FAILURE_VOIDFRACTION  195
#define GROUP_MATERI_HYPER_BESSELING  196
#define GROUP_MATERI_HYPER_MOONEY_RIVLIN  197
#define GROUP_MATERI_ISOTROPY  198
#define GROUP_MATERI_MAXWELL_CHAIN  199
#define GROUP_MATERI_MEMBRANE  200
#define GROUP_MATERI_MEMORY  201
#define GROUP_MATERI_PLASTI_CAMCLAY  202
#define GROUP_MATERI_PLASTI_CAP  203
#define GROUP_MATERI_PLASTI_COMPRESSION  204
#define GROUP_MATERI_PLASTI_DIPRISCO  205
#define GROUP_MATERI_PLASTI_DRUCKPRAG  206
#define GROUP_MATERI_PLASTI_DRUCKPRAG_APEX  207
#define GROUP_MATERI_PLASTI_GURSON  208
#define GROUP_MATERI_PLASTI_HEAT_GENERATION  209
#define GROUP_MATERI_PLASTI_KINEMATIC_HARDENING  210
#define GROUP_MATERI_PLASTI_MOHRCOUL  211
#define GROUP_MATERI_PLASTI_MOHRCOUL_01  212
#define GROUP_MATERI_PLASTI_MOHRCOUL_12  213
#define GROUP_MATERI_PLASTI_MOHRCOUL_20  214
#define GROUP_MATERI_PLASTI_MOHRCOUL_APEX  215
#define GROUP_MATERI_PLASTI_TENSION  216
#define GROUP_MATERI_PLASTI_USER  217
#define GROUP_MATERI_PLASTI_VISCO_EXPONENTIAL  218
#define GROUP_MATERI_PLASTI_VISCO_POWER  219
#define GROUP_MATERI_PLASTI_VONMISES  220
#define GROUP_MATERI_PLASTI_VONMISES_NADAI  221
#define GROUP_MATERI_STOKES  222
#define GROUP_MATERI_VISCOSITY  223
#define GROUP_TYPE  224
#define GROUP_USER_DATA  225
#define GROUP_USER_UMAT  226
#define GROUP_WAVE_SPEED_OF_SOUND  227
#define HEX125  228
#define HEX27  229
#define HEX64  230
#define HEX8  231
#define H_REFINEMENT  232
#define ICONTROL  233
#define INITIALIZATION_VALUES  234
#define INTEGER  235
#define INVERSE  236
#define INVERSE_DETERMINE_NEW_ESTIMATES  237
#define INVERSE_DETERMINE_SENSITIVITY  238
#define INVERSE_HISTORY  239
#define INVERSE_ITERATIONS  240
#define INVERSE_ITERATION_NUMBER  241
#define INVERSE_PARAMETER  242
#define INVERSE_PARAMETER_LIMITS  243
#define INVERSE_PARAMETER_SENSITIVITY  244
#define INVERSE_PARAMETER_SET  245
#define INVERSE_PARAMETER_STEP  246
#define INVERSE_PARAMETER_VARIATION  247
#define INVERSE_TARGET  248
#define INVERSE_TARGET_DATA  249
#define INVERSE_TARGET_TIMESTEP  250
#define MATERI  251
#define MATERI_DAMAGE  252
#define MATERI_DENSITY  253
#define MATERI_DISPLACEMENT  254
#define MATERI_HISTORY_VARIABLES  255
#define MATERI_MAXWELL_STRESS  256
#define MATERI_PLASTI_F  257
#define MATERI_PLASTI_KAPPA  258
#define MATERI_PLASTI_RHO  259
#define MATERI_STRAIN_ELASTI  260
#define MATERI_STRAIN_PLASTI  261
#define MATERI_STRAIN_TOTAL  262
#define MATERI_STRESS  263
#define MATERI_VELOCITY  264
#define MATERI_VELOCITY_INTEGRATED  265
#define MATERI_VOID_FRACTION  266
#define MATERI_WORK  267
#define MATRIX  268
#define MATRIX_DIRECT  269
#define MATRIX_ITERATIVE  270
#define MAXIMAL  271
#define MESH  272
#define MINIMAL  273
#define NEGATIVE  274
#define NO  275
#define NODE  276
#define NODE_BOUNDARY  277
#define NODE_BOUNDED  278
#define NODE_DAMPING  279
#define NODE_DOF  280
#define NODE_DOF_CALCUL  281
#define NODE_DOF_START_REFINED  282
#define NODE_DOF_TMP  283
#define NODE_EIGEN  284
#define NODE_LHSIDE  285
#define NODE_MASS  286
#define NODE_NEL  287
#define NODE_NODE  288
#define NODE_REMESH_VELOCITY  289
#define NODE_RHSIDE  290
#define NODE_RHSIDE_INTERNAL  291
#define NODE_RHSIDE_STATIC  292
#define NODE_START_REFINED  293
#define NODE_STIFFNESS  294
#define NODE_TYINGS  295
#define NODE_TYINGS_FACTORS  296
#define NODE_TYINGS_UNKNOWNS  297
#define NONE  298
#define NORMAL  299
#define NOTHING  300
#define NUMBER  301
#define NUMBER_ITERATIONS  302
#define OPTIONS_AXISYMMETRIC  303
#define OPTIONS_CONVECTION  304
#define OPTIONS_INERTIA  305
#define OPTIONS_MESH  306
#define OPTIONS_NONLOCAL  307
#define OPTIONS_PROCESSORS  308
#define OPTIONS_RESIDUEFACTOR  309
#define OPTIONS_STABILIZATION  310
#define PHIMOB  311
#define PLUS_DISPLACEMENT  312
#define POSITIVE  313
#define POST  314
#define POST_CALCUL  315
#define POST_CALCUL_SCAL_VEC_MAT  316
#define POST_CALCUL_UNKNOWN_OPERAT  317
#define POST_ERROR_ITEM  318
#define POST_ERROR_MESH1  319
#define POST_ERROR_MESH2  320
#define POST_ERROR_RESULT  321
#define POST_LINE  322
#define POST_LINE_DOF  323
#define POST_LINE_DOF_CALCUL  324
#define POST_LINE_MOMENT  325
#define POST_LINE_N  326
#define POST_NODE  327
#define POST_NODE_RESULT  328
#define POST_NODE_RHSIDE_FIXED  329
#define POST_NODE_RHSIDE_FREE  330
#define POST_NODE_RHSIDE_RATIO  331
#define POST_POINT  332
#define POST_POINT_DOF  333
#define POST_POINT_DOF_CALCUL  334
#define POST_QUADRILATERAL  335
#define POST_QUADRILATERAL_DOF  336
#define POST_QUADRILATERAL_DOF_CALCUL  337
#define POST_QUADRILATERAL_N  338
#define PRINT  339
#define PRINT_FILTER  340
#define PRIVAL  341
#define PRIVEC  342
#define PROJECT_EXACT  343
#define PROJECT_ON_EDGE  344
#define PUT  345
#define P_COARSEN  346
#define P_REFINEMENT  347
#define QUAD16  348
#define QUAD25  349
#define QUAD4  350
#define QUAD9  351
#define RA  352
#define RECTANGLE  353
#define RESIDUE  354
#define SCALAR  355
#define SIZE  356
#define SIZEDEV  357
#define SLIDE  358
#define SLIDE_FRICTION  359
#define SLIDE_GEOMETRY  360
#define SPHERE  361
#define STATIC  362
#define STEP  363
#define SUM  364
#define TARGET  365
#define TARGET_ITEM  366
#define TARGET_VALUE  367
#define TENDON  368
#define TENDON_ELASTI  369
#define TENDON_EXPANSION  370
#define TENDON_PLASTI  371
#define TENDON_SPLIT  372
#define TENDON_SPLIT_ELEMENT  373
#define TENDON_STRESS  374
#define TET10  375
#define TET4  376
#define TIME  377
#define TIME_AT_START  378
#define TIME_CALCULATION  379
#define TIME_CURRENT  380
#define TIME_NEW  381
#define TIME_OLD  382
#define TO  383
#define TOTAL  384
#define TRIA3  385
#define TRIA6  386
#define TYINGS  387
#define UNIFORM  388
#define UPDATED  389
#define UPDATED_WITHOUT_ROTATION  390
#define USER  391
#define VALUE  392
#define VECTOR  393
#define VOLUME  394
#define VOLUME_ELEMENT_FACTOR  395
#define VOLUME_FACTOR  396
#define WAVE  397
#define WAVE_FSCALAR  398
#define WAVE_SCALAR  399
#define YES  400
#define MDAT YES+DATA_ITEM_SIZE  // reserve space for unknowns

  // see initialization part in manual
extern long int echo, ndim, derivatives, condif_temperature, 
  groundflow_gvelocity, groundflow_pressure, materi_history_variables,
  materi_damage, materi_density, materi_displacement, 
  materi_maxwell_stress, materi_plasti_kappa, 
  materi_plasti_f, materi_plasti_rho, 
  materi_strain_elasti, materi_strain_plasti, materi_strain_total, 
  materi_stress, materi_velocity, materi_velocity_integrated,
  materi_void_fraction, materi_work, residue, wave_scalar, wave_fscalar; 

  // for internal use
extern long int
  nder, // number of derivatives (incl. primary unknown itself)
  npuknwn, // number of primary unknowns
  nuknwn, // number of unknowns (= npuknwn*nder)
  nprinc, // number of principal unknowns
  dam_indx, // index stating start of materi_damage in node_dof
  dens_indx, // index stating start of materi_density in node_dof
  dis_indx, // index stating start of materi_displacement in node_dof
  epe_indx, // index stating start of materi_strain_elasti in node_dof
  epp_indx, // index stating start of materi_strain_plasti in node_dof
  ept_indx, // index stating start of materi_strain_total in node_dof
  f_indx, // index stating start of materi_plasti_f in node_dof
  gvel_indx, // index stating start of groundflow_gvelocity in node_dof
  hisv_indx, // index stating start of materi_history_variables in node_dof
  mstres_indx, // index stating start of materi_maxwell stress in node_dof
  pres_indx, // index stating start of groundflow_pressure in node_dof
  res_indx, // index stating start of residue in node_dof
  kap_indx, // index stating start of materi_plasti_kappa in node_dof
  rho_indx, // index stating start of materi_plasti_rho in node_dof
  scal_indx, // index stating start of wave_scalar in node_dof
  stres_indx, // index stating start of materi_stress in node_dof
  temp_indx, // index stating start of condif_temperature in node_dof
  fscal_indx, // index stating start of wave_fscalar in node_dof
  vel_indx, // index stating start of materi_velocity in node_dof
  veli_indx, // index stating start of materi_velocity in node_dof
  void_indx, // index stating start of materi_void_fraction in node_dof
  work_indx; // index stating start of materi_work in node_dof
extern char
  data_file[MCHAR], // data file name
  data_file_base[MCHAR], // data file name base
  last_routine[MCHAR], // last routine called
  post_calcul_names[DATA_ITEM_SIZE][MCHAR], // names for calcul
  post_calcul_names_without_extension[DATA_ITEM_SIZE][MCHAR], // names for calcul
  initialization_names[DATA_ITEM_SIZE][MCHAR]; // unknown initialization records

  // for map routine
extern long int map_version_from, map_version_to, map_always;

  // for post routines
extern long int post_found, post_node[4], post_node_length, npost_node;
extern double post_point[MDIM], post_point_dof[MUKNWN], 
  post_node_result[DATA_ITEM_SIZE];

  // for calcul routine
extern long int calcul_matrix, calcul_vector, calcul_scalar_indx,
  calcul_operat, calcul_mat_indx, calcul_vec_indx;

  // for geometry routine
extern long int geometry_ent[2], *nodes_in_geometry;

  // for parallel computations
extern long int parallel_active;

  // for timesteps
extern long int timestep_decrease;

  // c routines
extern "C" 
  int umat_(double *stress, double *statev, double *ddsdde, 
    double *sse, double *spd, double *scd, double *rpl, double *ddsddt,
    double *drplde, double *drpldt, double *stran, double *dstran, 
    double *time, double *dtime, double *temp, double *dtemp, double *predef, 
    double *dpred, char *cmname, long int *ndi, 
    long int *nshr, long int *ntens, long int *nstatv, 
    double *props, long int *nprops, double *coords, double *drot, 
    double *pnewdt, double *celent, double *dfgrd0, double *dfgrd1, 
    long int *noel, long int *npt, long int *layer, long int *kspt, 
    long int *kstep, long int *kinc, short cmname_len);
extern "C" 
  int dsbev_(char *jobz, char *uplo, integer *n, integer *kd, 
    doublereal *ab, integer *ldab, doublereal *w, doublereal *z, integer *
    ldz, doublereal *work, integer *info);
extern "C" 
  int dsbgv_(char *jobz, char *uplo, integer *n, integer *ka, 
    integer *kb, doublereal *ab, integer *ldab, doublereal *bb, integer *
    ldbb, doublereal *w, doublereal *z, integer *ldz, doublereal *work, 
    integer *info);
extern "C" 
  int mdgbsv_(integer *n, integer *kl, integer *ku, integer *nrhs, 
    doublereal *ab, integer *ldab, integer *ipiv, doublereal *b, 
    integer *ldb, integer *info);

  // routines
void      adjust_geom( void );
void      area( long int name, long int nnol, long int nodes[],
            double coord[], double new_dof[], double element_lhside[], 
            double element_matrix[], double element_rhside[],
            double element_rhside_internal[], double element_rhside_static[] );
void      area_element_group( long int version );
void      area_node_dataitem( void );
void      array_add( double a[], double b[], double c[], long int n );
double    array_distance( double a[], double b[], double work[], long int n );
double    array_inproduct( double a[], double b[], long int n );
long int  array_member( long int i_list[], long int i, long int n, long int &indx );
void      array_move( long int from[], long int to[], long int n );
void      array_move( double from[], double to[], long int n );
void      array_multiply( double a[], double b[], double c, long int n );
long int  array_normalize( double a[], long int n );
long int  array_null( double dval[], long int n );
void      array_outproduct( double a[], double b[], double c[] );
void      array_set( long int i[], long int ival, long int n );
void      array_set( double d[], double dval, long int n );
double    array_size( double a[], long int n );
void      array_subtract( double a[], double b[], double c[], long int n );
void      bounda( void );
void      bounda_time_file_apply( long int iboun, double total_time,
            double bounda_time[], long int &ninc );
void      calculate( void );
void      calculate_operat( double unknown_values[], 
            double result[], long int &length_result );
long int  check( long int idat, long int task );
long int  check_ndim( long int lower, long int higher, long int task );
long int  check_unknown( char str[], long int initialization_needs_to_exist, 
            long int task );
long int  check_unknown_minimum( char str[], long int min, long int task );
long int  check_unknowns_are_specified( long int task );
long int  check_new_node( long int ordered_nodes[], long int new_max_node,
            double coord_new[], long int task );
void      step_close( long int ipar, long int npar, long int ipar_i,
            long int ipar_n );
void      step_start( double time_current );
void      condif( long int element, long int gr, long int nnol, double h[], 
            double volume, double new_unknowns[], double element_lhside[],
            double element_matrix[], double element_rhside[], 
            double element_rhside_internal[],
            double element_rhside_static[], double element_residue[] );
void      C_matrix( double young, double poisson,
            double transverse_isotropy[], double C[MDIM][MDIM][MDIM][MDIM], 
            long int task[] );
void      C_matrix_lade( double lade_1, double lade_2, double lade_3, 
            double I1, double sig_dev[], double C[MDIM][MDIM][MDIM][MDIM] );
void      create_element( long int old_element, long int new_element,
            long int el[], long int length_el,
            long int version_from, long int version_to );
void      create_node( long int old_nodes[], long int nnod, 
            long int tmp_node_number, double tmp_node[], double tmp_node_dof[], 
            double tmp_node_start_refined[], double tmp_node_dof_start_refined[],
            long int version_from, long int version_to );
void      damage( long int gr, double new_epe[], double new_sig[], 
            double old_damage, double &new_damage );
void      damage_mazars( double materi_damage_mazars[], double new_epe[], double new_sig[], 
            double old_damage, double &new_damage );
void      data( void );
long int  db( long int idat, long int index, long int *ival,
            double *dval, long int &length, long int version,
            long int task );
long int  db_active_index( long int idat, long int index, long int version );
void      db_allocate( long int idat, long int index, long int version,
            long int task );
void      db_allocate_class( long int cl, long int index, long int version );
void      db_close( );
void      db_copy( long int idat, long int jdat, long int version );
long int  db_data_length( long int idat );
void      db_data_length_put( long int idat, long int length );
long int  db_data_class( long int idat );
double   *db_dbl( long int idat, long int version );
double   *db_dbl( long int idat, long int index, long int version );
void      db_delete( long int idat, long int version );
void      db_delete_index( long int idat, long int index, long int version );
void      db_error( long int idat, long int index );
long int  db_external( long int idat );
long int  db_fixed_length( long int idat );
void      db_highest_index( long int idat, long int &max, long int version );
void      db_initialize( long int dof_type[], long int dof_label[] );
long int *db_int( long int idat, long int version );
long int *db_int( long int idat, long int index, long int version );
long int  db_len( long int idat, long int index, long int version );
long int  db_max_index( long int idat, long int &max, long int version,
            long int task );
char     *db_name( long int idat );
long int  db_no_index( long int idat );
long int  db_number( char name[] );
long int  db_print_only( long int idat );
long int  db_version( long int idat, long int version );
void      db_version_copy( long int version_from, long int version_to );
void      db_version_delete( long int version );
void      db_set_int( long int jdat, long int version );
void      db_set_dbl( long int jdat, long int version );
long int  db_type( long int idat );
void      delete_element( long int element, long int version );
void      delete_geom( double time_current );
void      delete_node( long int inod, long int version );
void      distribute( void );
void      dof_tyings( void );
void      elem( long int element, long int ithread );
void      element_loop( void );
long int  element_residue_norm_set( long int icontrol,
            long int control_refine_locally_unknown,
            long int element, double &element_residue_norm, long int version );
void      element_volume_set( long int name, long int nodes[], long int version, 
            double &element_volume );
void      equal( void );
void      error( long int task );
void      exit_tn( void );
void      failure( double time_current );
long int  filter( long int idat, long int index, long int number, long int task );
void      force_element_volume_set( long int element, long int nnol, long int nodes[],
            double coord[], double force_element_volume[] );
long int  force_time( double time_table[], long int length, double &load );
void      general( long int element, long int name, long int nnol, long int gr, 
            long int type, long int nodes[], double old_dof[], double new_dof[],
            double new_unknowns[], double grad_new_unknowns[], double h[], 
            double d[], double volume,
            double element_rhside[], double element_rhside_internal[],
            double element_rhside_static[], double element_residue[], 
            double element_lhside[], double element_matrix[],
            double cons_var_vel[], double grad_cons_var_flow[] );
void      geometry( long int inod, double co[], long int geometry_entity[],
            long int &found, double &factor, double normal[],
            double &penetration, double projection[],
            long int node_type, long int projection_type, long int version );
long int  get_group_data( long int idat, long int group, long int element,
            double new_unknowns[], double values[], long int &nvalue, long int task );
char     *get_new_char( long int n );
double   *get_new_dbl( long int n );
long int *get_new_int( long int n );
void      groundflow( long int element, long int group, long int nnol,
            double h[], double d[], double volume, double old_unknowns[], 
            double new_unknowns[], double grad_new_unknowns[],
            double element_matrix[], double element_rhside[],
            double element_rhside_internal[], double element_rhside_static[], 
            double element_residue[] );
void      hyperelasticity( long int element, long int gr, double old_unknowns[],
            double new_unknowns[], double old_epe[], double new_epe[], 
            double new_sig[], double Chyper[MDIM][MDIM][MDIM][MDIM] );
void      hyper_Cmat( long int hyper_type, double hyper_data[],
            double epe[], double Chyper[MDIM][MDIM][MDIM][MDIM] );
void      hyper_law( long int hyper_type, double hyper_data[], double C[], 
            double &W );
void      hyper_stress( long int hyper_type, double hyper_data[],
            double epe[], double stress[] );
void      initialize( void );
void      initialize_bounda_elem( long int control_solver );
void      input( );
void      input_convert_to_lower_case( char str[] );
void      input_read_string( long int echo, char str[] );
void      input_skip_comment( char str[] );
long int  integration_gauss( long int niso, double iso[], double weight_iso[]);
long int  integration_lobatto( long int niso, double iso[], 
            double weight_iso[] );
void      interpolate_geometry( long int geometry_entity[],
            long int node_numbers[], long int n,
            double test_coord[], double tmp_node[],
            double test_coord_start_refined[], 
            double tmp_node_start_refined[], 
            long int project_type, long int version );
void      interpolation_polynomial( double iso, long int npol, double h_pol[],
            double p_pol[] );
long int  intersect_line_with_line( double line_a0[], double line_a1[], 
            double line_b0[], double line_b1[], double &iso_line_a,
            double &iso_line_b );
long int  intersect_line_with_point( double line0[], double line1[], 
            double point[], double &iso_line );
long int  intersect_line_with_triangle( double line0[], double line1[], 
            double triangle0[], double triangle1[], double triangle2[], 
            double &iso_line, double iso_triangle[] );
void      inverse_calculation( long int ipar, long int npar, long int ipar_i,
            long int ipar_n, long int max_time, long int task );
void      locate( void );
char     *long_to_a( long int i, char str[] );
void      macro( void );
void      map_element( long int element );
void      map_node( long int inod );
void      materi( long int element, long int group, long int nnol, 
            long int npoint, double coord_ip[],
            double old_coord[], double h[], double new_d[], 
            double new_b[], double new_bnl[], double volume,
            double old_unknowns[], double new_unknowns[],
            double old_grad_old_unknowns[], double old_grad_new_unknowns[], 
            double new_grad_new_unknowns[], double element_lhside[], 
            double element_matrix[], double element_matrix_stress_stiffness[],
            double element_rhside[], double element_rhside_internal[], 
            double element_rhside_static[], double element_residue[], 
            double tendon_element_rhside[] );
void      matrix_ab( double *a, double *b, double *c, long int n, long int m,
            long int k );
void      matrix_abat( double a[], double b[], double c[], double work[],
            long int n );
void      matrix_abt( double *a, double *b, double *c, long int n, long int m,
            long int k );
void      matrix_atb( double *a, double *b, double *c, long int n, long int m,
            long int k );
void      matrix_atba( double a[], double b[], double c[], 
            double work[], long int n, long int m );
void      matrix_a4b( double a[MDIM][MDIM][MDIM][MDIM], double b[], 
            double c[] );
double    matrix_determinant( double a[], long int n );
void      matrix_eigenvalues( double a[], double eigenvalues[] );
void      matrix_invariants( double matrix[], double inv[] );
long int  matrix_inverse( double mat[], double inv_mat[], double &det, 
            long int n );
void      matrix_jacobi( double *a, long int n, double d[], 
            double *v, long int *nrot);
void      matrix_insert( double *a, long int n, long int m,
             double *b, long int k, long int l, long int p );
long int  membrane_apply( long int element, long int gr, double memmat[3][3], 
            double inc_ept[], double inc_epe[], double new_sig[] );
void      merge( void );
void      mesh_add( long int version_from, long int version_to );
void      mesh_has_changed( long int version );
void      new_mesh( void );
void      new_mesh_version( long int version, double delta );
void      nod_nod( long int version );
void      node_nonlocal_apply( void );
void      node_nonlocal_setup( void );
void      parallel_calcul_node( void );
void      parallel_contact( void );
void      parallel_element_loop( void );
void      parallel_geometry( void );
void      parallel_map_element( void );
void      parallel_map_node( void );
void      parallel_new_dof_before( void );
void      parallel_new_dof_diagonal( void );
void      parallel_post_point( void );
void      parallel_post_node( void );
void      parallel_solve_iterative_element( void );
void      parallel_sys_initialize( void );
void      parallel_sys_lock( void );
void      parallel_sys_next_of_loop( long int next_of_loop[], 
            long int max_loop, long int &nloop, long int &ithread );
void      parallel_sys_routine( void (*routine)(void) );
void      parallel_sys_unlock( void );
void      plasti_rule( long int element, long int group, double user_data[],
            double new_unknowns[], double new_grad_new_unknowns[],
            double old_hisv[], double new_hisv[], 
            double old_epp[], double inc_epp[], double inc_ept[],
            long int task, long int &plasti_type, 
            double sig[], double &f, double &new_f, double dir[] );
long int  point_el( double point[], double coord[], double weight[],
            long int name, long int nnol );
void      pol( long int element, long int element_group,
            long int name, long int nnol, double old_coord[], 
            double new_coord[], long int &npoint, double h[], double old_d[], 
            double new_d[], double new_b[], double new_bnl[], double volume[] );
void      post( void );
void      post_node_rhside_fixed_free( void );
void      pri( char *s );
void      pri( char *s, char *st );
void      pri( char *s, long int i );
void      pri( char *s, double d );
void      pri( char *s, long int i[], long int n );
void      pri( char *s, long int i[], long int n, long int m );
void      pri( char *s, double d[], long int n );
void      pri( char *s, double d[], long int n, long int m );
void      print( long int task, long int version, long int idat );
void      print_cmd( void );
void      print_data_versus_data( long int ival[], long int length );
void      print_gid( void );
void      print_gmv( long int icontrol, long int ival[] );
void      print_history( long int ival[], long int nval );
void      print_plotmtv( long int icontrol, long int ival[] );
void      print_matlab( void );
void      print_tecplot( long int ival[] );
void      print_vtk( long int icontrol );
long int  project_point_exactly_on_line( double coord[], double coord0[], 
            double coord1[], double weight[] );
long int  project_point_exactly_on_quad( double coord[], double coord0[], 
            double coord1[], double coord2[], double coord3[], double weight[] );
long int  project_point_exactly_on_triangle( double coord[], double coord0[], 
            double coord1[], double coord2[], double weight[] );
long int  project_point_on_line( double coord[], double coord0[], 
            double coord1[], double weight[] );
long int  project_point_on_triangle( double coord[], double coord0[], 
            double coord1[], double coord2[], double weight[] );
void      range_expand( long int ival[], long int integer_range[],
            long int &length, long int &range_length );
void      range_scan( long int ival[], long int &length );
void      range_testi( long int i );
void      refine_locally( void );
void      refine_globally( long int control_refine_globally[4], 
            long int length_control_refine_globally, 
            long int use_control_refine_globally_geometry, 
            long int control_refine_globally_geometry[2],
            long int project_type, long int version );
void      remesh( long int version );
void      renumbering( long int version, long int lowest_element, long int lowest_node );
void      renumbering_check( long int idat );
long int  repeat( long int &start_control );
void      restart( void );
double    scalar_dabs( double a );
double    scalar_dmax( double a, double b );
double    scalar_dmin( double a, double b );
long int  scalar_iabs( long int i );
long int  scalar_imax( long int a, long int b );
double    scalar_power( double a, double b );
double    scalar_ran_normal( int &idum );
double    scalar_ran_uniform( int &idum );
double    scalar_sign( double a );
double    scalar_square( double a );
void      set_deften_etc( long int element, long int gr, long int nnol, 
            double h[], double old_coord[],
            double old_unknowns[], double new_unknowns[], 
            double old_grad_old_unknowns[], double old_grad_new_unknowns[], 
            double old_ept[], double inc_ept[],
            double old_rot[], double inc_rot[], double new_rot[] );
void      set_environment( void );
void      set_stress( long int element, long int gr, double coord_ip[],
            double old_unknowns[], double new_unknowns[], 
            double old_grad_old_unknowns[], double new_grad_new_unknowns[],
            double rotated_old_sig[], double new_sig[],
            double rotated_old_msig[], double new_msig[], 
            double inc_ept[], double old_epe[], double inc_epe[], 
            double old_epp[], double inc_epp[], 
            double old_rho[], double new_rho[],
            double old_hisv[], double new_hisv[], 
            double old_damage, double &new_damage,
            double old_kappa, double &new_kappa,
            double &new_f, double ddsdde[] );
long int  set_swit( long int element, long int node, char routine[] );
void      sigmat_fill( double sigvec[], double sigmat[] );
void      slide( long int task );
void      solve( long int task );
void      solve_iterative( void );
void      solve_iterative_sys( double *Ad1, double *Ad2, double *p_tmp, double *residue );
void      solve_iterative_element( long int element, long int ithread );
void      sort( double val[], double vec[] );
void      split( long int version );
long int  stress_indx( long int idim, long int jdim );
void      stress_umat( long int element, long int gr,
            long int nuser_data, double user_data[], double coord_ip[],
            double old_hisv[], double new_hisv[], 
            double old_unknowns[], double new_unknowns[], 
            double old_epe[], double inc_epe[], 
            double rotated_old_sig[], double new_sig[],
            double ddsdde[] );
void      string_convert_to_lower_case( char str[] );
long int  string_isdouble( char str[] );
long int  string_isinteger( char str[] );
void      string_reverse( char str[] );
void      string_shorten( char str[], long int length );
long int  table_xy( double table[], long int length, double x, double &y );
void      tendon_distribute();
void      tendons( long int element, long int gr, long int nnol, 
            long int npoint, double volume,
            double new_d[], double old_unknowns[], double new_unknowns[],
            double new_rot[], double inc_ept[], double tendon_element_rhside[],
            double ddsdde_tendon[] );
double    tetrahedron_volume( double c0[], double c1[], 
            double c2[], double c3[] );
void      top( void );
double    triangle_area( double c0[], double c1[], double c2[] );
void      tyings_setup( long int from_node, long int to_node,
            long int tyings_unknowns[] );
void      tyings_rhside_lhside( void );
void      tyings_node_dof( long int version );
void      user_plasti( long int task, double user_data[],
            double new_unknowns[], double old_hisv[],
            double new_hisv[], double sig[], double &f );
void      user_sigma( double user_data[], double new_unknowns[], 
            double inc_epe[], double new_epe[], 
            double old_hisv[], double new_hisv[], 
            double old_sig[], double new_sig[], 
            double Cuser[MDIM][MDIM][MDIM][MDIM] );
void      user_viscosity( double user_data[], double new_unknowns[], 
            double &visc );
void      visco_elasticity( long int element, long int group, 
            double new_unknowns[], double inc_epe[], double rotated_old_msig[],
            double new_sig[], double new_msig[], double memmat[MDIM][MDIM] );
void      viscous_stress( long int element, long int gr, double user_data[],
            double old_unknowns[], double new_unknowns[], 
            double old_grad_old_unknowns[], double new_grad_new_unknowns[],
            double new_sig[] );
void      volume_factor( long int element_group, double coord[], double &volfac );
void      wave( long int element, long int gr, long int nnol,
            double h[], double d[], double volume, double new_unknowns[], 
            double grad_new_unknowns[], double element_matrix[],
            double element_rhside[], double element_rhside_internal[],
            double element_rhside_static[], double element_residue[] );
