
#ifndef __lisp_h__
#define __lisp_h__

#define NNODE 150000
#define MAX 100000
#define BUFLEN 1000

#define arg1 (p->tail->head)
#define arg2 (p->tail->tail->head)
#define arg3 (p->tail->tail->tail->head)

#define eval(p) ((p->f)(p))


typedef struct node
{
    struct node *head;
    struct node *tail;
    struct node *binding;
    struct node *(*f)(struct node *);
    char *s;
    int numer, denom;
    int tag;
} NODE;


extern NODE *nil, *t, *arglist;

void init(void);
void init_io(void);
void cleanup(void);
void load(char *s);
void read_eval_print(void);
NODE *lookup(char *s);
int Quit(void);
void push(NODE *p);
NODE *pop();
NODE *eval_args(NODE *p);
NODE* get_arg(int index); // Get zero-base arg from command line

int get_int(NODE* p);
float get_float(NODE* p);


#endif

