#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "serverside.h"
#include "configread.h"

// Define this!
extern void server_init(void);
extern void server_process(char* buffer, int process,int* buflen);
extern void server_exit(void);

int serverbusy=1;
char *the_address = "yacas_dbase";


#define SOCKLEN_T unsigned int //socklen_t
int main(int argc,char** argv)
{
    int server_sockfd, client_sockfd;
    SOCKLEN_T server_len, client_len;
    struct sockaddr_un server_address;
    struct sockaddr_un client_address;
    int result;
    fd_set readfds, testfds;

    ConfigInit();
    if (argc>1)
    {
        ParseConfigFile(argv[1]);
    }
    else
    {
        ParseConfigFile("yacasserver.ini");
    }
    server_init();
    
    unlink(the_address);

    server_sockfd = socket(AF_UNIX, SOCK_STREAM, 0);
    server_address.sun_family = AF_UNIX;
    strcpy(server_address.sun_path, the_address);
    server_len = sizeof(server_address);

    if (bind(server_sockfd, (struct sockaddr *)&server_address, server_len))
    {
        perror("DBaseServer Could not bind to the socket\n");
        exit(1);
    }
    if (listen(server_sockfd, 5))
    {
        perror("DBaseServer Could not listen to the socket\n");
        exit(1);
    }


    FD_ZERO(&readfds);
    FD_SET(server_sockfd, &readfds);

    atexit(server_exit);
    
    while(serverbusy)
    {
        int fd;
        int nread;
        testfds = readfds;

        //LOGTODO        printf("server waiting\n");
        result = select(FD_SETSIZE, &testfds, (fd_set *)0, 
                        (fd_set *)0, (struct timeval *) 0);

        if(result < 1)
        {
            perror("server5");
            exit(1);
        }
        for(fd = 0; fd < FD_SETSIZE; fd++)
        {
            if(FD_ISSET(fd,&testfds))
            {
                if(fd == server_sockfd)
                {
                    client_sockfd = accept(server_sockfd, 
                        (struct sockaddr *)&client_address, &client_len);
                    FD_SET(client_sockfd, &readfds);
                    //LOGTODO                    printf("adding client on fd %d\n", client_sockfd);
                }
                else
                {
                    ioctl(fd, FIONREAD, &nread);

                    if(nread == 0)
                    {
                        close(fd);
                        FD_CLR(fd, &readfds);
                        //LOGTODO                        printf("removing client on fd %d\n", fd);
                    }
                    else
                    {
                        char buffer[MAX_RETURNPAGE_SIZE];
                        int buflen;
                        //LOGTODO                        printf("nread=%d\n",nread);
                        if (nread>MAX_RETURNPAGE_SIZE)
                            nread=MAX_RETURNPAGE_SIZE;
                        read(fd, buffer, nread);
                        buffer[nread]='\0';
                        //LOGTODO                        printf("serving client on fd %d: \n", fd);
                        server_process(buffer,0,&buflen);
                        if (buflen>0)
                            write(fd, &buffer[0], buflen);
                        close(fd);
                        FD_CLR(fd, &readfds);
                        //LOGTODO                        printf("removing client on fd %d\n", fd);
                    }
                }
            }
        }
    }
    exit(0);
}
