
#ifndef __mathuserfunc_h__
#define __mathuserfunc_h__

#include "lispuserfunc.h"
#include "grower.h"


class BranchingUserFunction : public LispArityUserFunction
{
public:
    class BranchParameter
    {
    public:
        BranchParameter(LispStringPtr aParameter,
                        LispInt aHold=LispFalse)
            : iParameter(aParameter), iHold(aHold) {}
        LispStringPtr iParameter;
        LispInt       iHold;
    };
    class BranchRule
    {
    public:
        BranchRule(LispInt aPrecedence,LispPtr& aPredicate,LispPtr& aBody)
        {
            iPrecedence = aPrecedence;
            iPredicate.Set(aPredicate.Get());
            iBody.Set(aBody.Get());
        }
        LispInt iPrecedence;
        LispPtr iPredicate;
        LispPtr iBody;
    };
    BranchingUserFunction(LispPtr& aParameters);
    virtual ~BranchingUserFunction();
    virtual void Evaluate(LispPtr& aResult,LispEnvironment& aEnvironment,
                  LispPtr& aArguments);
    virtual void HoldArgument(LispStringPtr aVariable);
    virtual LispInt Arity() const;
    virtual void DeclareRule(LispInt aPrecedence, LispPtr& aPredicate,
                             LispPtr& aBody);
    virtual LispPtr& ArgList();
    
private:
    CArrayGrower<BranchParameter> iParameters;
    CArrayGrower<BranchRule*>     iRules;
    LispPtr iParamList;
};


#endif

