
#ifndef __pixels_h__
#define __pixels_h__

#include "triagetypes.h"
#include "fixed.h"
#include "interpolator.h"

inline PlatByte Red(PlatPixel _n)   {return (PlatByte)(((_n)    )&0xff);}
inline PlatByte Green(PlatPixel _n) {return (PlatByte)(((_n)>>8 )&0xff);}
inline PlatByte Blue(PlatPixel _n)  {return (PlatByte)(((_n)>>16)&0xff);}
inline PlatByte Alpha(PlatPixel _n) {return (PlatByte)(((_n)>>24)&0xff);}

inline const PlatPixel Pixel(PlatByte aRed, PlatByte aGreen,PlatByte aBlue,
             PlatByte aAlpha)
{
    return
        (PlatPixel)aRed +
        (((PlatPixel)aGreen)<<8) +
        (((PlatPixel)aBlue)<<16) +
        (((PlatPixel)aAlpha)<<24);
}
// PP does the same as Pixel, but in a defined way, so it can be used
// within templates.
#define PP(r_,g_,b_,a_) (r_)+ ((g_)<<8) +((b_)<<16) +((a_)<<25)

inline PlatPixel Mix(PlatPixel c0, PlatPixel c1, PlatInt weight)
{
    return Pixel(
                 Interpolate(Red(c0),Red(c1),weight),
                 Interpolate(Green(c0),Green(c1),weight),
                 Interpolate(Blue(c0),Blue(c1),weight),
                 Interpolate(Alpha(c0),Alpha(c1),weight)
                );
}

#endif

