/*
 *  Appindex browser, database converter
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: dbconv.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "appindex.h"

char *header[] =
{
  "",
  "syntax:",
  "name",
  "stable",
  "devel",
  "section/category",
  "license",
  "homepage",
  "download",
  "changelog",
  "deb",
  "rpm",
  "link",
  "oneliner",
  "description",
  "author <email>",
  "coauthor <email>",
  "dependancy",
  0
};

int
skip_to_next_app (FILE * f)
{
  char *line;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    return 1;

  while (fgets (line, LINE_LEN, f))
    {
      if (!strcmp (line, "%%\n"))
	{
	  free (line);
	  return 1;
	}
    }

  free (line);
  return 0;
}

void
putstr (FILE * db, char *s)
{
  int len;

  len = strlen (s);
  fwrite (&len, 2, 1, db);
  fwrite (s, len, 1, db);
}

void
usage (char *argv0)
{
  printf ("%s [text-file] [binary-file]\n"
	  "\n"
	  "This program converts new Freshmeat appindex.txt to appindex.db\n"
	"** THIS PROGRAM IS FOR INTERNAL USE ONLY, YOU DON'T NEED IT. **\n",
	  argv0);
}


int
main (int argc, char **argv)
{
  FILE *txt, *db;
  char *line;
  char gendate[0x40];
  int n;

  if ((argc != 3) || !strcmp (argv[1], "--help") || !strcmp (argv[1], "-h"))
    {
      usage (argv[0]);
      return 1;
    }

  txt = fopen (argv[1], "rt");
  if (!txt)
    {
      perror (argv[2]);
      return 1;
    }

  db = fopen (argv[2], "wb");
  if (!db)
    {
      perror (argv[3]);
      return 1;
    }

  line = (char *) malloc (LINE_LEN);
  if (!line)
    {
      fprintf (stderr, "Not enough memory\n");
      return 1;
    }

  if (!fgets (line, LINE_LEN, txt))
    {
      perror (argv[1]);
      return 1;
    }

  if (memcmp (line, "%%", 2))
    {
      fprintf (stderr, "%s:Unrecognized data format\n", argv[1]);
      return 1;
    }

  if (!fgets (line, LINE_LEN, txt))
    {
      perror (argv[1]);
      return 1;
    }

  if (line[strlen (line) - 1] == '\n')
    line[strlen (line) - 1] = 0;
  if (strncmp (line, "Date of generation: ", 20))
    {
      fprintf (stderr, "%s: Invald file format\n", argv[1]);
      return 2;
    }
  strcpy (gendate, line + 20);

  /* Write db header */
  fwrite ("%appindex database%\n", 20, 1, db);
  putstr (db, "Version1");
  putstr (db, gendate);

  n = 0;
  while (header[n])
    {
      if (!fgets (line, LINE_LEN, txt))
	{
	  perror (argv[1]);
	  return 1;
	}

      if (line[strlen (line) - 1] == '\n')
	line[strlen (line) - 1] = 0;
      if (strcmp (line, header[n]))
	{
	  fprintf (stderr, "%s: Invalid header %s\n", argv[1], line);
	  return 1;
	}
      n++;
    }

  while (skip_to_next_app (txt))
    {
#define GET_ITEM \
      if (!fgets(line,LINE_LEN,txt)) \
       {\
        perror(argv[1]);\
        return 1;\
       }\
      if (line[strlen (line) - 1] == '\n') \
        line[strlen (line) - 1] = 0;


      GET_ITEM;
      putstr (db, line);	/* name */
      GET_ITEM;
      putstr (db, line);	/* stable */
      GET_ITEM;
      putstr (db, line);	/* devel */
      GET_ITEM;
      putstr (db, line);	/* category */
      GET_ITEM;
      putstr (db, line);	/* license */
      GET_ITEM;
      putstr (db, line);	/* homepage */
      GET_ITEM;
      putstr (db, line);	/* download */
      GET_ITEM;
      putstr (db, line);	/* changelog */
      GET_ITEM;
      putstr (db, line);	/* deb */
      GET_ITEM;
      putstr (db, line);	/* rpm */
      GET_ITEM;
      putstr (db, line);	/* link */
      GET_ITEM;
      putstr (db, line);	/* oneliner */
      GET_ITEM;
      putstr (db, line);	/* description */
      GET_ITEM;
      putstr (db, line);	/* author */
      GET_ITEM;
      putstr (db, line);	/* coauthor */
      GET_ITEM;
      putstr (db, line);	/* dependancy */
      putstr (db, "");		/* End-of-record mark */

#undef GET_ITEM
    }
  fclose (txt);
  fclose (db);

  exit (0);
}
