/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: load.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "appindex.h"

#define APPINDEX_PREFIX "http://freshmeat.net/appindex/"

int total_apps;
char *dbfile;
extern char **environ;

/*
 * Name:  add_app2cat
 *
 * Description: Adds an application to category structure. This function also
 * sorts the application list.
 */
void
add_app2cat (struct category *cat, struct app *app)
{
  struct app *a, *pa;

  app->cat = cat;

  if (!cat->apps)		/* No applications in category */
    {
      app->next = 0;
      cat->apps = app;
      return;
    }

  if ((strcasecmp (cat->apps->name, app->name) >= 0 &&
       (cat->apps->priority == app->priority)) ||
      (cat->apps->priority < app->priority))	/* First_app > app */
    {
      app->next = cat->apps;
      cat->apps = app;
      return;
    }

  pa = 0;
  a = cat->apps;
  while (a)
    {
      if (a->next)
	if ((strcasecmp (a->name, app->name) <= 0 &&
	     strcasecmp (a->next->name, app->name) >= 0 &&
	     a->priority == app->priority &&
	     a->next->priority == app->priority) ||

	    (strcasecmp (a->name, app->name) <= 0 &&
	     a->priority == app->priority &&
	     a->next->priority < app->priority) ||

	    (strcasecmp (a->next->name, app->name) >= 0 &&
	     a->priority > app->priority &&
	     a->next->priority == app->priority) ||

	    (a->priority < app->priority &&
	     a->next->priority > app->priority))
	  {
	    app->next = a->next;
	    a->next = app;
	    return;
	  }			/* if (...) */
      pa = a;
      a = a->next;
    }				/* while(a) */

  app->next = 0;
  pa->next = app;
  return;
}

void
add_app (char *category, struct app *app)
{
  struct category *cat, *c, *pcat;

  app->priority = 0;

  if (categories)
    if (strcasecmp (category, categories->name) >= 0)
      goto scan;
  cat = (struct category *) malloc (sizeof (struct category));
  if (!cat)
    die ("Not enough memory");
  cat->name = strdup (category);
  if (!cat->name)
    die ("Not enough memory");
  cat->apps = 0;
  add_app2cat (cat, app);
  cat->next = categories;
  categories = cat;
  return;


scan:
  pcat = 0;
  c = categories;
  while (c)
    {
      if (!strcasecmp (c->name, category))
	{
	  add_app2cat (c, app);
	  return;
	}
      if (c->next)
	{
	  if ((strcasecmp (c->name, category) < 0)
	      && (strcasecmp (c->next->name, category) > 0))
	    {
	      cat = (struct category *) malloc (sizeof (struct category));
	      if (!cat)
		die ("Not enough memory");
	      cat->name = strdup (category);
	      if (!cat->name)
		die ("Not enough memory");
	      cat->apps = 0;
	      add_app2cat (cat, app);
	      cat->next = c->next;
	      c->next = cat;
	      return;
	    }
	}			/* if(c->next) */
      pcat = c;
      c = c->next;
    }
  cat = (struct category *) malloc (sizeof (struct category));
  if (!cat)
    die ("Not enough memory");
  cat->name = strdup (category);
  if (!cat->name)
    die ("Not enough memory");
  cat->apps = 0;
  add_app2cat (cat, app);
  cat->next = 0;
  pcat->next = cat;
  return;
}

void
load_file (FILE * f)
{
  char *line;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    return;

  if (!fgets (line, LINE_LEN, f))
    return;
  if (!memcmp (line, "%%", 2))
    load_txt (f);
  else if (!strcmp (line, "%appindex database%\n"))
    load_db (f);
  else if (!strcmp (line, "Begin3\n"))
    load_lsm (f);
  else
    die ("Unrecognized database format.");
  free (line);
}

FILE *
makepipe (FILE * in, char *cmd, char *filename)
{
  char *argv[4];
  int fds[2];
  char cmdline[0x100];
  FILE *f;

  pipe (fds);
  if (fork () == 0)
    {
      close (fds[0]);
      if (in)
	dup2 (fileno (in), 0);
      dup2 (fds[1], 1);
      close (fds[1]);
      argv[0] = "sh";
      argv[1] = "-c";
      strcpy (cmdline, cmd);
      if (filename)
	{
	  strcat (cmdline, " ");
	  strcat (cmdline, filename);
	}
      argv[2] = cmdline;
      argv[3] = 0;
      execve ("/bin/sh", argv, environ);
      _exit (127);
    }
  if (in)
    fclose (in);
  close (fds[1]);
  f = fdopen (fds[0], "r");
  return f;
}

static char fname[0x100];	/* FIXME: Temporary filename */

/*
 * Name: load_appindex
 *
 * Loads appindex database from txt or db file. (This is really *ugly* code,
 * I will rewrite it)
 */
void
load_appindex (char *file)
{
  FILE *f;

  total_apps = 0;
  if (file)
    {
      f = fopen (dbfile = file, "rt");
      if (f)
	{
	  loadinfo (file);
	  load_file (f);
	  fclose (f);
	  return;
	}
      else
	die ("Cannot open appindex data file");
    }

  if (use_lsm)
    goto LSM;			/* FIXME: @#$%^&*()_+*&^!!! */

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.appindex.db");
  f = fopen (dbfile = fname, "rt");
  if (f)
    {
      loadinfo (fname);
      load_file (f);
      fclose (f);
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.appindex.db.gz");
  f = fopen (dbfile = fname, "r");
  if (f)
    {
      loadinfo (fname);
      f = makepipe (f, "gzip -dc", 0);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.appindex.db.bz2");
  f = fopen (dbfile = fname, "r");
  if (f)
    {
      loadinfo (fname);
      f = makepipe (f, "bzip2 -dc", "~/.appindex.db.bz2");
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/appindex.db", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/appindex.db");
      load_file (f);
      fclose (f);
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/appindex.db.gz", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/appindex.db.gz");
      f = makepipe (f, "gzip -dc", 0);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/appindex.db.bz2", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/appindex.db.bz2");
      f = makepipe (f, "bzip2 -dc", "/var/lib/appindex/appindex.db.bz2");
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.appindex.txt");
  f = fopen (dbfile = fname, "rt");
  if (f)
    {
      loadinfo (fname);
      load_file (f);
      fclose (f);
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.appindex.txt.gz");
  f = fopen (dbfile = fname, "r");
  if (f)
    {
      loadinfo (fname);
      f = makepipe (f, "gzip -dc", 0);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.appindex.txt.bz2");
  f = fopen (dbfile = fname, "r");
  if (f)
    {
      loadinfo (fname);
      f = makepipe (f, "bzip2 -dc", "~/.appindex.txt.bz2");
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/appindex.txt", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/appindex.txt");
      load_file (f);
      fclose (f);
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/appindex.txt.gz", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/appindex.txt.gz");
      f = makepipe (f, "gzip -dc", 0);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/appindex.txt.bz2", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/appindex.txt.bz2");
      f = makepipe (f, "bzip2 -dc", "/var/lib/appindex/appindex.txt.bz2");
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  if ((dbfile = appindexurl) != 0)
    {
      loadinfo (appindexurl);
      f = makepipe (0, download, appindexurl);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

LSM:				/* FIXME */

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.LSM.current");
  f = fopen (dbfile = fname, "rt");
  if (f)
    {
      loadinfo (fname);
      load_file (f);
      fclose (f);
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.LSM.current.gz");
  f = fopen (dbfile = fname, "r");
  if (f)
    {
      loadinfo (fname);
      f = makepipe (f, "gzip -dc", 0);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  strcpy (fname, getenv ("HOME"));
  strcat (fname, "/.LSM.current.bz2");
  f = fopen (dbfile = fname, "r");
  if (f)
    {
      loadinfo (fname);
      f = makepipe (f, "bzip2 -dc", "~/.LSM.current.bz2");
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/LSM.current", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/LSM.current");
      load_file (f);
      fclose (f);
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/LSM.current.gz", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/LSM.current.gz");
      f = makepipe (f, "gzip -dc", 0);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  f = fopen (dbfile = "/var/lib/appindex/LSM.current.bz2", "r");
  if (f)
    {
      loadinfo ("/var/lib/appindex/LSM.current.bz2");
      f = makepipe (f, "bzip2 -dc", "/var/lib/appindex/LSM.current.bz2");
      load_file (f);
      fclose (f);
      //wait();
      return;
    }

  if ((dbfile = appindexurl) != 0)
    {
      loadinfo (appindexurl);
      f = makepipe (0, download, appindexurl);
      load_file (f);
      fclose (f);
      //wait();
      return;
    }
}

int
relink_app (struct app *apps)
{
  struct app *ap, *a;
  int n;

  a = apps;
  ap = 0;
  n = 0;
  while (a)
    {
      a->prev = ap;
      ap = a;
      a = a->next;
      n++;
    }
  return n;
}

void
relink_cat ()
{
  struct category *cp, *c;
  int n;

  c = categories;
  cp = 0;
  n = 0;
  while (c)
    {
      c->prev = cp;
      c->appno = relink_app (c->apps);
      cp = c;
      c = c->next;
      n++;
    }
  catno = n;
}
