/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: load_lsm.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include "appindex.h"

static char *months[12] =
{
  "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
  "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"
};

int
skip_to_next_lsm (FILE * f)
{
  char *line;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    die ("Not enough memory!");

  while (fgets (line, LINE_LEN, f))
    {
      if (!strncmp (line, "Begin3", 6))
	{
	  free (line);
	  return 1;
	}
    }

  free (line);
  return 0;
}


char *
compress (char *s)
{
  char *d = s, *o = s;

  while (isspace (*s))
    s++;

  while (*s)
    {
      if (*s == '\t')
	*s = ' ';
      if ((*s != '\n') && (!(isspace (*s) && isspace (*(s + 1)))))
	*d++ = *s;
      s++;
    }
  *d = 0;
  return o;
}

void
load_lsm (FILE * f)
{
  char *line, *buf;
  struct app *app;
  char category[0x10];
  int i;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    return;
  buf = (char *) malloc (LINE_LEN);
  if (!buf)
    return;
  buf[0] = 0;

  do
    {
      app = (struct app *) malloc (sizeof (struct app));
      if (!app)
	return;
      memset (app, 0, sizeof (struct app));

      while (fgets (line, LINE_LEN, f))
	{
	  if (line[0] == '\n')
	    continue;

	  if (isalpha (line[0]) && buf[0])
	    {
	      //printf("[%s]\r\n",buf);
#define GET_ITEM(x,y) \
	      if (!strncmp (buf, x, sizeof (x) - 1 )) \
		{ \
		  app->y = strdup (compress (buf + (sizeof(x) - 1) )); \
		}

	      GET_ITEM ("Title:", name);
	      GET_ITEM ("Copying-policy:", license);
	      GET_ITEM ("Author:", author);
	      GET_ITEM ("Description:", description);
	      GET_ITEM ("Version:", stable);
	      GET_ITEM ("Primary-site:", download);

	      if (!strncmp (buf, "Entered-date:", 13))
		{
		  compress (buf + 13);
#define ATON(x) (x-'0')
		  app->day = ATON (buf[13]) * 10 + ATON (buf[14]);
		  app->year = 1900 + ATON (buf[18]) * 10 + ATON (buf[19]);
#undef ATON
		  for (i = 0; i < 12; i++)
		    if (!memcmp (buf + 15, months[i], 3))
		      app->month = i + 1;
		}

#undef GET_ITEM
	      strcpy (buf, line);
	    }
	  if (!isalpha (line[0]))
	    if (strlen (line) + strlen (buf) < LINE_LEN)
	      strcat (buf, line);
	  if (!memcmp (line, "End\n", 4))
	    break;
	}
      if (app->name)
	{
	  total_apps++;
	  if (app->name)
	    {
	      if (app->name[0])
		{
		  category[0] = toupper (app->name[0]);
		  category[1] = '.';
		  category[2] = '.';
		  category[3] = '.';
		  category[3] = 0;
		}
	      else
		strcpy (category, "(unnamed)");
	      add_app (category, app);
	    }
	}
      loadstat (total_apps);
    }
  while (skip_to_next_lsm (f));

  free (line);
}
