/* Copyright Abandoned 1997 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** CONNECT.C - This is the ODBC sample driver code for
** allocation and connection.
*/

#include "myodbc.h"

#ifndef _UNIX_
#include <odbcinst.h>
#include "dialogs.h"
#endif /* IS NOT UNIX */

#ifndef CLIENT_NO_SCHEMA			/* Temporary fix for 3.21.29 */
#define CLIENT_NO_SCHEMA      16
#endif

//      CONNECT.C
//
//      SQLC connection functions.
//      -       -       -       -       -       -       -       -       -
//      Allocate an environment (ENV) block.


SQLRETURN SQL_API SQLAllocEnv(SQLHENV FAR * phenv)
{
  myodbc_init();
#ifndef _UNIX_
  {
    HGLOBAL henv= GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof (ENV));
    if (henv == NULL || (*phenv = (SQLHENV)GlobalLock (henv)) == NULL)
    {
      GlobalFree (henv);			/* Free it if lock fails */
      *phenv = SQL_NULL_HENV;
      return SQL_ERROR;
    }
  }
#else
  if (!(*phenv = (SQLHENV) my_malloc(sizeof(ENV),MYF(MY_ZEROFILL))))
  {
    *phenv = SQL_NULL_HENV;
    return SQL_ERROR;
  }
#endif /* IS UNIX */
  return SQL_SUCCESS;
}


SQLRETURN SQL_API SQLFreeEnv(SQLHENV henv)
{
#ifndef _UNIX_
  GlobalUnlock(GlobalHandle((HGLOBAL) henv));
  GlobalFree(GlobalHandle((HGLOBAL) henv));
#else
  my_free((char*) henv,MYF(0));
#endif /* IS UNIX */
  return SQL_SUCCESS;
}


//      -       -       -       -       -       -       -       -       -
//      Allocate a DBC block.

SQLRETURN SQL_API SQLAllocConnect(SQLHENV henv, SQLHDBC FAR *phdbc)
{
  DBC FAR *dbc;
#ifndef _UNIX_
  {
    HGLOBAL hdbc = GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof (DBC));
    if (!hdbc || (*phdbc = (SQLHDBC)GlobalLock (hdbc)) == SQL_NULL_HDBC)
    {
      GlobalFree (hdbc);	/* Free it if lock fails */
      *phdbc = SQL_NULL_HENV;
      return SQL_ERROR;
    }
  }
#else /* IS UNIX */
  if (!(*phdbc = (SQLHDBC) my_malloc(sizeof(DBC),MYF(MY_ZEROFILL))))
  {
    *phdbc = SQL_NULL_HDBC;
    return SQL_ERROR;
  }
#endif

  dbc=(DBC FAR*) *phdbc;
  dbc->env= (ENV*) henv;
  dbc->mysql.net.fd = -1;			/* Marker if open */
  dbc->flag=0;
  dbc->stmt_options.max_rows= dbc->stmt_options.max_length= 0L;
  dbc->stmt_options.bind_type=SQL_BIND_BY_COLUMN;
  dbc->stmt_options.rows_in_set=1;
  dbc->stmt_options.cursor_type=SQL_CURSOR_FORWARD_ONLY;  /* ODBC default */
  dbc->login_timeout=0;
  dbc->last_query_time= (time_t) time((time_t*) 0);
  return SQL_SUCCESS;
}


SQLRETURN SQL_API SQLFreeConnect(SQLHDBC hdbc)
{
  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLFreeConnect");

  my_free(dbc->dsn,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->database,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->server,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->user,MYF(MY_ALLOW_ZERO_PTR));
  my_free(dbc->password,MYF(MY_ALLOW_ZERO_PTR));

#ifndef _UNIX_
  GlobalUnlock(GlobalHandle((HGLOBAL) hdbc));
  GlobalFree(GlobalHandle((HGLOBAL) hdbc));
#else  /* IS UNIX */
  my_free((char*) hdbc,MYF(0));
#endif
  DBUG_RETURN(SQL_SUCCESS);
}

/****************************************************************************
** check the option flag and generate a connect flag
****************************************************************************/

ulong get_client_flag(MYSQL *mysql, ulong option_flag,uint connect_timeout,
		      char *init_stmt)
{
  ulong client_flag=CLIENT_ODBC;
  DBUG_ENTER("get_client_flag");

  mysql_init(mysql);
 #ifndef DBUG_OFF
  if (option_flag & FLAG_DEBUG && ! _db_on_)
    mysql_debug("d:t:S:O,c::\\myodbc.log");
#endif
  if (option_flag & (FLAG_FOUND_ROWS | FLAG_SAFE))
    client_flag|=   CLIENT_FOUND_ROWS;
  if (option_flag & FLAG_NO_SCHEMA)
    client_flag|=   CLIENT_NO_SCHEMA;
  if (option_flag & (FLAG_BIG_PACKETS | FLAG_SAFE))
    max_allowed_packet=~0L;
  if (option_flag & FLAG_COMPRESSED_PROTO)
    client_flag |=  CLIENT_COMPRESS;
  if (option_flag & FLAG_IGNORE_SPACE)
    client_flag |=  CLIENT_IGNORE_SPACE;
#ifdef __WIN32__
  if (option_flag & FLAG_NAMED_PIPE)
    mysql_options(mysql,MYSQL_OPT_NAMED_PIPE,NullS);
#endif
  if (option_flag & FLAG_USE_MYCNF)
    mysql_options(mysql,MYSQL_READ_DEFAULT_GROUP,"odbc");
  if (init_stmt && init_stmt[0])
    mysql_options(mysql,MYSQL_INIT_COMMAND,init_stmt);
  if (connect_timeout)
    mysql_options(mysql, MYSQL_OPT_CONNECT_TIMEOUT,(char*) &connect_timeout);
  DBUG_PRINT("info",("MyODBC Version %s  option_flag: %ld  client_flag: %ld",
		     DRIVER_VERSION, option_flag, client_flag));
  DBUG_RETURN(client_flag);
}


/******************************************************************************
*	Connect to mysql server
******************************************************************************/

SQLRETURN SQL_API SQLConnect(SQLHDBC hdbc, SQLCHAR FAR *szDSN,
			     SQLSMALLINT   cbDSN,
			     SQLCHAR FAR *szUID, SQLSMALLINT cbUID,
			     SQLCHAR FAR *szAuthStr, SQLSMALLINT cbAuthStr)
{
  char host[64],user[64],passwd[64],dsn[NAME_LEN+1],database[NAME_LEN+1],
       port[10],flag[10],init_stmt[256],*passwd_ptr,*dsn_ptr;
  char  szTRACE[FILENAME_MAX+1]  = "";
  
  uint port_nr=0;
  ulong flag_nr,client_flag;

  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLConnect");

  if (dbc->mysql.net.fd >= 0)
  {
    DBUG_RETURN(set_error(dbc,"08002","Connection in use",0));
  }
  dbc->sqlstate[0]=0;

  dsn_ptr=fix_str(dsn,szDSN,cbDSN);

  if(dsn_ptr && !dsn_ptr[0]) {
    DBUG_RETURN(set_error(dbc,"S1090","Invalid DSN specified",0));
  }

  SQLGetPrivateProfileString(dsn_ptr,"server",
			     "localhost", host, sizeof(host),"ODBC.INI");
  SQLGetPrivateProfileString(dsn_ptr,"database",
			     dsn_ptr, database, sizeof(database),"ODBC.INI");
  SQLGetPrivateProfileString(dsn_ptr,"port",
			     "0", port, sizeof(port),"ODBC.INI");
  port_nr=(uint) atoi(port);
  SQLGetPrivateProfileString(dsn_ptr,"option",
			     "0", flag, sizeof(flag),"ODBC.INI");
  flag_nr=(ulong) atol(flag);
  SQLGetPrivateProfileString(dsn_ptr,"stmt",
			     "", init_stmt, sizeof(init_stmt),"ODBC.INI");

  SQLGetPrivateProfileString( dsn_ptr, "TRACE", "", szTRACE, sizeof(szTRACE),
"ODBC.INI" );
 if (szTRACE[0] == '1' || toupper(szTRACE[0]) == 'Y' ||
     toupper(szTRACE[0]) == 'O')
 {
   char  szTRACEFILE[FILENAME_MAX+1] = "";
   char  szMYODBC_LOG[FILENAME_MAX+20]= "";
   SQLGetPrivateProfileString( dsn_ptr, "TRACEFILE", "", szTRACEFILE,
			       sizeof(szTRACEFILE), "ODBC.INI" );
   if (*szTRACEFILE)
   {
     sprintf(szMYODBC_LOG, "d:t:S:A,%s", szTRACEFILE);
     DBUG_POP();
     DBUG_PUSH(szMYODBC_LOG);
   }
 }

/* OBSOLETE
  strmov(database,szDSN);
  {
    char *cp;
    strmov(host, (cp = getenv("MYSQL_HOST")) ? cp : "localhost");
  }
  flag_nr=0;
  init_stmt[0]=0;
*/

  client_flag=get_client_flag(&dbc->mysql,flag_nr,(uint) dbc->login_timeout,
			      init_stmt);
  passwd_ptr=fix_str(passwd,(char FAR*) szAuthStr,cbAuthStr);
  if (!passwd_ptr[0])		/* Use my.cnf if empty password ! */
    passwd_ptr=0;
#if MYSQL_VERSION_ID >= 32200
  if (!mysql_real_connect(&dbc->mysql,host,fix_str(user,(char FAR *) szUID,
						   cbUID),
			  passwd_ptr,
			  database, port_nr,
			  NullS, (uint) client_flag))
  {
    strmov(dbc->sqlstate,"S1000");
    translate_error(dbc);
    DBUG_RETURN(SQL_ERROR);
  }
#else
  if (!mysql_real_connect(&dbc->mysql,host,fix_str(user,(char FAR *) szUID,
						   cbUID),
			  passwd_ptr,
			  port_nr, NullS, (uint) client_flag))
  {
    strmov(dbc->sqlstate,"S1000");
    translate_error(dbc);
    DBUG_RETURN(SQL_ERROR);
  }
  if (mysql_select_db(&dbc->mysql,database))
  {
    strmov(dbc->sqlstate,"08004");
    mysql_close(&dbc->mysql);
    DBUG_RETURN(SQL_ERROR);
  }
#endif
  dbc->dsn=my_strdup(database,MYF(MY_WME));
  dbc->database=my_strdup(database,MYF(MY_WME));
  dbc->server=my_strdup(host,MYF(MY_WME));
  dbc->user=my_strdup(user,MYF(MY_WME));
  dbc->password=my_strdup(passwd,MYF(MY_WME));
  dbc->port=port_nr;
  dbc->flag=flag_nr;
  DBUG_RETURN(SQL_SUCCESS);
}


//	This function as its "normal" behavior is supposed to bring up a
//	dialog box if it isn't given enough information via "szConnStrIn".  If
//	it is given enough information, it's supposed to use "szConnStrIn" to
//	establish a database connection.  In either case, it returns a
//	string to the user that is the string that was eventually used to
//	establish the connection.

#ifdef _UNIX_					/* By Tsurng-Chen Chern */
char *my_strtok(char *s1, char *s2)
{
   char *start;
   static char *p;

   p = (s1 ? s1 : p + 1);
   if ((!p) || (!*p))
      return(NULL);

   start = p;
   while ((*p) && (!strchr(s2, *p)))
      p++;
   *p = 0;
   return(start);
}
#endif


SQLRETURN SQL_API SQLDriverConnect(SQLHDBC hdbc,SQLHWND hwnd,SQLCHAR FAR *szConnStrIn,
				   SQLSMALLINT cbConnStrIn,SQLCHAR FAR *szConnStrOut,
				   SQLSMALLINT cbConnStrOutMax,
				   SQLSMALLINT FAR *pcbConnStrOut,
				   SQLUSMALLINT fDriverCompletion)
{
#ifndef _UNIX_

  short   iRet;
  BOOL    fPrompt = FALSE,maybe_prompt;
  DBC FAR *dbc=(DBC FAR*) hdbc;
  GLOBALHANDLE hglbAttr;
  LPSETUPDLG lpsetupdlg;
  ulong client_flag;
  DBUG_ENTER("SQLDriverConnect");
  DBUG_PRINT("enter",("fDriverCompletion: %d",fDriverCompletion));

  hglbAttr = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, sizeof(SETUPDLG));
  if (!hglbAttr)
    DBUG_RETURN(FALSE);
  lpsetupdlg = (LPSETUPDLG)GlobalLock(hglbAttr);

  maybe_prompt=(fDriverCompletion == SQL_DRIVER_COMPLETE ||
		fDriverCompletion == SQL_DRIVER_COMPLETE_REQUIRED);
  if ((szConnStrIn == NULL) || (!cbConnStrIn) ||
      ((cbConnStrIn == SQL_NTS) && (!szConnStrIn[0])))
  {
    DBUG_PRINT("info",("No connection arguments"));
    fPrompt = TRUE;
  }
  else
  {
    ulong flag;
    /* Check connection string for completeness. Prompt if not all params */
    ParseAttributes(szConnStrIn, lpsetupdlg);
    set_attributes(lpsetupdlg);
    flag=(ulong) atol(lpsetupdlg->aAttr[KEY_FLAG].szAttr);
    if (fDriverCompletion == SQL_DRIVER_PROMPT && ! (flag & FLAG_NO_PROMPT) ||
	(maybe_prompt &&
	 (!lpsetupdlg->aAttr[KEY_DSN].szAttr[0] ||
	  !lpsetupdlg->aAttr[KEY_SERVER].szAttr[0] ||
	  !lpsetupdlg->aAttr[KEY_USER].szAttr[0])))
    {
      DBUG_PRINT("info",("flag: %d  dsn:  '%s'  server: '%s'  user: '%s'",
			 flag,
			 lpsetupdlg->aAttr[KEY_DSN].szAttr,
			 lpsetupdlg->aAttr[KEY_SERVER].szAttr,
			 lpsetupdlg->aAttr[KEY_USER].szAttr));
      fPrompt = TRUE;
    }
  }
retry:
  if (fPrompt)
  {
    iRet = DialogBoxParam(s_hModule, MAKEINTRESOURCE(DRIVERCONNECT), hwnd,
		          (DLGPROC) DriverConnectProc,
		          (LONG)(LPSTR) lpsetupdlg);
    if ((!iRet) || (iRet == -1))
    {
      GlobalUnlock(hglbAttr);
      GlobalFree(hglbAttr);
      DBUG_RETURN(SQL_NO_DATA_FOUND);
    }
  }
  if (szConnStrOut)
  {
    char *pos,buff[1024];
    long length;
    ulong tmp= ~0L;
    pos=strxmov(buff,
		"DSN=",lpsetupdlg->aAttr[KEY_DSN].szAttr,
		";DB=",lpsetupdlg->aAttr[KEY_DB].szAttr,
		";SERVER=",lpsetupdlg->aAttr[KEY_SERVER].szAttr,
		";UID=",lpsetupdlg->aAttr[KEY_USER].szAttr,
		";PWD=",lpsetupdlg->aAttr[KEY_PASSWORD].szAttr,
		";PORT=",lpsetupdlg->aAttr[KEY_PORT].szAttr,
		";OPTION=",lpsetupdlg->aAttr[KEY_FLAG].szAttr,
		";STMT=",lpsetupdlg->aAttr[KEY_STMT].szAttr,
		";",NullS);
    (void) copy_lresult((DBC FAR*) 0,szConnStrOut,cbConnStrOutMax,
                        &length,buff,(uint) (pos-buff),0L,0L,&tmp,0);
    if (pcbConnStrOut)
      *pcbConnStrOut=(SQLSMALLINT) length;
    DBUG_PRINT("info",("Connect string out: %s",szConnStrOut));
  }
  dbc->port=atoi(lpsetupdlg->aAttr[KEY_PORT].szAttr);
  dbc->flag=(uint) atol(lpsetupdlg->aAttr[KEY_FLAG].szAttr);
  client_flag=get_client_flag(&dbc->mysql,dbc->flag,(uint) dbc->login_timeout,
			      lpsetupdlg->aAttr[KEY_STMT].szAttr);

  /* If no DB, use DSN as database name */
  if (!lpsetupdlg->aAttr[KEY_DB].szAttr[0])
  {
    strmov(lpsetupdlg->aAttr[KEY_DB].szAttr,
	   lpsetupdlg->aAttr[KEY_DSN].szAttr);
  }
  if (!mysql_real_connect(&dbc->mysql,lpsetupdlg->aAttr[KEY_SERVER].szAttr,
			  lpsetupdlg->aAttr[KEY_USER].szAttr,
			  (lpsetupdlg->aAttr[KEY_PASSWORD].szAttr[0] ?
			   lpsetupdlg->aAttr[KEY_PASSWORD].szAttr : NullS),
			  lpsetupdlg->aAttr[KEY_DB].szAttr,
			  dbc->port,NullS,(uint) client_flag))
  {
    if (maybe_prompt && !fPrompt)
    {
      fPrompt=TRUE;
      goto retry;
    }
    strmov(dbc->sqlstate,"S1000");
    GlobalUnlock(hglbAttr);
    GlobalFree(hglbAttr);
    DBUG_RETURN(SQL_ERROR);
  }
  dbc->dsn=my_strdup(lpsetupdlg->aAttr[KEY_DSN].szAttr,MYF(MY_WME));
  dbc->database=my_strdup(lpsetupdlg->aAttr[KEY_DB].szAttr,MYF(MY_WME));
  dbc->server=my_strdup(lpsetupdlg->aAttr[KEY_SERVER].szAttr,MYF(MY_WME));
  dbc->user=my_strdup(lpsetupdlg->aAttr[KEY_USER].szAttr,MYF(MY_WME));
  dbc->password=my_strdup(lpsetupdlg->aAttr[KEY_PASSWORD].szAttr,MYF(MY_WME));

  GlobalUnlock(hglbAttr);
  GlobalFree(hglbAttr);
  DBUG_RETURN(SQL_SUCCESS);
#endif /* IS NOT UNIX */

#ifdef _UNIX_
  SQLCHAR FAR *connstrin=NULL;
  char *KEY_DSN=NULL;
  char *KEY_SERVER=NULL;
  char *KEY_USER=NULL;
  char *KEY_PASSWORD=NULL;
  char *KEY_PORT=NULL;
  char *KEY_OPTION=NULL;
  char *KEY_DB=NULL;
  char *KEY_SOCKET=NULL;
  char *KEY_STMT=0;
  
  char *tok[9];
  char *tok2=NULL;
  char *tok3=NULL;
  int i;
  uint client_flag=0;
  
  char host[64],user[64],passwd[64],dsn[NAME_LEN+1],database[NAME_LEN+1],
       port[10],flag[10],socket[256],init_stmt[256],option[64];

  BOOL    fPrompt = FALSE;
  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLDriverConnect");
  DBUG_PRINT("enter",("fDriverCompletion: %d",fDriverCompletion));

  if ((szConnStrIn == NULL) || (!cbConnStrIn) ||
      ((cbConnStrIn == SQL_NTS) && (!szConnStrIn[0])))
    fPrompt = TRUE;
  else
  {
    /* Check connection string for completeness. */
    /* Prompt if not all params			 */

    connstrin=(SQLCHAR FAR *) my_strdup(szConnStrIn,MYF(MY_WME));

    tok[0]=my_strtok(connstrin,";");
    for (i=1 ; i <= 7 ; i++)
      tok[i]=my_strtok(NULL,";");
    tok[i]=NULL;

    for (i=0 ; tok[i] ; i++)
    {
      if (tok2 = my_strtok(tok[i], "="))
      {
	if (strcasecmp("DSN", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_DSN = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_DSN);
	    KEY_DSN = NULL;
	  }
	}

	if (strcasecmp("DB", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_DB = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_DB);
	    KEY_DB = NULL;
	  }
	}

	if (strcasecmp("UID", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_USER = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_USER);
	    KEY_USER = NULL;
	  }
	}

	if (strcasecmp("PWD", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_PASSWORD = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_PASSWORD);
	    KEY_PASSWORD = NULL;
	  }
	}

	if (strcasecmp("SERVER", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_SERVER = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_SERVER);
	    KEY_SERVER = NULL;
	  }
	}

	if (strcasecmp("PORT", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_PORT = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_PORT);
	    KEY_PORT = NULL;
	  }
	}

	if (strcasecmp("SOCKET", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_SOCKET = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_SOCKET);
	    KEY_PORT = NULL;
	  }
	}

	if (strcasecmp("OPTION", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_OPTION = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_OPTION);
	    KEY_PORT = NULL;
	  }
	}

	if (strcasecmp("STMT", tok2) == 0)
	{
	  if ((tok3 = my_strtok(NULL, "\0")) && tok3[0])
	    KEY_STMT = (char*) my_strdup(tok3, MYF(MY_WME));
	  else
	  {
	    x_free(KEY_STMT);
	    KEY_STMT = NULL;
	  }
	}

      }
    }

  if (KEY_DSN)
  {
    SQLGetPrivateProfileString(KEY_DSN,"server",
			       "localhost", host, sizeof(host),"ODBC.INI");
    if (!KEY_SERVER) KEY_SERVER = (char*) my_strdup(host, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"database",
			       KEY_DSN, database, sizeof(database),"ODBC.INI");
    if (!KEY_DB) KEY_DB = (char*) my_strdup(database, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"option",
			       "0", option, sizeof(option),"ODBC.INI");
    if (!KEY_OPTION) KEY_OPTION = (char*) my_strdup(option, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"port",
			       "3306", port, sizeof(port),"ODBC.INI");
    if (!KEY_PORT) KEY_PORT = (char*) my_strdup(port, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"stmt",
			       "", init_stmt, sizeof(init_stmt),"ODBC.INI");
    if (!KEY_STMT) KEY_STMT = (char*) my_strdup(init_stmt, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"user",
			       "dummy", user, sizeof(user),"ODBC.INI");
    if (!KEY_USER) KEY_USER = (char*) my_strdup(user, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"password",
			       "", passwd, sizeof(passwd),"ODBC.INI");
    if (!KEY_PASSWORD) KEY_PASSWORD = (char*) my_strdup(passwd, MYF(MY_WME));

    SQLGetPrivateProfileString(KEY_DSN,"socket",
			       "", socket, sizeof(socket),"ODBC.INI");
    if (!KEY_SOCKET) KEY_SOCKET = (char*) my_strdup(socket, MYF(MY_WME));
  }

    if (!KEY_DB && KEY_DSN)
      KEY_DB = (char*) my_strdup(KEY_DSN, MYF(MY_WME));

    if (!KEY_SERVER)
      KEY_SERVER = (char*) my_strdup("localhost", MYF(MY_WME));

    if (!KEY_PORT)
      KEY_PORT = (char*) my_strdup("3306", MYF(MY_WME));

    if (!KEY_SOCKET)
      KEY_SOCKET = (char*) my_strdup("", MYF(MY_WME));

    if (!KEY_USER)
      KEY_USER = (char*) my_strdup("dummy", MYF(MY_WME));

    if (!KEY_PASSWORD)
      KEY_PASSWORD = (char*) my_strdup("", MYF(MY_WME));

    if (!KEY_OPTION)
      KEY_OPTION = (char*) my_strdup("0", MYF(MY_WME));

    if (!KEY_STMT)
      KEY_STMT = (char*) my_strdup("", MYF(MY_WME));

    if (fDriverCompletion == SQL_DRIVER_PROMPT ||
	((fDriverCompletion == SQL_DRIVER_COMPLETE ||
	  fDriverCompletion == SQL_DRIVER_COMPLETE_REQUIRED) &&
	 (!KEY_DSN)))
      fPrompt = TRUE;
  }
  if (fPrompt)
  {
    DBUG_RETURN(set_error((DBC FAR*) hdbc,"S1000","No DSN entered",0));
  }

  if (szConnStrOut)
  {
    SQLCHAR FAR  *pos;
    pos=strxmov(szConnStrOut,
		"DSN=",KEY_DSN,
		";DB=",KEY_DB,
                ";SERVER=",KEY_SERVER,
                ";UID=",KEY_USER,
                ";PWD=",KEY_PASSWORD,
                ";PORT=",KEY_PORT,
                ";SOCKET=",KEY_SOCKET,
                ";OPTION=",KEY_OPTION,
		";STMT=",KEY_STMT,
		";",NullS);
    *pcbConnStrOut=(int) (pos-szConnStrOut);
  }
  dbc->flag=(uint) atol(KEY_OPTION);
  dbc->port=atoi(KEY_PORT);
  client_flag=get_client_flag(&dbc->mysql,dbc->flag,(uint) dbc->login_timeout,
			      KEY_STMT);

#if MYSQL_VERSION_ID >= 32200
  if (!mysql_real_connect(&dbc->mysql,KEY_SERVER,
			  KEY_USER,
			  KEY_PASSWORD[0] ? KEY_PASSWORD : NullS,
                          KEY_DB,
                          dbc->port,
			  KEY_SOCKET[0] ? KEY_SOCKET : NullS,
			  (uint) client_flag))
  {
    strmov(dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
#else
  if (!mysql_real_connect(&dbc->mysql,KEY_SERVER,
			  KEY_USER,
			  KEY_PASSWORD[0] ? KEY_PASSWORD : NullS,
                          dbc->port,
			  KEY_SOCKET[0] ? KEY_SOCKET : NullS,
			  (uint) client_flag))
  {
    strmov(dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  if (mysql_select_db(&dbc->mysql,KEY_DB))
  {
    strmov(dbc->sqlstate,"08004");
    mysql_close(&dbc->mysql);
    DBUG_RETURN(SQL_ERROR);
  }
#endif
  dbc->dsn=my_strdup(KEY_DSN,MYF(MY_WME));
  dbc->database=my_strdup(KEY_DB,MYF(MY_WME));
  dbc->server=my_strdup(KEY_SERVER,MYF(MY_WME));
  dbc->user=my_strdup(KEY_USER,MYF(MY_WME));
  dbc->password=my_strdup(KEY_PASSWORD,MYF(MY_WME));

  x_free(KEY_DSN);
  x_free(KEY_DB);
  x_free(KEY_SERVER);
  x_free(KEY_USER);
  x_free(KEY_PASSWORD);
  x_free(KEY_PORT);
  x_free(KEY_SOCKET);
  x_free(KEY_OPTION);
  x_free(KEY_STMT);
  x_free(connstrin);

  DBUG_RETURN(SQL_SUCCESS);
#endif /* IS UNIX */
}


SQLRETURN SQL_API SQLBrowseConnect(SQLHDBC hdbc,SQLCHAR FAR *szConnStrIn,
				 SQLSMALLINT cbConnStrIn,
				 SQLCHAR FAR *szConnStrOut,SQLSMALLINT cbConnStrOutMax,
				 SQLSMALLINT FAR *pcbConnStrOut)
{
  DBUG_ENTER("SQLBrowseConnect");
  DBUG_RETURN(set_error((DBC FAR*) hdbc,"IM001","This doesn't work yet",4000));
}


SQLRETURN SQL_API SQLDisconnect(SQLHDBC hdbc)
{
  LIST *list_element,*next_element;
  DBC FAR *dbc=(DBC FAR*) hdbc;
  DBUG_ENTER("SQLDisconnect");

  for (list_element=dbc->statements ; list_element ;
       list_element=next_element)
  {
    next_element=list_element->next;
    my_SQLFreeStmt((SQLHSTMT) list_element->data,SQL_DROP);
  }
  mysql_close(&dbc->mysql);
  my_free(dbc->dsn,MYF(0));
  my_free(dbc->database,MYF(0));
  my_free(dbc->server,MYF(0));
  my_free(dbc->user,MYF(0));
  my_free(dbc->password,MYF(0));
  dbc->dsn=dbc->database=dbc->server=dbc->user=dbc->password=0;
  DBUG_RETURN(SQL_SUCCESS);
}
