#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "perspic.h"

static void
do_fileselection(GtkMenuItem *menuitem,int tnew) {

  GtkWidget *f,*w;

  w=lookup_widget(GTK_WIDGET(menuitem),"window1");
  f=gtk_object_get_data(GTK_OBJECT(w),"fileselection1");
  gtk_object_set_data(GTK_OBJECT(f),"new",(void *)tnew);
  gtk_widget_show(f);

}

void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  do_fileselection(menuitem,1);

}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  do_fileselection(menuitem,0);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  gtk_main_quit();

}


void
on_copy1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_paste1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_find1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_find_again1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_font1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkWidget *w,*f,*w1;

  w=lookup_widget(GTK_WIDGET(menuitem),"tree1");
  w1=lookup_widget(GTK_WIDGET(menuitem),"window1");
  f=gtk_object_get_data(GTK_OBJECT(w1),"fontselectiondialog1");
  gtk_object_set_data(GTK_OBJECT(f),"widget",w);
  gtk_object_set_data(GTK_OBJECT(f),"function",tree_set_font);
  gtk_widget_show(f);

}


void
on_scroll_down1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkWidget *tree1;

  tree1=lookup_widget(GTK_WIDGET(menuitem),"tree1");
  query_word_lines(20,NULL);
  tree_load_lines(tree1);

}


void
on_font2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkWidget *w,*f,*w1;

  w=lookup_widget(GTK_WIDGET(menuitem),"text1");
  w1=lookup_widget(GTK_WIDGET(menuitem),"window1");
  f=gtk_object_get_data(GTK_OBJECT(w1),"fontselectiondialog1");
  gtk_object_set_data(GTK_OBJECT(f),"widget",w);
  gtk_object_set_data(GTK_OBJECT(f),"function",text_set_font);
  gtk_widget_show(f);

}


void
on_scroll_down2_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_scroll_up1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_define1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkWidget *defwin,*word_entry,*ce4;
  char *c;

  ce4=lookup_widget(GTK_WIDGET(menuitem),"combo_entry4");
  c=gtk_entry_get_text(GTK_ENTRY(ce4));

  defwin=lookup_widget(GTK_WIDGET(menuitem),"window2");
  gtk_widget_show(defwin);

  word_entry=lookup_widget(defwin,"entry2");
  gtk_entry_set_text(GTK_ENTRY(word_entry),c);
  gtk_signal_emit_by_name(GTK_OBJECT(word_entry),"activate");

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


static Sock ds;
static int def_suc;

static int
dict_done(Sock *s) {

  const char *c;

  if (s->v==s->v1)
    return 0;

  c=s->v;
  c--;
  if (*c!=10)
    return 0;

  for (c--;c>=(char *)s->v1 && *c!=10;c--);
  c++;

  if (*c=='2')
    def_suc=1;
  else
    def_suc=0;
  if (*c=='2' || *c=='4' || *c=='5') 
    return 1;
  else
    return 0;

}

void
on_entry2_activate                     (GtkEditable     *editable,
                                        gpointer         user_data)
{

  GtkWidget *ce1,*ce2,*tb2,*l7,*e3;
  GtkText *text;
  const gchar *word,*db,*strat;
  guint n,match;
  
  if (!(word=gtk_entry_get_text(GTK_ENTRY(editable))) || !*word)
    return;

  if (!ds.s) {
    e3=lookup_widget(GTK_WIDGET(editable),"entry3");
    on_entry3_activate(GTK_EDITABLE(e3),NULL);
  }

  if (!ds.s)
    return;

  l7=lookup_widget(GTK_WIDGET(editable),"label7");
  ce1=lookup_widget(GTK_WIDGET(editable),"combo_entry1");
  ce2=lookup_widget(GTK_WIDGET(editable),"combo_entry2");
  db=gtk_entry_get_text(GTK_ENTRY(ce1));
  strat=gtk_entry_get_text(GTK_ENTRY(ce2));

  tb2=lookup_widget(GTK_WIDGET(editable),"radiobutton2");
  match=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tb2));
  ds.v=ds.v1;
  if (match)
    l_str(ds.v,"Match %s %s %s\r\n",db,strat && *strat ? strat : ".",word);
  else
    l_str(ds.v,"Define %s %s\r\n",db,word);

  gtk_label_set(GTK_LABEL(l7),"Reading ...");
  while (gtk_events_pending())
    gtk_main_iteration();

  if (socks_process(&ds,&ds+1)) {
    gtk_label_set(GTK_LABEL(l7),"Failed reading data");
    return;
  }

  text=GTK_TEXT(lookup_widget(GTK_WIDGET(editable),"text2"));
  n=gtk_text_get_length(text);
  gtk_text_set_point(text,0);
  gtk_text_forward_delete(text,n);
  gtk_text_freeze(text);
  gtk_text_insert(text,NULL,NULL,NULL,ds.v1,ds.v-ds.v1);
  gtk_text_thaw(text);

  gtk_label_set(GTK_LABEL(l7),"Ready");


}



void
on_entry3_activate                     (GtkEditable     *editable,
                                        gpointer         user_data)
{

  gchar *hn;
  char *c,*cc;
  GtkWidget *combo1,*combo2,*l7,*we;
  GList *list;
  int j;

  l7=lookup_widget(GTK_WIDGET(editable),"label7");

  list=g_list_append(NULL,"");
  combo1=lookup_widget(GTK_WIDGET(editable),"combo1");
  gtk_combo_set_popdown_strings(GTK_COMBO(combo1),list);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry),"");

  combo2=lookup_widget(GTK_WIDGET(editable),"combo2");
  gtk_combo_set_popdown_strings(GTK_COMBO(combo2),list);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo2)->entry),"");
  g_list_free(list);

  we=lookup_widget(GTK_WIDGET(editable),"entry2");
  gtk_editable_set_editable(GTK_EDITABLE(we),0);

  gtk_label_set(GTK_LABEL(l7),"Connecting ...");
  while (gtk_events_pending())
    gtk_main_iteration();

  hn=gtk_entry_get_text(GTK_ENTRY(editable));
  if (socks_init(&ds,&ds+1,hn,2628,dict_done)) {
    gtk_label_set(GTK_LABEL(l7),"Connection failed");
    return;
  }

  usleep(10000);
  gtk_label_set(GTK_LABEL(l7),"Loading databases...");
  while (gtk_events_pending())
    gtk_main_iteration();

  ds.v=ds.v1;
  l_str(ds.v,"\r\n");
  if (socks_process(&ds,&ds+1)) {
    gtk_label_set(GTK_LABEL(l7),"Cannot read databases");
    return;
  }
  ds.v=ds.v1;
  l_str(ds.v,"show databases\r\n");
  if (socks_process(&ds,&ds+1) || !def_suc) {
    gtk_label_set(GTK_LABEL(l7),"Cannot read databases");
    return;
  }

  list=g_list_append(NULL,"*");
  for (j=0,c=ds.v=ds.v1;(ds.v=memchr(ds.v,10,ds.vz-ds.v));ds.v++,c=ds.v) {
    if (!j && isdigit(*c)) {
      j=1;
      continue;
    }
    if (*c=='.')
      break;
    cc=memchr(c,32,(char *)ds.v-c);
    cc=cc ? cc : ds.v;
    *cc=0;
    g_list_append(list,c);
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(combo1),list);
  g_list_free(list);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry),"*");

  gtk_label_set(GTK_LABEL(l7),"Loading strategies...");
  while (gtk_events_pending())
    gtk_main_iteration();
  ds.v=ds.v1;
  l_str(ds.v,"show strategies\r\n");
  if (socks_process(&ds,&ds+1) || !def_suc) {
    gtk_label_set(GTK_LABEL(l7),"Cannot read strategies");
    return;
  }

  list=g_list_append(NULL,".");
  for (j=0,c=ds.v=ds.v1;(ds.v=memchr(ds.v,10,ds.vz-ds.v));ds.v++,c=ds.v) {
    if (!j && isdigit(*c)) {
      j=1;
      continue;
    }
    if (*c=='.')
      break;
    cc=memchr(c,32,(char *)ds.v-c);
    cc=cc ? cc : ds.v;
    *cc=0;
    g_list_append(list,c);
  }
  gtk_combo_set_popdown_strings(GTK_COMBO(combo2),list);
  g_list_free(list);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo2)->entry),".");

  gtk_label_set(GTK_LABEL(l7),"Ready");
  gtk_editable_set_editable(GTK_EDITABLE(we),1);
  gtk_editable_paste_clipboard(GTK_EDITABLE(we));

}


void
on_combo1_popwin_hide               (GtkEditable     *editable,
				     gpointer         user_data)
{

  GtkWidget *we;

  we=lookup_widget(GTK_WIDGET(user_data),"entry2");
  gtk_signal_emit_by_name(GTK_OBJECT(we),"activate");


}


void
on_combo2_popwin_hide               (GtkEditable     *editable,
				     gpointer         user_data)
{

  GtkWidget *we;

  we=lookup_widget(GTK_WIDGET(user_data),"entry2");
  gtk_signal_emit_by_name(GTK_OBJECT(we),"activate");

}


void
on_ok_button1_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *fileselection1,*w,*t,*l;
  char *f1,*fe;
  const char *c;
  int new;

  fileselection1=lookup_widget(GTK_WIDGET(button),"fileselection1");
  gtk_widget_hide(fileselection1);
  c=gtk_file_selection_get_filename(GTK_FILE_SELECTION(fileselection1));
  new=(int)gtk_object_get_data(GTK_OBJECT(fileselection1),"new");
  query_new_dict(c,new);
  query_dict_files(&f1,&fe);
  w=gtk_object_get_data(GTK_OBJECT(fileselection1),"window1");
  t=lookup_widget(w,"tree1");
  tree_make_dict_tree(t,f1,fe);
  t=lookup_widget(w,"combo3");
  l=gtk_list_item_new_with_label ((gchar *)c);
  gtk_widget_show(l);
  gtk_container_add (GTK_CONTAINER(GTK_COMBO(t)->list),l);
  gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(t)->entry),c);
  gtk_signal_emit_by_name(GTK_OBJECT(GTK_COMBO(t)->popwin),"hide");

}


void
on_cancel_button1_pressed              (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *fileselection1;

  fileselection1=lookup_widget(GTK_WIDGET(button),"fileselection1");
  gtk_widget_hide(fileselection1);

}


void
on_ok_button2_pressed                  (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *f,*w;
  GdkFont *font;
  void (*func)(GtkWidget *,GdkFont *);

  f=lookup_widget(GTK_WIDGET(button),"fontselectiondialog1");
  gtk_widget_hide(f);
  font=gtk_font_selection_dialog_get_font(GTK_FONT_SELECTION_DIALOG(f));
  func=gtk_object_get_data(GTK_OBJECT(f),"function");
  w=gtk_object_get_data(GTK_OBJECT(f),"widget");
  func(w,font);

}


void
on_cancel_button2_pressed              (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *f;

  f=lookup_widget(GTK_WIDGET(button),"fontselectiondialog1");
  gtk_widget_hide(f);

}


void
on_apply_button1_pressed               (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *f,*w;
  GdkFont *font;
  void (*func)(GtkWidget *,GdkFont *);

  f=lookup_widget(GTK_WIDGET(button),"fontselectiondialog1");
  font=gtk_font_selection_dialog_get_font(GTK_FONT_SELECTION_DIALOG(f));
  func=gtk_object_get_data(GTK_OBJECT(f),"function");
  w=gtk_object_get_data(GTK_OBJECT(f),"widget");
  func(w,font);

}



void
on_radiobutton1_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

  GtkWidget *we;

  we=lookup_widget(GTK_WIDGET(togglebutton),"entry2");
  gtk_signal_emit_by_name(GTK_OBJECT(we),"activate");


}



void
on_button1_pressed                     (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *d;

  d=lookup_widget(GTK_WIDGET(button),"dialog1");
  gtk_widget_hide(d);


}


void
on_define_word1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkWidget *m,*defwin,*word_entry,*co,*w,*t;
  const char *s;

  m=lookup_widget(GTK_WIDGET(menuitem),"menu1");
  s=gtk_object_get_data(GTK_OBJECT(m),"text_selection");

  t=lookup_widget(GTK_WIDGET(menuitem),"text_widget");
  w=lookup_widget(GTK_WIDGET(t),"window1");
  defwin=gtk_object_get_data(GTK_OBJECT(w),"window2");
  gtk_widget_show(defwin);
  co=lookup_widget(GTK_WIDGET(defwin),"combo1");
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(co)->popwin),"hide",on_combo1_popwin_hide,co);
  co=lookup_widget(GTK_WIDGET(defwin),"combo2");
  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(co)->popwin),"hide",on_combo2_popwin_hide,co);

  word_entry=lookup_widget(defwin,"entry2");
  gtk_entry_set_text(GTK_ENTRY(word_entry),s);
  gtk_signal_emit_by_name(GTK_OBJECT(word_entry),"activate");
  

}


void
on_find_keyowrd1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  GtkWidget *m,*w,*t;
  char *c;

  m=lookup_widget(GTK_WIDGET(menuitem),"menu1");
  t=gtk_object_get_data(GTK_OBJECT(m),"text_widget");
  w=lookup_widget(t,"combo_entry4");
  c=gtk_object_get_data(GTK_OBJECT(m),"text_selection");
  gtk_entry_set_text(GTK_ENTRY(w),c);
  gtk_signal_emit_by_name(GTK_OBJECT(w),"activate");

}


void
on_combo_entry4_activate               (GtkEditable     *editable,
                                        gpointer         user_data)
{

  GtkWidget *tree1,*co4;
  const char *s,**d;
  Query *q;
  GList *list=NULL;

  s=gtk_entry_get_text(GTK_ENTRY(editable));
  list=g_list_append(list,(char *)s);
  co4=lookup_widget(GTK_WIDGET(editable),"combo4");
  query_new_word(s);
  d=query_word_derivatives(s);
  for (;d && *d;d++) 
    list=g_list_append(list,(char *)*d);
  gtk_combo_set_popdown_strings(GTK_COMBO(co4),list);
  g_list_free(list);
  q=(Query *)query_word_lines(20,NULL);
  tree1=lookup_widget(GTK_WIDGET(editable),"tree1");
  tree_load_lines(tree1);
}


void
on_combo3_popwin_hide               (GtkEditable     *editable,
				     gpointer         user_data)
{

  GtkWidget *ce3,*tr1,*e;
  char *s,*f1,*fe;

  ce3=lookup_widget(GTK_WIDGET(user_data),"combo_entry3");
  tr1=lookup_widget(GTK_WIDGET(user_data),"tree1");
  e=lookup_widget(GTK_WIDGET(user_data),"combo_entry4");
  s=gtk_entry_get_text(GTK_ENTRY(ce3));
  if (!s || !*s)
    return;
  if (!query_new_dict(s,0))
    return;
  query_dict_files(&f1,&fe);
  tree_make_dict_tree(tr1,f1,fe);
  
  gtk_signal_emit_by_name(GTK_OBJECT(e),"activate");

}

void
on_combo4_popwin_hide               (GtkEditable     *editable,
				     gpointer         user_data)
{


  on_combo_entry4_activate(GTK_EDITABLE(GTK_COMBO(user_data)->entry),NULL);

}

void
on_text1_copy_clipboard               (GtkEditable     *editable,
				       gpointer         user_data)
{


  on_combo_entry4_activate(GTK_EDITABLE(GTK_COMBO(user_data)->entry),NULL);

}


gboolean
on_text1_button_release_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  GtkWidget *m;
  GtkEditable *e;

  if (event->type!=GDK_BUTTON_RELEASE || event->button!=3)
    return FALSE;

  e=GTK_EDITABLE(widget);
  if (e->selection_start_pos == e->selection_end_pos) {

    char *c1,*c,*ce;

    c1=gtk_editable_get_chars(e,e->selection_start_pos - 20, e->selection_end_pos+20);
    for (c=c1+20;c>=c1 && (isalpha(*c) || *c=='\'');c--);
    c++;
    for (ce=c1+20;ce<=c1+40 && (isalpha(*ce) || *ce=='\'');ce++);
    *ce=0;
    if (isupper(*c)) {
      int i;

      for (i=1,ce=c+1;*ce;ce++)
	if (islower(*ce))
	  i=0;
      if (!i)
	for (i=1,ce=c+1;*ce;ce++)
	  if (isupper(*ce))
	    i=0;
      if (i)
	for (ce=c;*ce;ce++)
	  *ce=tolower(*ce);
    }


    m=gtk_object_get_data(GTK_OBJECT(widget),"menu1");
    gtk_object_set_data (GTK_OBJECT (m), "text_selection", c);
    gtk_object_set_data (GTK_OBJECT (m), "text_widget", widget);
  
    gtk_menu_popup(GTK_MENU(m),NULL,NULL,NULL,NULL,
		   event->button,event->time);

  } else {

    char *c;

    c=gtk_editable_get_chars(e,e->selection_start_pos, e->selection_end_pos);

    m=gtk_object_get_data(GTK_OBJECT(widget),"menu2");
    gtk_object_set_data (GTK_OBJECT (m), "text_selection", c);
    gtk_object_set_data (GTK_OBJECT (m), "text_widget", widget);
  
    gtk_menu_popup(GTK_MENU(m),NULL,NULL,NULL,NULL,
		   event->button,event->time);

  }    

  return FALSE;

}



