/*
 * Copyright (C) 1999  Mark Baysinger (mbaysing@ucsd.edu)
 * Copyright (C) 1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "config.h"
#include "setup.h"
#define TRACKER_INTERNAL_ACCESS
#define SERVER_INTERNAL_ACCESS
#include <stddef.h>
#ifdef HAVE_STRING_H
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif
#include <errno.h>
#include "compat/strerror.h"
#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#include <sys/utsname.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include "compat/netinet_in.h"
#include <arpa/inet.h>
#include "eventlog.h"
#include "connection.h"
#include "channel.h"
#include "prefs.h"
#include "game.h"
#include "version.h"
#include "server.h"
#include "addr.h"
#include "tracker.h"


static t_addrlist * track_servers=NULL;


extern int tracker_set_servers(char const * servers)
{
    t_addr const *         curr;
    t_list const * const * save;
    char                   temp[32];
    
    if (track_servers && addrlist_destroy(&track_servers)<0)
        eventlog(eventlog_level_error,"tracker_set_servers","unable to destroy tracker list");
    
    if (!servers)
	return 0;
    
    if (!(track_servers = addrlist_create(servers,INADDR_LOOPBACK,BNETD_TRACK_PORT)))
    {
	eventlog(eventlog_level_error,"tracker_set_servers","could not create tracking server list");
	return -1;
    }
    
    for (curr=addrlist_get_first(track_servers,&save); curr; curr=addrlist_get_next(&save))
    {
	if (addr_get_addr_str(curr,temp,sizeof(temp))<0)
	    strcpy(temp,"x.x.x.x:x");
	eventlog(eventlog_level_info,"tracker_set_servers","tracking packets will be sent to %s",temp);
    }
    
    return 0;
}


extern int tracker_send_report(t_addrlist const * laddrs)
{
    t_addr const *         currl;
    t_list const * const * savel;
    t_addr const *         currt;
    t_list const * const * savet;
    t_trackpacket          packet;
    struct utsname         utsbuf;
    struct sockaddr_in     tempaddr;
    t_laddr_info *         laddr_info;
    char                   tempa[64];
    char                   tempb[64];
    
    if (addrlist_get_length(track_servers)>0)
    {
	packet.packet_version = htons((unsigned short)TRACK_VERSION);
	/* packet.port is set below */
	packet.flags = 0;
	strncpy(packet.server_location,
		prefs_get_location(),
		sizeof(packet.server_location));
	packet.server_location[sizeof(packet.server_location)-1] = '\0';
	strncpy(packet.software,
		"bnetd",
		sizeof(packet.software));
	strncpy(packet.version,
		BNETD_VERSION,
		sizeof(packet.version));
	strncpy(packet.server_desc,
		prefs_get_description(),
		sizeof(packet.server_desc));
	packet.server_desc[sizeof(packet.server_desc)-1] = '\0';
	strncpy(packet.server_url,
		prefs_get_url(),
		sizeof(packet.server_url));
	packet.server_url[sizeof(packet.server_url)-1] = '\0';
	strncpy(packet.contact_name,
		prefs_get_contact_name(),
		sizeof(packet.contact_name));
	packet.contact_name[sizeof(packet.contact_name)-1] = '\0';
	strncpy(packet.contact_email,
		prefs_get_contact_email(),
		sizeof(packet.contact_email));
	packet.contact_email[sizeof(packet.contact_email)-1] = '\0';
	packet.users = htonl(connlist_login_get_length());
	packet.channels = htonl(channellist_get_length());
	packet.games = htonl(gamelist_get_length());
	packet.uptime = htonl(server_get_uptime());
	packet.total_logins = htonl(connlist_total_logins());
	packet.total_games = htonl(gamelist_total_games());
	
	if (uname(&utsbuf)<0)
	{
	    eventlog(eventlog_level_warn,"tracker_send_report","could not get platform info (uname: %s)",strerror(errno));
	    strncpy(packet.platform,"",sizeof(packet.platform));
	}
	else
	{
	    strncpy(packet.platform,
		    utsbuf.sysname,
		    sizeof(packet.platform));
	    packet.platform[sizeof(packet.platform)-1] = '\0';
	}
	
	for (currl=addrlist_get_first(laddrs,&savel); currl; currl=addrlist_get_next(&savel))
	{
	    if (!(laddr_info = addr_get_data(currl).p))
	    {
		eventlog(eventlog_level_error,"tracker_send_report","address data is NULL");
		continue;
	    }
	    packet.port = htons(addr_get_port(currl));
	    
	    for (currt=addrlist_get_first(track_servers,&savet); currt; currt=addrlist_get_next(&savet))
	    {
		memset(&tempaddr,0,sizeof(tempaddr));
		tempaddr.sin_family = AF_INET;
		tempaddr.sin_port = htons(addr_get_port(currt));
		tempaddr.sin_addr.s_addr = htonl(addr_get_ip(currt));
		
		if (addr_get_addr_str(currl,tempa,sizeof(tempa))<0)
		    strcpy(tempa,"x.x.x.x:x");
		if (addr_get_addr_str(currt,tempb,sizeof(tempb))<0)
		    strcpy(tempa,"x.x.x.x:x");
		/* eventlog(eventlog_level_debug,"tracker_send_report","sending tracking info from %s to %s",tempa,tempb); */
		
		if (sendto(laddr_info->usocket,&packet,sizeof(packet),0,(struct sockaddr *)&tempaddr,sizeof(tempaddr))<0)
		    eventlog(eventlog_level_warn,"tracker_send_report","could not send tracking information from %s to %s (sendto: %s)",tempa,tempb,strerror(errno));
	    }
	}
    }
    
    return 0;
}
