/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include "global.h"
#include "control-page.h"
#include "file-log.h"
#include "functions.h"
#include "../common/dnd.h"

void parse_logfile(GtkWidget *clist);

static GnomeUIInfo filelog_popup[] = {
    GNOMEUIINFO_ITEM_STOCK (N_("New"),
			    N_ ("Show the download window"),
			    pop_window_d, GNOME_STOCK_MENU_NEW),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Get Again"), NULL, reget_cb, 
                            GNOME_STOCK_MENU_REFRESH),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Clear Log File"), NULL, clear_log_cb,
                            GNOME_STOCK_MENU_TRASH),
    GNOMEUIINFO_END
};


GtkWidget *
control_filelog_new(ControlPage *child)
{
	GtkWidget *clist;
	GtkWidget *scroll;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	gchar	*clist_titles[] =
			 { _("Date"), _("Time"), _("Filename"),
			   _("Reason"), _("Path"), _("% Got"),
			   _("Current Size"), _("Total Size"),
			   _("Speed"), _("Transfer Time"),
			   _("URL")};


	scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
				       GTK_POLICY_AUTOMATIC,
                                       GTK_POLICY_AUTOMATIC);

	vbox = gtk_vbox_new(FALSE, TRUE);
        gtk_box_pack_start(GTK_BOX(vbox), scroll,TRUE,TRUE,0);
        gtk_widget_show(vbox);

        gtk_widget_show(scroll);

	clist = gtk_clist_new_with_titles(FL_TOTAL_COLS, clist_titles);
	gtk_clist_set_selection_mode((GtkCList *)clist, GTK_SELECTION_EXTENDED);
        gtk_container_add(GTK_CONTAINER(scroll), clist);
	gtk_widget_show(clist);

	/* Resize the columns ... */
	gtk_clist_set_column_width((GtkCList *)clist, FL_DATE, 55);
	gtk_clist_set_column_width((GtkCList *)clist, FL_TIME, 35);
	gtk_clist_set_column_width((GtkCList *)clist, FL_FILENAME, 150);
	gtk_clist_set_column_width((GtkCList *)clist, FL_REASON, 90);
	gtk_clist_set_column_width((GtkCList *)clist, FL_PATH, 140);
	gtk_clist_set_column_width((GtkCList *)clist, FL_PERCENT, 40);
	gtk_clist_set_column_width((GtkCList *)clist, FL_CURRENT_SIZE, 70);
	gtk_clist_set_column_width((GtkCList *)clist, FL_TOTAL_SIZE, 70);
	gtk_clist_set_column_width((GtkCList *)clist, FL_RATE_OVERALL, 60);
	gtk_clist_set_column_width((GtkCList *)clist, FL_TRANSFER_TIME, 80);
	gtk_clist_set_column_width((GtkCList *)clist, FL_URL, 50);

/*	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_DATE, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_TIME, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_REASON, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_PERCENT, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_CURRENT_SIZE, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_TOTAL_SIZE, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_RATE_OVERALL, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_TRANSFER_TIME, TRUE);
*/
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_FILENAME, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_PATH, TRUE);
	gtk_clist_set_column_auto_resize ((GtkCList *)clist, FL_URL, TRUE);

	gtk_clist_set_column_justification((GtkCList *)clist,
					FL_PERCENT, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					FL_CURRENT_SIZE, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					FL_TOTAL_SIZE, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					FL_RATE_OVERALL, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					FL_TRANSFER_TIME, GTK_JUSTIFY_RIGHT);

	hbox = gtk_hbox_new(FALSE, FALSE);
        gtk_box_pack_start(GTK_BOX(vbox), hbox,FALSE,FALSE,0);
        gtk_widget_show(hbox);

//	button = gtk_button_new_with_label("Clear Log File");
	button = gnome_pixmap_button(gnome_stock_new_with_icon
			(GNOME_STOCK_MENU_TRASH),_("Clear Log File"));
        gtk_box_pack_start(GTK_BOX(vbox), button,FALSE,FALSE,5);
        gtk_widget_show(button);
        gtk_signal_connect(GTK_OBJECT(button), "clicked",
                        GTK_SIGNAL_FUNC (clear_log_cb), clist);

	if (!GTK_IS_MENU(filelog_popup_menu))
	   filelog_popup_menu = gnome_popup_menu_new (filelog_popup);
	gnome_popup_menu_attach(filelog_popup_menu, clist, NULL);

//	gtk_signal_connect_object (GTK_OBJECT (clist), "event",
//	                           GTK_SIGNAL_FUNC (clist_event),
//	                           NULL);

	if ((history_read) || (!startup))
	{
	   parse_logfile(clist);
	   updated = TRUE;
	}
	flogs = g_list_append(flogs, clist);

	CONTROL_PAGE(child)->main_widget = GTK_WIDGET(clist);
        return vbox;

}

/***********************************************************************/

static void CopyPointers(gchar *st[FL_TOTAL_COLS], FileInfo *data)
{
	time_t now;
	struct tm *time_now;

	time(&now);
	time_now = localtime(&now);
	st[FL_DATE] = g_strdup_printf("%d/%d/%d", time_now->tm_mday,
	   					time_now->tm_mon + 1, time_now->tm_year);
	st[FL_TIME] = g_strdup_printf("%.2d:%.2d", time_now->tm_hour,
	   					time_now->tm_min);
	st[FL_FILENAME] = data->filename;
	st[FL_REASON] = data->activity;
	st[FL_PATH] = data->local_path;
	st[FL_PERCENT] = data->percent_str;
	st[FL_CURRENT_SIZE] = bytes_to_string(data->current_size);
	st[FL_TOTAL_SIZE] = bytes_to_string(data->total_size);
	st[FL_RATE_OVERALL] = bytesXs_to_string(data->rate_overall);
	st[FL_TRANSFER_TIME] = seconds_to_string(data->current_time);
	st[FL_URL] = data->url;
}

static void free_CopyPointers(gchar *st[FL_TOTAL_COLS])
{
	g_free(st[FL_DATE]);
	g_free(st[FL_TIME]);
//	st[FL_FILENAME] = data->filename;
//	st[FL_REASON] = data->activity;
//	st[FL_PATH] = data->local_path;
//	st[FL_PERCENT] = data->percent_str;
	g_free(st[FL_CURRENT_SIZE]);
	g_free(st[FL_TOTAL_SIZE]);
	g_free(st[FL_RATE_OVERALL]);
	g_free(st[FL_TRANSFER_TIME]);
//	st[FL_URL] = data->url;
}



void update_flogs(FileInfo *old_fi)
{
	GtkWidget *clist;
	GList *lists;
	gint row;

	FileInfo *new_fi;

	gchar *st[FL_TOTAL_COLS];

	lists = g_list_first(flogs);

	while(lists)
	{
           new_fi = (FileInfo *) g_malloc (sizeof (FileInfo));
	   
	   clist = GTK_WIDGET(lists->data);

	   CopyPointers(st, old_fi);
	   row = gtk_clist_prepend((GtkCList *)clist, st);
	   free_CopyPointers(st);

	   new_fi->id = g_strdup(old_fi->id);
	   new_fi->type = old_fi->type;
	   new_fi->filename = g_strdup(old_fi->filename);
	   new_fi->local_path = g_strdup(old_fi->local_path);
	   new_fi->activity = g_strdup(old_fi->activity);
	   new_fi->percent_str = g_strdup(old_fi->percent_str);
	   new_fi->url = g_strdup(old_fi->url);

	   gtk_clist_set_row_data((GtkCList *)clist, row, (FileInfo *) new_fi);

//FIXME: put this in a function
	      switch (new_fi->type) {
		case NORMAL:    gtk_clist_set_background ((GtkCList *)clist, row, &White);
						break;
		case ERROR:     gtk_clist_set_background ((GtkCList *)clist, row, &Red);
						break;
		case CANCELATION:    gtk_clist_set_background ((GtkCList *)clist, row, &Brown);
						break;
		case COMPLETION:gtk_clist_set_background ((GtkCList *)clist, row, &Green);
						break;
		case IGNORE:    break;
		}
	   lists = lists->next;
	}
}

/***********************************************************************/

void parse_logfile(GtkWidget *clist)
{
	FILE *file;
	char buffer[2048];
	char date[10];
	char time[10];
	char id[4]; // added by Ashley
	gint row;
	FileInfo *data = NULL;
	gchar *st[FL_TOTAL_COLS];

	gchar activity[256];
        char aux[256];
	char protocol[5];
	char server[256];
	gchar path[256];
	gchar local_path[256];


#ifdef DEBUG_MESSAGES
	g_print("Log File: %s\n", DX_FileLogName);
#endif DEBUG_MESSAGES

    file = fopen(DX_FileLogName, "r");
    if (file)
    {
	gtk_clist_freeze(GTK_CLIST(clist));
        memset(buffer, 0, sizeof(buffer));
/*FIXME: Should I use dl_StripComments here? I know that
	 only the first line contains a comment...*/
	DX_ReadFileLine(buffer, sizeof(buffer), file);
        while (DX_ReadFileLine(buffer, sizeof(buffer), file))
        {
           data = (FileInfo *) g_malloc (sizeof (FileInfo));

           DX_ParseFileLogLine(buffer, date, sizeof(date), time, sizeof(time),
			protocol, server, sizeof(server), path,	sizeof(path),
			local_path, sizeof(local_path), &data->current_size,
			&data->total_size, &data->current_time,
			&data->rate_overall, activity,
			sizeof(activity), id); // changed by Ashley
	
	   data->id			  = g_strdup(id);
	   data->filename     = strdup(strrchr(path,'/')+1);
	   data->local_path   = strdup(local_path);
	   data->activity     = strdup(activity);
	   if (data->total_size > 0)
	      data->percent   = ((data->current_size*100)/data->total_size);
	   else
	      data->percent   = 0;
	   data->percent_str = g_strdup_printf("%i %%", data->percent);	      
	   sprintf (aux, "%s://%s%s", protocol, server, path);
	   data->url          = strdup(aux);

	   if (strcmp(data->activity, "File complete") == 0)
	      data->type = COMPLETION;
	   else
	      {
	      if (strcmp(data->activity, "File cancelled") == 0)
	         data->type = CANCELATION;
	      else
	         data->type = ERROR;
	      }

//FIXME: Use g_strdup_printf() here!
	      st[FL_DATE] = strdup(date);
	      st[FL_TIME] = strdup(time);
	      st[FL_FILENAME] = data->filename;
	      st[FL_REASON] = data->activity;
	      st[FL_PATH] = data->local_path;
	      st[FL_PERCENT] = data->percent_str;
	      st[FL_CURRENT_SIZE] = bytes_to_string(data->current_size);
	      st[FL_TOTAL_SIZE] = bytes_to_string(data->total_size);
	      st[FL_RATE_OVERALL] = bytesXs_to_string(data->rate_overall);
	      st[FL_TRANSFER_TIME] = seconds_to_string(data->current_time);

	      st[FL_URL] = data->url;
	      row = gtk_clist_prepend((GtkCList *)clist, st);
	      gtk_clist_set_row_data((GtkCList *)clist, row, (FileInfo *) data);

	      //g_free the pointers
	      g_free(st[FL_DATE]);
	      g_free(st[FL_TIME]);
	      g_free(st[FL_CURRENT_SIZE]);
	      g_free(st[FL_TOTAL_SIZE]);
	      g_free(st[FL_RATE_OVERALL]);
	      g_free(st[FL_TRANSFER_TIME]);

	      put_color(clist, row, data->type);
	}
	gtk_clist_thaw(GTK_CLIST(clist));
	fclose(file);
    }
}
