#ifndef UTIL_H
#define UTIL_H

#include <includes.h>

void *malloc0(long size);
char *itoa(int n);
void stripcrlf(char *s);
void stripl(char *s);
void stripr(char *s);
void strip(char *s);
void strinss(char *buf, const char *s);
void strdelch(char *buf);
char *strupr(char *s);
char *strlwr(char *s);
unsigned int smov(char *dst, const char *src);
char *squish_argv(char **argv);
char *squish_argvs(char **argv, int skip, int num);
char *squish_argvc(char **argv, int argc);
char *squish_argvcs(char **argv, int argc, int skip, int num);
int char_count(const char *buf, char c);
char **line_break(const char *buf, char del);
char *asciize(char *str, int n);
int deasciize(char *dest, const char *str, int n);
char *get_token(char **src, const char *token_sep);
char *strcasestr(const char *s1, const char *s2);
int our_fnmatch(const char *pattern, const char *string, int flags);
int array_size(void **array);
void *grow_array(void ***array, size_t size);
void shrink_array(void ***array, int n);
int str_count(char ***array);
int str_add(char ***array, const char *string);
int str_del(char ***array, int n);
int str_clear(char ***array);
int str_search(char ***array, const char *pattern);
int str_match(char ***array, const char *pattern);
void str_swap(char ***array, int a, int b);
void str_shuffle(char ***array);
void str_init(char ***array);
int max(int a, int b);
int min(int a, int b);
char *crypt_passwd(const char *pass);
int smallhash(const char *buf);
char *mycrypt(const char *key, const char *salt);
int isnumeric(const char *num);
int issignednum(const char *num);
int vscnprintf(char *buf, size_t size, const char *fmt, va_list ap);
int scnprintf(char *buf, size_t size, const char *fmt, ...);
int scprintf(char *buf, const char *fmt, ...);
#ifndef HAVE_ASPRINTF
int vasprintf(char **strp, const char *fmt, va_list ap);
int vaprintf(char **strp, const char *fmt, ...);
#endif
#ifndef HAVE_DPRINTF
int dprintf(int fd, const char *fmt, ...);
#endif
char *mybasename(const char *s);
int copyfile (const char *source, const char *dest);
int fexist(const char *filename);
int fisdir(const char *filename);
char *fgetsc(char *s, int size, FILE *stream);
char *strregerr(int err, regex_t *trig_reg);
int iswild(char c);
int valid_mask(const char *mask);
int ftrim(const char *fn, int n);
int read_db(const char *buf, char delim, const char *fmt, ...);
char *strredup(char *var, const char *str);

#endif
