#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <gtk/gtk.h>

#ifdef MIN
#undef MIN
#endif
#ifdef MAX
#undef MAX
#endif

#include <sys/param.h>
#include <sys/types.h>

#include "gfcc.h"

#define MCOLS 7
#define TIMEOUT 2000

struct masq_timeout {
	int tcp_timeout;
	int tcp_fin_timeout;
	int udp_timeout;
} timeouts;

static gchar *titles[MCOLS] = {
	"Proto",	"Expire",	"Source",
	"Destination",	"Sport",	"Mport",	"Dport"
};

static void mwin_destroy(GtkWidget *, gpointer);
static void mlist_pause(GtkWidget *, gpointer);
static gint get_masq_list_data(gpointer);
static gint check_timeout();

static GtkWidget *masq_win = NULL;
static GtkWidget *mlist;
static GtkWidget *mtcp=NULL, *mtcpfin=NULL, *mudp=NULL;
static gint tag=0;

static void mwin_destroy(GtkWidget *widget, gpointer data)
{
	if(check_timeout() < 0)
		return;

	gtk_timeout_remove(tag);
	gtk_widget_destroy(masq_win);
	masq_win = NULL;
}

void masq_list(GtkWidget *widget, gpointer data)
{
	GtkWidget *vbox, *hbox, *button;
	GtkWidget *scrolled_window;
	
	if(masq_win)
		mwin_destroy(NULL, NULL);

	masq_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(masq_win, 540, 500);
	gtk_window_set_position(GTK_WINDOW(masq_win), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(masq_win), "Masquerade list");
	gtk_container_set_border_width(GTK_CONTAINER(masq_win), 10);
	gtk_signal_connect(GTK_OBJECT(masq_win), "destroy",
			GTK_SIGNAL_FUNC(mwin_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(masq_win), "delete_event",
			GTK_SIGNAL_FUNC(mwin_destroy), NULL);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(masq_win), vbox);
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 1);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_widget_show(hbox);

	/*
	label = gfcc_label_new(hbox, "tcp: ");
	sprintf(buf, "%d", timeouts.tcp_timeout);
	mtcp = gfcc_entry_new(hbox, 0, 55, -1, buf);

	label = gfcc_label_new(hbox, "tcpfin: ");
	sprintf(buf, "%d", timeouts.tcp_fin_timeout);
	mtcpfin = gfcc_entry_new(hbox, 0, 55, -1, buf);

	label = gfcc_label_new(hbox, "udp: ");
	sprintf(buf, "%d", timeouts.udp_timeout);
	mudp = gfcc_entry_new(hbox, 0, 55, -1, buf);
	*/

	button = gtk_button_new_with_label(" Close ");
	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(mwin_destroy), NULL);
	gtk_widget_show(button);

	button = gtk_check_button_new_with_label(" Pause ");
	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "toggled",
			GTK_SIGNAL_FUNC(mlist_pause), NULL);
	gtk_widget_show(button);

	/*
	button = gtk_button_new_with_label(" Set timeout ");
	gtk_box_pack_end(GTK_BOX(hbox), button, FALSE, FALSE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_masq_timeout), NULL);
	gtk_widget_show(button);
	*/

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(
			GTK_SCROLLED_WINDOW(scrolled_window),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
	gtk_widget_show(scrolled_window);
	
	mlist = gtk_clist_new_with_titles(MCOLS, titles);
	gtk_container_add(GTK_CONTAINER(scrolled_window), mlist);
	gtk_widget_show(mlist);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 0, 40);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 1, 50);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 2, 100);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 3, 100);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 4, 50);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 5, 50);
	gtk_clist_set_column_width(GTK_CLIST(mlist), 6, 50);
	
	gtk_widget_show(masq_win);
	get_masq_list_data(NULL);
}

static gint get_masq_list_data(gpointer data)
{
	FILE *fp;
	gchar buf[256], protocol[64];
	__u32 temp[3];
	gint nread, i;
	unsigned long minutes, seconds, sec100s;
	unsigned long expires;
	unsigned short sport, dport, mport;
	short delta, pdelta;
	gchar *content[MCOLS];
	
	gtk_clist_freeze(GTK_CLIST(mlist));
	if(tag)
		gtk_timeout_remove(tag);
	gtk_clist_clear(GTK_CLIST(mlist));

	if((fp = fopen("/proc/net/ip_masquerade", "r")) == NULL) {
		dialog_window("Cannot open file /proc/net/ip_masquerade", NULL);
		return -1;
	}
	if(fgets(buf, sizeof(buf), fp) == NULL) {
		dialog_window(
			"Unexpected input from /proc/net/ip_masquerade", NULL);
		fclose(fp);
		return -1;
	}
	while(1) {
		nread = fscanf(fp, " %s %lX:%hX %lX:%hX %hX %lX %hd %hd %lu",
				buf, (unsigned long *)&temp[0],
				&sport, (unsigned long *)&temp[1],
				&dport, &mport, (unsigned long *)&temp[2],
				&delta, &pdelta, &expires);
		if(nread == EOF)
			break;
		if(nread != 10) {
			dialog_window("Unexpected input data", NULL);
			break;
		}
		if(!strcmp(buf, "TCP"))
			strcpy(protocol, "tcp");
		else if(!strcmp(buf, "UDP"))
			strcpy(protocol, "udp");
		else
			strcpy(protocol, "all");

		content[0] = content_new(buf);

		sec100s = ((expires % HZ) * 100) / HZ;
		seconds = (expires / HZ) % 60;
		minutes = expires / (60 * HZ);
		sprintf(buf, "%02ld:%02ld.%02ld", minutes, seconds, sec100s);
		content[1] = content_new(buf);
		
		get_ipaddr(buf, temp[0], 0xffffffff);
		for(i=strlen(buf); i>=0; i--) {
			if(buf[i] == '/') {
				buf[i] = '\0';
				break;
			}
		}
		content[2] = content_new(buf);
		
		get_ipaddr(buf, temp[1], 0xffffffff);
		for(i=strlen(buf); i>=0; i--) {
			if(buf[i] == '/') {
				buf[i] = '\0';
				break;
			}
		}
		content[3] = content_new(buf);
		
		sprintf(buf, "%u", sport);
		content[4] = content_new(buf);
		sprintf(buf, "%u", mport);
		content[5] = content_new(buf);
		port_itos(buf, dport, protocol);
		content[6] = content_new(buf);
		
		gtk_clist_append(GTK_CLIST(mlist), content);
		
		for(i=0; i<MCOLS; i++)
			g_free(content[i]);
	}
	fclose(fp);

	gtk_clist_thaw(GTK_CLIST(mlist));
	tag = gtk_timeout_add(TIMEOUT, get_masq_list_data, NULL);
	
	return 0;
}

void get_masq_timeout(FILE *fp)
{
	gchar buf[128];
	/* int sockfd, optlen = sizeof(timeouts)*/;

	memset(&timeouts, 0x00, sizeof(timeouts));
	if(!fp) {
	/* Somebody let me know how to get masq timeout values from socket.

		if((sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1) {
			printf("Getting MASQ timeouts failed\n");
			return;
		}
		if(getsockopt(sockfd, IPPROTO_IP, IP_FW_MASQ_TIMEOUTS,
				(char *)&timeouts, &optlen) != 0) {
		    printf("%d\n", errno);
			printf("Getting MASQ timeouts failed\n");
			return;
		}
		close(sockfd);
	*/

		return;
	}

	while(fgets(buf, sizeof(buf), fp)) {
		if(buf[0] == '#' || buf[0] == '\n')
			continue;
		if(buf[0] == '*')
			break;
		sscanf(buf, "%d %d %d", &timeouts.tcp_timeout,
			&timeouts.tcp_fin_timeout, &timeouts.tcp_timeout);
	}
	return;
}

gint set_masq_timeout(GtkWidget *widget, gpointer data)
{
	gint sockfd;

	if(check_timeout() < 0)
		return 0;

	if((sockfd = socket(AF_INET, SOCK_RAW, IPPROTO_RAW)) == -1) {
		dialog_window("Setting MASQ timeouts failed", NULL);
		return 0;
	}
	if((sockfd = setsockopt(sockfd, IPPROTO_IP, IP_FW_MASQ_TIMEOUTS,
			(char *)&timeouts, sizeof(timeouts))) != 0) {
		dialog_window("Setting MASQ timeouts failed", NULL);
		return 0;
	}
	close(sockfd);

	return 1;
}

gint save_masq_timeout(FILE *fp)
{
	if(check_timeout() < 0)
		return 0;

	fprintf(fp, "*\n");
	fprintf(fp, "%d %d %d\n", timeouts.tcp_timeout,
			timeouts.tcp_fin_timeout, timeouts.udp_timeout);
	return 1;
}

static gint check_timeout()
{
	gchar *text;
	gint temp;

	if(mtcp) {
		text = gtk_entry_get_text(GTK_ENTRY(mtcp));
		temp = atoi(text);
	} else
		temp = 0;
	if(temp < 0 || temp > INT_MAX) {
		dialog_window("tcp timeout value out of bound", NULL);
		return -1;
	}
	timeouts.tcp_timeout = temp;

	if(mtcpfin) {
		text = gtk_entry_get_text(GTK_ENTRY(mtcpfin));
		temp = atoi(text);
	} else
		temp = 0;
	if(temp < 0 || temp > INT_MAX) {
		dialog_window("tcpfin timeout value out of bound", NULL);
		return -1;
	}
	timeouts.tcp_fin_timeout = temp;

	if(mudp) {
		text = gtk_entry_get_text(GTK_ENTRY(mudp));
		temp = atoi(text);
	} else
		temp = 0;
	if(temp < 0 || temp > INT_MAX) {
		dialog_window("udp timeout value out of bound", NULL);
		return -1;
	}
	timeouts.udp_timeout = temp;

	return 0;
}

static void mlist_pause(GtkWidget *widget, gpointer data)
{
	if(GTK_TOGGLE_BUTTON(widget)->active)
		gtk_timeout_remove(tag);
	else
		tag = gtk_timeout_add(TIMEOUT, get_masq_list_data, NULL);
}
