/* gnome-napster, a GNOME Napster client.
 * Copyright (C) 1999 Evan Martin <eeyem@u.washington.edu>
 */
#include <gnome.h>
#include "ui.h"
#include "lnap.h"
#include "gconfig.h"
#include "util.h"

static GtkWidget *euser, *epass, *cautoretry, *retrydelay;
static GtkWidget *edlpath, *eulpath, *emp3path;
static GtkWidget *eredir, *port, *conntype;
static GtkWidget *maxgdl, *maxgul, *maxuul;
static GtkWidget *dispdepth;

static void property_apply(GnomePropertyBox *box, int page) {
	if (page != -1) return;

	/* login */
	gnome_config_set_string(CONFIG_PREFIX "/Login/UserName", 
			gtk_entry_get_text(GTK_ENTRY(euser)));
	gnome_config_private_set_string(CONFIG_PREFIX "/Login/Password", 
			gtk_entry_get_text(GTK_ENTRY(epass)));
	gnome_config_set_int(CONFIG_PREFIX "/Login/DataPort",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(port)));
	gnome_config_set_int(CONFIG_PREFIX "/Login/ConnectionType",
			nap_str_to_conntype(
				gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(conntype)->entry))));
	gnome_config_set_int(CONFIG_PREFIX "/Login/RetryDelay",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(retrydelay)));
	gnome_config_set_bool(CONFIG_PREFIX "/Login/AutoRetry",
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cautoretry)));
	/* paths */
	gnome_config_set_string(CONFIG_PREFIX "/Paths/Upload",
			gtk_entry_get_text(GTK_ENTRY(gnome_file_entry_gtk_entry(
							GNOME_FILE_ENTRY(eulpath)))));
	gnome_config_set_string(CONFIG_PREFIX "/Paths/Download",
			gtk_entry_get_text(GTK_ENTRY(gnome_file_entry_gtk_entry(
							GNOME_FILE_ENTRY(edlpath)))));
	gnome_config_set_string(CONFIG_PREFIX "/Paths/MP3",
			gtk_entry_get_text(GTK_ENTRY(gnome_file_entry_gtk_entry(
							GNOME_FILE_ENTRY(emp3path)))));
	/* network */
	gnome_config_set_int(CONFIG_PREFIX "/Network/MaxGlobalDL",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(maxgdl)));
	gnome_config_set_int(CONFIG_PREFIX "/Network/MaxUserUL",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(maxuul)));
	gnome_config_set_int(CONFIG_PREFIX "/Network/MaxGlobalUL",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(maxgul)));
	gnome_config_set_string(CONFIG_PREFIX "/Network/Redirector",
			gtk_entry_get_text(GTK_ENTRY(eredir)));
	/* interface */
	gnome_config_set_int(CONFIG_PREFIX "/Interface/PathDepth",
		gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(dispdepth)));

	gnome_config_sync();
}

static GtkWidget *create_login(GtkWidget *pb) {
	GtkWidget *vbox, *hbox;
	gchar *val;
	GtkObject *adj;
	GList *list; int i;

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
		euser = gtk_entry_new();
		if ((val = gnome_config_get_string(CONFIG_PREFIX 
						"/Login/UserName")) != NULL) {
			gtk_entry_set_text(GTK_ENTRY(euser), val);
			g_free(val);
		}
		gtk_signal_connect_object(GTK_OBJECT(euser), "changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
	gtk_box_pack_start(GTK_BOX(vbox), 
			hbox_new_with_label("Default User Name:", euser, FALSE),
			FALSE, FALSE, 0);
		epass = gtk_entry_new();
		if ((val = gnome_config_private_get_string(CONFIG_PREFIX 
						"/Login/Password")) != NULL) {
			gtk_entry_set_text(GTK_ENTRY(epass), val);
			g_free(val);
		}
		gtk_entry_set_visibility(GTK_ENTRY(epass), FALSE);
		gtk_signal_connect_object(GTK_OBJECT(epass), "changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
	gtk_box_pack_start(GTK_BOX(vbox), 
			hbox_new_with_label("Default Password:", epass, FALSE),
			FALSE, FALSE, 0);

		eredir = gtk_entry_new();
		if ((val = gnome_config_get_string(CONFIG_PREFIX 
						"/Network/Redirector=server.napster.com")) != NULL) {
			gtk_entry_set_text(GTK_ENTRY(eredir), val);
			g_free(val);
		}
		gtk_signal_connect_object(GTK_OBJECT(eredir), "changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
	gtk_box_pack_start(GTK_BOX(vbox), 
			hbox_new_with_label("Redirector:", eredir, FALSE),
			FALSE, FALSE, 0);

		hbox = gtk_hbox_new(FALSE, 10);

			adj = gtk_adjustment_new(gnome_config_get_int(CONFIG_PREFIX
						"/Login/DataPort=6699"), 1024, 65530, 1, 10, 0);
			port = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
			/* FIXME need to increase max length; is this the right way to do it? */
			gtk_entry_set_max_length(GTK_ENTRY(port), 5);
			gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(port), TRUE);
			gtk_signal_connect_object(GTK_OBJECT(adj), "value-changed",
					gnome_property_box_changed, GTK_OBJECT(pb));
		gtk_box_pack_start(GTK_BOX(hbox), 
				hbox_new_with_label("Data Port:", port, FALSE),
				FALSE, FALSE, 0);

			conntype = gtk_combo_new();
			list = NULL;
			for (i = 0; i < NAP_CONNTYPE_COUNT; i++) 
				list = g_list_append(list, nap_conntypes[i]);
			gtk_combo_set_popdown_strings(GTK_COMBO(conntype), list);
			g_list_free(list);
			gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(conntype)->entry), FALSE);
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(conntype)->entry), 
					nap_conntypes[gnome_config_get_int(CONFIG_PREFIX
						"/Login/ConnectionType=0")]);
			gtk_signal_connect_object(GTK_OBJECT(GTK_COMBO(conntype)->entry), "changed",
					gnome_property_box_changed, GTK_OBJECT(pb));
		gtk_box_pack_start(GTK_BOX(hbox), 
				hbox_new_with_label("Connection type:", conntype, FALSE),
				TRUE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	
		hbox = gtk_hbox_new(FALSE, 0);
			cautoretry = gtk_check_button_new_with_label("Retry login until successful:");
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cautoretry), 
					gnome_config_get_bool(CONFIG_PREFIX "/Login/AutoRetry=false"));
			gtk_signal_connect_object(GTK_OBJECT(cautoretry), "toggled",
					gnome_property_box_changed, GTK_OBJECT(pb));
		gtk_box_pack_start(GTK_BOX(hbox), cautoretry, FALSE, FALSE, 0);
			adj = gtk_adjustment_new(gnome_config_get_int(CONFIG_PREFIX
					"/Login/RetryDelay=30"), 0, 6000, 1, 10, 0);
			retrydelay = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
			gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(retrydelay), TRUE);
			gtk_signal_connect_object(GTK_OBJECT(adj), "value-changed",
					gnome_property_box_changed, GTK_OBJECT(pb));
		gtk_box_pack_start(GTK_BOX(hbox), retrydelay, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new("seconds between attempts"),
				FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	return vbox;
}

static GtkWidget *create_paths(GtkWidget *pb) {
	GtkWidget *vbox, *hb;
	gchar *val;

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

		edlpath = gnome_file_entry_new(0, "Select download path");
		gnome_file_entry_set_directory(GNOME_FILE_ENTRY(edlpath), TRUE);
		if ((val = gnome_config_get_string(CONFIG_PREFIX 
						"/Paths/Download")) != NULL) {
			gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(
						GNOME_FILE_ENTRY(edlpath))), val);
			g_free(val);
		}
		gtk_signal_connect_object(GTK_OBJECT(gnome_file_entry_gtk_entry(
						GNOME_FILE_ENTRY(edlpath))), "changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
	gtk_box_pack_start(GTK_BOX(vbox), 
			hbox_new_with_label("Download Path:", edlpath, TRUE),
			FALSE, FALSE, 0);

		eulpath = gnome_file_entry_new(0, "Select upload path");
		gnome_file_entry_set_directory(GNOME_FILE_ENTRY(eulpath), TRUE);
		if ((val = gnome_config_get_string(CONFIG_PREFIX 
						"/Paths/Upload")) != NULL) {
			gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(
						GNOME_FILE_ENTRY(eulpath))), val);
			g_free(val);
		}
		gtk_signal_connect_object(GTK_OBJECT(gnome_file_entry_gtk_entry(
						GNOME_FILE_ENTRY(eulpath))), "changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
		hb = hbox_new_with_label("Upload Path:", eulpath, TRUE);
		gtk_widget_set_sensitive(hb, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), hb,
			FALSE, FALSE, 0);

		emp3path = gnome_file_entry_new(0, "Select MP3 path");
		gnome_file_entry_set_directory(GNOME_FILE_ENTRY(emp3path), TRUE);
		if ((val = gnome_config_get_string(CONFIG_PREFIX 
						"/Paths/MP3")) != NULL) {
			gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(
						GNOME_FILE_ENTRY(emp3path))), val);
			g_free(val);
		}
		gtk_signal_connect_object(GTK_OBJECT(gnome_file_entry_gtk_entry(
						GNOME_FILE_ENTRY(emp3path))), "changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
		hb = hbox_new_with_label("MP3 Path:", emp3path, TRUE);
		gtk_widget_set_sensitive(hb, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), hb,
			FALSE, FALSE, 0);
	return vbox;
}

static GtkWidget *create_network(GtkWidget *pb) {
	GtkWidget *vbox, *hb;
	GtkObject *adj;

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);

		adj = gtk_adjustment_new(gnome_config_get_int(CONFIG_PREFIX
					"/Network/MaxGlobalDL=1"), 0, 100, 1, 10, 0);
		maxgdl = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(maxgdl), TRUE);
		gtk_signal_connect_object(GTK_OBJECT(adj), "value-changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
		hb = hbox_new_with_label("Maximum simultaneous downloads:", maxgdl, FALSE);
		gtk_widget_set_sensitive(hb, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), hb,
		FALSE, FALSE, 0);

		adj = gtk_adjustment_new(gnome_config_get_int(CONFIG_PREFIX
					"/Network/MaxUserUL=1"), 0, 100, 1, 10, 0);
		maxuul = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(maxuul), TRUE);
		gtk_signal_connect_object(GTK_OBJECT(adj), "value-changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
		hb = hbox_new_with_label("Maximum per-user uploads:", maxuul, FALSE);
		gtk_widget_set_sensitive(hb, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), hb,
			FALSE, FALSE, 0);

		adj = gtk_adjustment_new(gnome_config_get_int(CONFIG_PREFIX
					"/Network/MaxGlobalUL=1"), 0, 100, 1, 10, 0);
		maxgul = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(maxgul), TRUE);
		gtk_signal_connect_object(GTK_OBJECT(adj), "value-changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
		hb = hbox_new_with_label("Maximum simultaneous uploads:", maxgul, FALSE);
		gtk_widget_set_sensitive(hb, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), hb,
			FALSE, FALSE, 0);
	return vbox;
}

static GtkWidget *create_interface(GtkWidget *pb) {
	GtkWidget *vbox;
	GtkObject *adj;

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
		adj = gtk_adjustment_new(gnome_config_get_int(CONFIG_PREFIX
					"/Interface/PathDepth=1"), 0, 100, 1, 5, 0);
		dispdepth = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(dispdepth), TRUE);
		gtk_signal_connect_object(GTK_OBJECT(adj), "value-changed",
				gnome_property_box_changed, GTK_OBJECT(pb));
	gtk_box_pack_start(GTK_BOX(vbox), 
			hbox_new_with_label("Default path depth:", dispdepth, FALSE), 
			FALSE, FALSE, 0);
	return vbox;
}

void gconfig_dlg_run(void) {
	GtkWidget *pb;

	pb = gnome_property_box_new();
	gtk_window_set_title(GTK_WINDOW(pb), "Preferences");
	gnome_dialog_set_parent(GNOME_DIALOG(pb), GTK_WINDOW(app));
	gtk_signal_connect(GTK_OBJECT(pb), "apply",
			GTK_SIGNAL_FUNC(property_apply), NULL);
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pb), create_login(pb), 
		gtk_label_new("Login"));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pb), create_paths(pb), 
		gtk_label_new("Paths"));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pb), create_network(pb), 
		gtk_label_new("Network"));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pb), create_interface(pb), 
		gtk_label_new("Interface"));

	gtk_widget_show_all(pb);
	gnome_dialog_run(GNOME_DIALOG(pb));
}

#if 0
/* I think I'm just going to use a plain "history" box. */
static void free_server_list() {
	GList *li;
	if (config.serverlist == NULL) return;
	li = config.serverlist;
	while (li != NULL) {
		g_free(li->data);
		li = li->next;
	}
	g_list_free(config.serverlist);
	config.serverlist = NULL;
}
	
void gconfig_serverlist_read(void) {
	GList *list = NULL;
	gchar *key, *data;
	gpointer iter;

	iter = gnome_config_init_iterator(CONFIG_PREFIX "/ServerList");
	if (iter == NULL) return;

	while ((iter = gnome_config_iterator_next(iter, &key, &data)) != NULL) {
		list = g_list_append(list, data);
		g_free(key);
	}
	config.serverlist = list;
}

void gconfig_serverlist_write(void) {
	gchar key[100];
	GList *li;
	int i = 0;

	li = config.serverlist;
	while (li != NULL) {
		g_snprintf(key, 100, CONFIG_PREFIX "/ServerList/%d", i++);
		gnome_config_set_string(key, li->data);
		li = li->next;
	}
	gnome_config_sync();
}

void gconfig_serverlist_append(gchar *server) {
	GList *li = config.serverlist;
	/* make sure it isn't a duplicate */
	while (li != NULL) {
		if (g_strcasecmp(li->data, server) == 0) return;
		li = li->next;
	}

	config.serverlist = g_list_append(config.serverlist, server);
}
#endif


