/********************************
 Create a new chat dialog window
 (c) 1999 Jeremy Wise
 GnomeICU
*********************************/

/*** GnomeICU header files ***/
#include "common.h"

typedef struct
{
	gpointer data;
	int i;
} dataandint;

/*** Local function declarations ***/
static void SetForeground( GtkWidget *widget, dataandint *data );
static void SetBackground( GtkWidget *widget, dataandint *data );
static void CreateSetFGWindow( GtkWidget *widget, gpointer data );
static void CreateSetBGWindow( GtkWidget *widget, gpointer data );
static void chat_focus_in( gpointer data );
static void chat_focus_out( gpointer data );
static void chat_focus_changed( gpointer data, gboolean have_focus );
static void changedShouldSendFocus (CONTACT_PTR user);
static gboolean shouldSendFocus (CONTACT_PTR user);
static void sendFocus (CONTACT_PTR user);

/*** Global functions ***/
GtkWidget *ChatWindowNew( GSList *contact, int sock )
{

  GtkWidget *vbox1;
  GtkWidget *chat_toolbar;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *B_save_chat;
  GtkWidget *B_set_fg;
  GtkWidget *B_set_bg;
  GtkWidget *B_toggle_sound;
  GtkWidget *B_toggle_focus;
  GtkWidget *B_close_chat;
  GtkWidget *vpaned;
  GtkWidget *frame1;
  GtkWidget *scrolledwindow1;
  GtkWidget *remote_text;
  GtkWidget *frame2;
  GtkWidget *scrolledwindow2;
  GtkWidget *local_text;

	GtkTooltips *tooltip;
	GtkStyle *style;
	gchar *wintitle;

#ifdef TRACE_FUNCTION
	g_print( "ChatWindowNew\n" );
#endif

	((CONTACT_PTR)contact->data)->chat_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	wintitle = g_strdup_printf( _("GnomeICU: %s, %s"), ( strlen( our_info->nick ) ? our_info->nick : _("User") ), ((CONTACT_PTR)contact->data)->nick );
	gtk_window_set_title( GTK_WINDOW( ((CONTACT_PTR)contact->data)->chat_window ), wintitle );
	g_free( wintitle );
	gtk_container_border_width( GTK_CONTAINER( ((CONTACT_PTR)contact->data)->chat_window ), 0 );
	gtk_window_set_default_size( GTK_WINDOW( ((CONTACT_PTR)contact->data)->chat_window ), 450, 400 );
	gtk_widget_realize( ((CONTACT_PTR)contact->data)->chat_window );

	gtk_window_set_policy( GTK_WINDOW( ((CONTACT_PTR)contact->data)->chat_window ), TRUE, TRUE, FALSE );

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (((CONTACT_PTR)contact->data)->chat_window), vbox1);

  chat_toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_ref (chat_toolbar);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "chat_toolbar", chat_toolbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (chat_toolbar);
  gtk_box_pack_start (GTK_BOX (vbox1), chat_toolbar, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (chat_toolbar), 5);
  gtk_toolbar_set_space_size (GTK_TOOLBAR (chat_toolbar), 20);
  gtk_toolbar_set_space_style (GTK_TOOLBAR (chat_toolbar), GTK_TOOLBAR_SPACE_LINE);
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (chat_toolbar), GTK_RELIEF_NONE);

  tmp_toolbar_icon = gnome_stock_pixmap_widget (((CONTACT_PTR)contact->data)->chat_window, GNOME_STOCK_PIXMAP_SAVE_AS);
  B_save_chat = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Save"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (B_save_chat);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "B_save_chat", B_save_chat,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (B_save_chat);

	tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tooltip, B_save_chat, _("Save Chat"), NULL );

  tmp_toolbar_icon = gnome_stock_pixmap_widget (((CONTACT_PTR)contact->data)->chat_window, GNOME_STOCK_PIXMAP_COLORSELECTOR);
  B_set_fg = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Foreground"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (B_set_fg);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "B_set_fg", B_set_fg,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (B_set_fg);

	tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tooltip, B_set_fg, _("Set Foreground Color"), NULL );

  tmp_toolbar_icon = gnome_stock_pixmap_widget (((CONTACT_PTR)contact->data)->chat_window, GNOME_STOCK_PIXMAP_COLORSELECTOR);
  B_set_bg = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Background"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (B_set_bg);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "B_set_bg", B_set_bg,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (B_set_bg);

	tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tooltip, B_set_bg, _("Set Background Color"), NULL );

  tmp_toolbar_icon = gnome_stock_pixmap_widget (((CONTACT_PTR)contact->data)->chat_window, GNOME_STOCK_PIXMAP_VOLUME);
  B_toggle_sound = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("Sound"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (B_toggle_sound);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "B_toggle_sound", B_toggle_sound,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (B_toggle_sound);

	tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tooltip, B_toggle_sound, _("Enable/Disable Sound"), NULL );

  tmp_toolbar_icon = gnome_stock_pixmap_widget (((CONTACT_PTR)contact->data)->chat_window, GNOME_STOCK_PIXMAP_REDO);
  B_toggle_focus = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
                                GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                NULL,
                                _("Send Focus"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (B_toggle_focus);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "B_toggle_focus", B_toggle_focus,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (B_toggle_focus);
	gtk_signal_connect_object (GTK_OBJECT (B_toggle_focus), "toggled",
				   GTK_SIGNAL_FUNC (changedShouldSendFocus),
				   (gpointer) contact->data);
	((CONTACT_PTR)contact->data)->should_send_focus = B_toggle_focus;

	tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tooltip, B_toggle_focus, _("Send \"User is Away\" Messages"), NULL );

  tmp_toolbar_icon = gnome_stock_pixmap_widget (((CONTACT_PTR)contact->data)->chat_window, GNOME_STOCK_PIXMAP_CLOSE);
  B_close_chat = gtk_toolbar_append_element (GTK_TOOLBAR (chat_toolbar),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Close"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_widget_ref (B_close_chat);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "B_close_chat", B_close_chat,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (B_close_chat);

	tooltip = gtk_tooltips_new();
	gtk_tooltips_set_tip( tooltip, B_close_chat, _("Close Chat"), NULL );

  vpaned = gtk_vpaned_new ();
  gtk_widget_show (vpaned);
  gtk_box_pack_start (GTK_BOX (vbox1), vpaned, TRUE, TRUE, 0);

  frame1 = gtk_frame_new ( ((CONTACT_PTR)contact->data)->nick );
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_paned_pack1 (GTK_PANED (vpaned), frame1, TRUE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  remote_text = icu_chat_new (NULL, NULL);
  gtk_widget_ref (remote_text);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "remote_text", remote_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (remote_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), remote_text);
	icu_chat_set_word_wrap( ICU_CHAT( remote_text ), TRUE );

  frame2 = gtk_frame_new ( strlen( our_info->nick ) ? our_info->nick : _("User") );
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_paned_pack2 (GTK_PANED (vpaned), frame2, TRUE, TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow2);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "scrolledwindow2", scrolledwindow2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow2);
  gtk_container_add (GTK_CONTAINER (frame2), scrolledwindow2);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  local_text = icu_chat_new (NULL, NULL);
  gtk_widget_ref (local_text);
  gtk_object_set_data_full (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "local_text", local_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (local_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), local_text);
  icu_chat_set_editable ( ICU_CHAT (local_text), TRUE);
	icu_chat_set_word_wrap( ICU_CHAT( local_text ), TRUE );

  gtk_signal_connect_object (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "focus_in_event",
                      GTK_SIGNAL_FUNC (chat_focus_in),
                      GINT_TO_POINTER( ((CONTACT_PTR)contact->data)->uin ));
  gtk_signal_connect_object (GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window), "focus_out_event",
                      GTK_SIGNAL_FUNC (chat_focus_out),
                      GINT_TO_POINTER( ((CONTACT_PTR)contact->data)->uin ));
  gtk_signal_connect (GTK_OBJECT (B_set_fg), "clicked",
                      GTK_SIGNAL_FUNC (CreateSetFGWindow),
                      GINT_TO_POINTER( sock ));
  gtk_signal_connect (GTK_OBJECT (B_set_bg), "clicked",
                      GTK_SIGNAL_FUNC (CreateSetBGWindow),
                      GINT_TO_POINTER( sock ));
	gtk_signal_connect( GTK_OBJECT( B_save_chat ), "clicked",
	                    GTK_SIGNAL_FUNC( chat_save ),
	                    GINT_TO_POINTER( ((CONTACT_PTR)contact->data)->uin ) );
  gtk_signal_connect (GTK_OBJECT (B_close_chat), "clicked",
                      GTK_SIGNAL_FUNC (TCPTerminateChat),
                      GINT_TO_POINTER( sock ));
  gtk_signal_connect_object (GTK_OBJECT (B_close_chat), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (((CONTACT_PTR)contact->data)->chat_window));
  gtk_signal_connect (GTK_OBJECT (local_text), "key_press_event",
                      GTK_SIGNAL_FUNC (TCPChatSend),
                      GINT_TO_POINTER( sock ));
  gtk_signal_connect (GTK_OBJECT (local_text), "selection_received",
                      GTK_SIGNAL_FUNC (TCPChatSendSel),
                      GINT_TO_POINTER( sock ));

	style = gtk_style_new();
	style->font = gdk_font_load( ChatFontString );
	if( style->font == NULL )
		style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
	gtk_widget_set_style( remote_text, style );
	gtk_widget_set_style( local_text, style );
	gdk_font_unref( style->font );

	gtk_widget_show( ((CONTACT_PTR)contact->data)->chat_window );

	((CONTACT_PTR)contact->data)->chat_local_text = local_text;
	((CONTACT_PTR)contact->data)->chat_remote_text = remote_text;

	return remote_text;
}

/*** Local functions ***/
void SetForeground( GtkWidget *widget, dataandint *data )
{
	static GtkStyle *style = NULL;
	GdkColor *foreground, *background;

	GtkColorSelection *colorsel;
	gdouble color[4];
	BYTE rgb[5];

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "SetForeground\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( data->i == ((CONTACT_PTR)contact->data)->chat_sok )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	colorsel = GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( data->data )->colorsel );
	gtk_color_selection_get_color( colorsel, color );

	rgb[0] = 0x00;
	chat_fg_red = rgb[1] = (BYTE)( 255.0F * color[0] );
	chat_fg_green = rgb[2] = (BYTE)( 255.0F * color[1] );
	chat_fg_blue = rgb[3] = (BYTE)( 255.0F * color[2] );
	rgb[4] = 0x00;

	foreground = g_new0( GdkColor, 1 );
	background = g_new0( GdkColor, 1 );

	foreground->red = 256 * chat_fg_red;
	foreground->green = 256 * chat_fg_green;
	foreground->blue = 256 * chat_fg_blue;
	foreground->pixel = (gulong)(
	                    chat_fg_red * 65536 +
	                    chat_fg_green * 256 +
	                    chat_fg_blue );

	background->red = 256 * chat_bg_red;
	background->green = 256 * chat_bg_green;
	background->blue = 256 * chat_bg_blue;
	background->pixel = (gulong)(
	                    chat_bg_red * 65536 +
	                    chat_bg_green * 256 +
	                    chat_bg_blue );

	gdk_color_alloc( gtk_widget_get_colormap( ((CONTACT_PTR)contact->data)->chat_local_text ), foreground );
	gdk_color_alloc( gtk_widget_get_colormap( ((CONTACT_PTR)contact->data)->chat_local_text ), background );

	if( style != NULL )
		gtk_style_unref( style );

	style = gtk_style_new();
	style->font = gdk_font_load( ChatFontString );
	if( style->font == NULL )
		style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
	memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

	gtk_widget_set_style( ((CONTACT_PTR)contact->data)->chat_local_text, style );
/*	gdk_font_unref( style->font );*/
	
	write( data->i, rgb, 5 );
}

void SetBackground( GtkWidget *widget, dataandint *data )
{
	static GtkStyle *style = NULL;
	GdkColor *foreground, *background;

	GtkColorSelection *colorsel;
	gdouble color[4];
	BYTE rgb[5];

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "SetBackground\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( data->i == ((CONTACT_PTR)contact->data)->chat_sok )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	colorsel = GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( data->data )->colorsel );
	gtk_color_selection_get_color( colorsel, color );

	rgb[0] = 0x01;
	chat_bg_red = rgb[1] = (BYTE)( 255.0F * color[0] );
	chat_bg_green = rgb[2] = (BYTE)( 255.0F * color[1] );
	chat_bg_blue = rgb[3] = (BYTE)( 255.0F * color[2] );
	rgb[4] = 0x00;

	foreground = g_new0( GdkColor, 1 );
	background = g_new0( GdkColor, 1 );

	foreground->red = 256 * chat_fg_red;
	foreground->green = 256 * chat_fg_green;
	foreground->blue = 256 * chat_fg_blue;
	foreground->pixel = (gulong)(
	                    chat_fg_red * 65536 +
	                    chat_fg_green * 256 +
	                    chat_fg_blue );

	background->red = 256 * chat_bg_red;
	background->green = 256 * chat_bg_green;
	background->blue = 256 * chat_bg_blue;
	background->pixel = (gulong)(
	                    chat_bg_red * 65536 +
	                    chat_bg_green * 256 +
	                    chat_bg_blue );

	gdk_color_alloc( gtk_widget_get_colormap( ((CONTACT_PTR)contact->data)->chat_local_text ), foreground );
	gdk_color_alloc( gtk_widget_get_colormap( ((CONTACT_PTR)contact->data)->chat_local_text ), background );

	if( style != NULL )
		gtk_style_unref( style );

	style = gtk_style_new();
	style->font = gdk_font_load( ChatFontString );
	if( style->font == NULL )
		style->font = gdk_font_load( _("-adobe-courier-medium-r-normal-*-*-140-*-*-m-*-iso8859-1") );
	memcpy( &style->fg[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->text[ GTK_STATE_NORMAL ], foreground, sizeof( GdkColor ) );
	memcpy( &style->base[ GTK_STATE_NORMAL ], background, sizeof( GdkColor ) );

	gtk_widget_set_style( ((CONTACT_PTR)contact->data)->chat_local_text, style );
/*	gdk_font_unref( style->font );*/

	write( ((CONTACT_PTR)contact->data)->chat_sok, rgb, 5 );
}

void CreateSetFGWindow( GtkWidget *widget, gpointer data )
{
	dataandint *pass_data = g_new0( dataandint, 1 );
	GtkWidget *window;
	gdouble color[4];
	static int first = FALSE;

	window = gtk_color_selection_dialog_new( _("Set Foreground Color") );

#ifdef TRACE_FUNCTION
	g_print( "CreateSetFGWindow\n" );
#endif

	if( first )
	{
		color[0] = color[1] = color[2] = color[3] = 0;
		first = FALSE;
	}
	else
	{
		color[0] = 256 * chat_fg_red;
		color[1] = 256 * chat_fg_green;
		color[2] = 256 * chat_fg_blue;  
		color[3] = (gulong)(
		               chat_fg_red * 65536 +
		               chat_fg_green * 256 +
		               chat_fg_blue );
	}

	pass_data->i = GPOINTER_TO_INT( data );
	pass_data->data = window;

	gtk_color_selection_set_color(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	color );

	gtk_color_selection_set_opacity(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	TRUE );
	
	gtk_color_selection_set_update_policy(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	GTK_UPDATE_CONTINUOUS );
	
	gtk_signal_connect(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( SetForeground ), pass_data );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->cancel_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_widget_show( window );
}

void CreateSetBGWindow( GtkWidget *widget, gpointer data )
{
	dataandint *pass_data = g_new0( dataandint, 1 );
	GtkWidget *window;
	gdouble color[4];

	static int first = TRUE;

	window = gtk_color_selection_dialog_new( _("Set Background Color") );


#ifdef TRACE_FUNCTION
	g_print( "CreateSetBGWindow\n" );
#endif

	pass_data->i = GPOINTER_TO_INT( data );
	pass_data->data = window;

	if( first )
	{
		color[0] = color[1] = color[2] = color[3] = 0;
		first = FALSE;
	}
	else
	{
		color[0] = 256 * chat_bg_red;
		color[1] = 256 * chat_bg_green;
		color[2] = 256 * chat_bg_blue;  
		color[3] = (gulong)(
		               chat_bg_red * 65536 +
		               chat_bg_green * 256 +
		               chat_bg_blue );
	}

	gtk_color_selection_set_color(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	color );

	gtk_color_selection_set_opacity(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	TRUE );
	
	gtk_color_selection_set_update_policy(
	GTK_COLOR_SELECTION( GTK_COLOR_SELECTION_DIALOG( window )->colorsel ),
	GTK_UPDATE_CONTINUOUS );
	
	gtk_signal_connect(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( SetBackground ), pass_data );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->ok_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_signal_connect_object(
	GTK_OBJECT( GTK_COLOR_SELECTION_DIALOG( window )->cancel_button ),
	"clicked", GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( window ) );

	gtk_widget_show( window );
}

void chat_focus_in( gpointer data )
{
  chat_focus_changed(data, TRUE);
}

void chat_focus_out( gpointer data )
{
  chat_focus_changed(data, FALSE);
}

static void chat_focus_changed( gpointer data, gboolean have_focus ) {
	int uin;
	GSList *contact;
	
	uin = GPOINTER_TO_INT( data );
	contact = Contacts;

	while( contact != NULL )
	{
		if( ((CONTACT_PTR)contact->data)->uin == uin )
			break;
		contact = contact->next;
	}

	if( contact == NULL )
		return;

	((CONTACT_PTR)contact->data)->have_chat_focus = have_focus;
	if( ((CONTACT_PTR)contact->data)->chat_active ) {
		if (shouldSendFocus((CONTACT_PTR)contact->data)) {
			sendFocus( ((CONTACT_PTR)contact->data));
		}
	}
}

static void changedShouldSendFocus (CONTACT_PTR user)
{
	if (shouldSendFocus(user)) {
		sendFocus(user);
	}
}

static void sendFocus (CONTACT_PTR user)
{
	char byte;
	if (user->have_chat_focus) {
		byte = 0x03;
	} else {
		byte = 0x04;
	}
	write( user->chat_sok, &byte, 1 );
	user->reported_chat_focus = user->have_chat_focus;
}

static gboolean shouldSendFocus (CONTACT_PTR user) 
{
	return (user->have_chat_focus != user->reported_chat_focus) &&
		(GTK_TOGGLE_BUTTON (user->should_send_focus)->active);
}
