/*
 setup.c : GTK specific functions for plugin

    Copyright (C) 1999 Trever Adams

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include <irssi-plugin-gui.h>
#include "sound.h"

#define ENTRIES 4

static gchar *option_texts[] =
{
    "Directory Sounds are In:",
    "Path of MP3 player:",
    "Path of midi player:",
    "Path of default player:"
};

static gboolean sig_setup_apply(GtkWidget *dialog, PLUGIN_REC *plugin)
{
    PLUGIN_DATA *data = plugin->data;

    setup_write("plugin_"PLUGIN_NAME, plugin_sound_options);
    plugin_sound_get_setup(data);
    return TRUE;
}

static gboolean setup_dialog(GtkWidget *dialog)
{
int cur_entry;

    GtkWidget *table, *entry;

    table = gtk_table_new(3, 2, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 7);
    gtk_table_set_col_spacing(GTK_TABLE(table), 0, 5);

    for(cur_entry=0; cur_entry<ENTRIES; cur_entry++)
    {
        entry = gui_create_tablelabelentry(table, 0, cur_entry, option_texts[cur_entry],
                                           *((gchar **) plugin_sound_options[cur_entry].data));
        plugin_sound_options[cur_entry].widget = entry;
    }

    setup_finish_init(dialog, plugin_sound_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   table, gtk_label_new(PLUGIN_LONG_NAME));
    return TRUE;
}

static void plugin_setup(gpointer widget, PLUGIN_REC *plugin)
{
    static GtkWidget *dialog = NULL;

    setup("plugin "PLUGIN_NAME" setup", &dialog, plugin);
}

void plugin_sound_gtk_init(PLUGIN_REC *plugin)
{
    plugin_bind(plugin, "plugin "PLUGIN_NAME" setup apply", (SIGNAL_FUNC) sig_setup_apply, FALSE);
    plugin_bind(plugin, "plugin "PLUGIN_NAME" setup", (SIGNAL_FUNC) setup_dialog, FALSE);

    signal_emit("plugin add menu", 3, "Settings...", plugin_setup, plugin);
}
