/*

 channels-newdata.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

void newdata_label_colorify(GtkWidget *label, gint new_data)
{
    GtkStyle *style;

    g_return_if_fail(label != NULL);

    style = gtk_style_copy(label->style);
    gtk_style_ref(style);

    switch (new_data)
    {
        case NEWDATA_TEXT:
            style->fg[0] = THEME_GUI(current_theme)->colors[COLOR_NEWDATA];
            break;
        case NEWDATA_MSG:
            style->fg[0] = THEME_GUI(current_theme)->colors[COLOR_NEWDATA_MSG];
            break;
        case NEWDATA_MSG_FORYOU:
            style->fg[0] = THEME_GUI(current_theme)->colors[COLOR_NEWDATA_MSG_FORYOU];
            break;
        default:
            style->fg[0] = THEME_GUI(current_theme)->colors[BLACK];
    }

    gtk_widget_set_style(label, style);
    gtk_style_unref(style);
}

static gboolean sig_hilight_channel(CHANNEL_REC *channel)
{
    if (CHANNEL_GUI(channel)->autoraise)
    {
	/* raise the window */
	gdk_window_show(WINDOW_GUI(CHANNEL_PARENT(channel))->parent->window->window);

	/* select the right tab */
	signal_emit("gui window goto", 1,
		    GINT_TO_POINTER(g_list_index(windows, CHANNEL_PARENT(channel))));
    }

    return TRUE;
}

static gboolean sig_hilight_window(WINDOW_REC *window)
{
    GtkWidget *label;

    g_return_val_if_fail(window != NULL, FALSE);

    if (window->new_data != 0 && WINDOW_GUI(window) == WINDOW_GUI(CHANNEL_PARENT(cur_channel)))
    {
	signal_emit("window dehilight", 1, window);
	return TRUE;
    }

    label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(WINDOW_GUI(window)->parent->notebook),
                                       WINDOW_GUI(window)->window);
    newdata_label_colorify(label, window->new_data);

    return TRUE;
}

static gboolean sig_dehilight_window(WINDOW_REC *window)
{
    GList *tmp;

    g_return_val_if_fail(window != NULL, FALSE);

    for (tmp = WINDOW_GUI(window)->views; tmp != NULL; tmp = tmp->next)
    {
	WINDOW_VIEW_REC *rec = tmp->data;

	signal_emit("window dehilight", 1, rec->window);
    }
    return TRUE;
}

void channels_newdata_init(void)
{
    signal_add("gui hilight channel", (SIGNAL_FUNC) sig_hilight_channel);
    signal_add("gui hilight window", (SIGNAL_FUNC) sig_hilight_window);
    signal_add("window focused", (SIGNAL_FUNC) sig_dehilight_window);
}

void channels_newdata_deinit(void)
{
    signal_remove("gui hilight channel", (SIGNAL_FUNC) sig_hilight_channel);
    signal_remove("gui hilight window", (SIGNAL_FUNC) sig_hilight_window);
    signal_remove("window focused", (SIGNAL_FUNC) sig_dehilight_window);
}
