#ifndef __GUI_WINDOWS_H
#define __GUI_WINDOWS_H

#define WINDOW_GUI(a) ((GUI_WINDOW_REC *) ((WINDOW_VIEW_REC *) ((a)->gui_data))->gui)
#define WINDOW_VIEW(a) ((WINDOW_VIEW_REC *) ((a)->gui_data))

typedef struct _WINDOW_VIEW_REC WINDOW_VIEW_REC;

typedef struct
{
    MAIN_WINDOW_REC *parent;

    GtkWidget *window;
    GtkWidget *views_widget;

    GList *views;
    WINDOW_VIEW_REC *active;

    GtkWidget *channelwidget;
    GtkWidget *querywidget;
    GtkWidget *topicentry;
    GtkWidget *modebuttons[8];

    GtkWidget *limit_entry;
    GtkWidget *key_entry;

    /* nicklist */
    GtkWidget *nlist_label;
    GtkWidget *nlist_widget;
    GtkWidget *nicklist;

    GtkWidget *snapshot;
}
GUI_WINDOW_REC;

struct _WINDOW_VIEW_REC
{
    GUI_WINDOW_REC *gui;
    WINDOW_REC *window;

    GtkWidget *text;

    gboolean itext; /* text is a itext widget */
    gchar *pixmap; /* current background pixmap */

    GList *linepos;
    gint lastlinelen;

    gboolean freeze; /* text in freeze, waiting for "gui print text finished" */
    gboolean sb_down;
};

void gui_windows_init(void);
void gui_windows_deinit(void);

void gui_window_set_background(WINDOW_REC *window);
void gui_window_set_background_pixmap(WINDOW_REC *window, gchar *path);

#endif
