;;; liece-version.el --- Version information for Liece.
;; Copyright (C) 1998, 1999 Daiki Ueno

;; Author: Daiki Ueno <ueno@ueda.info.waseda.ac.jp>
;; Created: 1998-09-28
;; Revised: 1999-12-23
;; Keywords: IRC, liece

;; This file is part of Liece.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(eval-when-compile
  (setq byte-compile-warnings '(obsolete callargs)))

;;; @ version number constants
;;;
(defconst liece-user-interface-product
  ["liece" (1 4 1) "Punish My Heaven"]
  "Product name, version number and code name of this program.")

(eval-and-compile
  (defmacro liece-product-name (product)
    `(aref ,product 0))

  (defmacro liece-product-version (product)
    `(aref ,product 1))

  (defmacro liece-product-code-name (product)
    `(aref ,product 2)))

(defconst liece-version
  (let ((product liece-user-interface-product))
    (concat 
     (capitalize (liece-product-name product)) "/"
     (mapconcat #'int-to-string (liece-product-version product) ".")
     " (" (liece-product-code-name product) ")")))

(defconst liece-emacs-user-agent-value
  (if (featurep 'xemacs)
      (concat (cond
	       ((featurep 'utf-2000) 
		(concat "UTF-2000-MULE/" utf-2000-version))
	       ((featurep 'mule) "MULE"))
	      " XEmacs"
	      (if (string-match "^[0-9]+\\(\\.[0-9]+\\)" emacs-version)
		  (concat 
		   "/"
		   (substring emacs-version 0 (match-end 0))
		   (cond ((and (boundp 'xemacs-betaname)
			       xemacs-betaname)
			  ;; It does not exist in XEmacs
			  ;; versions prior to 20.3.
			  (concat " " xemacs-betaname))
			 ((and (boundp 'emacs-patch-level)
			       emacs-patch-level)
			  ;; It does not exist in FSF Emacs or in
			  ;; XEmacs versions earlier than 21.1.1.
			  (format " (patch %d)" emacs-patch-level))
			 (t ""))
		   " (" xemacs-codename ") ("
		   system-configuration ")")
		" (" emacs-version ")"))
    (let ((ver (if (string-match "\\.[0-9]+$" emacs-version)
		   (substring emacs-version 0 (match-beginning 0))
		 emacs-version)))
      (if (featurep 'mule)
	  (if (boundp 'enable-multibyte-characters)
	      (concat "Emacs/" ver
		      " (" system-configuration ")"
		      (if enable-multibyte-characters
			  (concat " MULE/" mule-version)
			" (with unibyte mode)")
		      (if (featurep 'meadow)
			  (let ((mver (Meadow-version)))
			    (if (string-match "^Meadow-" mver)
				(concat " Meadow/"
					(substring mver
						   (match-end 0)))
			      )))
		      (if (boundp 'NEMACS)
			  (let ((nemacs-version      
				 (condition-case ()
				     (eval '(nemacs-version))
				   (error ""))))
			    (when (string-match 
				   "Nemacs version \\([^ ]*\\)" 
				   nemacs-version)
			      (setq nemacs-version 
				    (match-string 1 nemacs-version)))
			    (concat " NEmacs/" nemacs-version))))
	    (concat "MULE/" mule-version
		    " (based on Emacs " ver ")"))
	(concat "Emacs/" ver " (" system-configuration ")")))))

(defvar liece-user-agent-value
  (concat liece-version " " 
	  (if (fboundp 'apel-version)
	      (concat (apel-version) " ")
	    nil)
	  liece-emacs-user-agent-value))

(defun liece-command-version (&optional arg)
   "Version number of this version of Gnus.
If ARG, insert string at point."
   (interactive "P")
   (if arg
       (insert (message liece-user-agent-value))
     (message liece-user-agent-value)))
  
(provide 'liece-version)

;;; liece-version.el ends here
