#include "links.h"

struct list_head assoc = { &assoc, &assoc };

tcount get_assoc_cnt()
{
	static tcount assoc_cnt = 0;
	if (!++assoc_cnt) assoc_cnt = 1;
	return assoc_cnt;
}

struct list_head extensions = { &extensions, &extensions };

void delete_association(struct assoc *del)
{
	del_from_list(del);
	mem_free(del->label);
	mem_free(del->ct);
	mem_free(del->prog);
	mem_free(del);
}

void delete_extension(struct extension *del)
{
	del_from_list(del);
	mem_free(del->ext);
	mem_free(del->ct);
	mem_free(del);
}

int is_in_list(unsigned char *list, unsigned char *str, int l)
{
	unsigned char *l2, *l3;
	if (!l) return 0;
	rep:
	while (*list && *list <= ' ') list++;
	if (!*list) return 0;
	for (l2 = list; *l2 && *l2 != ','; l2++) ;
	for (l3 = l2 - 1; l3 >= list && *l3 <= ' '; l3--) ;
	l3++;
	if (l3 - list == l && !casecmp(str, list, l)) return 1;
	list = l2;
	if (*list == ',') list++;
	goto rep;
}

unsigned char *get_content_type(unsigned char *head, unsigned char *url)
{
	struct extension *e;
	struct assoc *a;
	unsigned char *ct, *ext, *exxt;
	int extl, el;
	if (head && (ct = parse_http_header(head, "Content-Type"))) {
		unsigned char *s;
		if ((s = strchr(ct, ';'))) *s = 0;
		while (*ct && ct[strlen(ct) - 1] <= ' ') ct[strlen(ct) - 1] = 0;
		return ct;
	}
	ext = NULL, extl = 0;
	for (ct = url; *ct && !end_of_dir(*ct); ct++)
		if (*ct == '.') ext = ct + 1;
		else if (dir_sep(*ct)) ext = NULL;
	if (ext) while (ext[extl] && !dir_sep(ext[extl]) && !end_of_dir(ext[extl])) extl++;
	if ((extl == 3 && !casecmp(ext, "htm", 3)) ||
	    (extl == 4 && !casecmp(ext, "html", 4))) return stracpy("text/html");
	foreach(e, extensions) if (is_in_list(e->ext, ext, extl)) return stracpy(e->ct);
	exxt = init_str(); el = 0;
	add_to_str(&exxt, &el, "application/x-");
	add_bytes_to_str(&exxt, &el, ext, extl);
	foreach(a, assoc) if (is_in_list(a->ct, exxt, el)) return exxt;
	mem_free(exxt);
	return stracpy("text/plain");
}

struct assoc *get_type_assoc(struct terminal *term, unsigned char *type)
{
	struct assoc *a;
	foreach(a, assoc) if (a->system == SYSTEM_ID && (term->xwin ? a->xwin : a->cons) && is_in_list(a->ct, type, strlen(type))) return a;
	return NULL;
}

void free_types()
{
	struct assoc *a;
	struct extension *e;
	foreach(a, assoc) {
		mem_free(a->ct);
		mem_free(a->prog);
		mem_free(a->label);
	}
	free_list(assoc);
	foreach(e, extensions) {
		mem_free(e->ext);
		mem_free(e->ct);
	}
	free_list(extensions);
}

unsigned char *ct_msg[] = {
	"Label",
	"Content-Type(s)",
	"Program ('%' is replaced with file name)",
	"Run on terminal",
	"Run in X-Window",
	"Ask before opening",
};

void add_ct_fn(struct dialog_data *dlg)
{
	int max = 0, min = 0;
	int w, rw;
	int x, y = -1;
	max_text_width(ct_msg[0], &max);
	min_text_width(ct_msg[0], &min);
	max_text_width(ct_msg[1], &max);
	min_text_width(ct_msg[1], &min);
	max_text_width(ct_msg[2], &max);
	min_text_width(ct_msg[2], &min);
	max_group_width(ct_msg + 3, dlg->items + 3, 3, &max);
	min_group_width(ct_msg + 3, dlg->items + 3, 3, &min);
	max_buttons_width(dlg->items + 6, 2, &max);
	min_buttons_width(dlg->items + 6, 2, &min);
	w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
	if (w > max) w = max;
	if (w < min) w = min;
	if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
	if (w < 1) w = 1;
	rw = 0;
	dlg_format_text(NULL, ct_msg[0], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_text(NULL, ct_msg[1], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_text(NULL, ct_msg[2], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_group(NULL, ct_msg + 3, dlg->items + 3, 3, 0, &y, w, &rw);
	y++;
	dlg_format_buttons(NULL, dlg->items + 6, 2, 0, &y, w, &rw, AL_CENTER);
	w = rw;
	dlg->xw = w + 2 * DIALOG_LB;
	dlg->yw = y + 2 * DIALOG_TB;
	center_dlg(dlg);
	draw_dlg(dlg);
	y = dlg->y + DIALOG_TB;
	dlg_format_text(dlg->win->term, ct_msg[0], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[0], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_text(dlg->win->term, ct_msg[1], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[1], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_text(dlg->win->term, ct_msg[2], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[2], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_group(dlg->win->term, ct_msg + 3, &dlg->items[3], 3, dlg->x + DIALOG_LB, &y, w, NULL);
	y++;
	dlg_format_buttons(dlg->win->term, &dlg->items[6], 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
}

void update_assoc(struct assoc *new)
{
	struct assoc *repl;
	if (!new->label[0] || !new->ct[0] || !new->prog[0]) return;
	if (new->cnt) {
		foreach(repl, assoc) if (repl->cnt == new->cnt) {
			mem_free(repl->label);
			mem_free(repl->ct);
			mem_free(repl->prog);
			goto replace;
		}
		return;
	}
	new->cnt = get_assoc_cnt();
	if (!(repl = mem_alloc(sizeof(struct assoc)))) return;
	add_to_list(assoc, repl);
	replace:
	repl->label = stracpy(new->label);
	repl->ct = stracpy(new->ct);
	repl->prog = stracpy(new->prog);
	repl->cons = new->cons;
	repl->xwin = new->xwin;
	repl->ask = new->ask;
	repl->system = new->system;
	repl->cnt = new->cnt;
}

void really_del_ct(void *fcp)
{
	int fc = (int)fcp;
	struct assoc *del;
	foreach(del, assoc) if (del->cnt == fc) goto ok;
	return;
	ok:
	delete_association(del);
}

void menu_del_ct(struct terminal *term, void *fcp, void *xxx2)
{
	unsigned char *str;
	int l;
	int fc = (int)fcp;
	struct assoc *del;
	foreach(del, assoc) if (del->cnt == fc) goto ok;
	return;
	ok:
	str = init_str(), l = 0;
	add_to_str(&str, &l, get_text("Delete association "));
	add_to_str(&str, &l, del->label);
	add_to_str(&str, &l, ": ");
	add_to_str(&str, &l, del->ct);
	add_to_str(&str, &l, " -> ");
	add_to_str(&str, &l, del->prog);
	add_to_str(&str, &l, "?");
	msg_box(term, getml(str, NULL), get_text("Delete association"), AL_CENTER, str, fcp, 2, get_text("Yes"), really_del_ct, B_ENTER, get_text("No"), NULL, B_ESC);
}

void menu_add_ct(struct terminal *term, void *fcp, void *xxx2)
{
	int fc = (int)fcp;
	struct assoc *new, *from;
	unsigned char *label;
	unsigned char *ct;
	unsigned char *prog;
	struct dialog *d;
	if (fc) {
		foreach(from, assoc) if (from->cnt == fc) goto ok;
		return;
	}
	from = NULL;
	ok:
	if (!(d = mem_alloc(sizeof(struct dialog) + 9 * sizeof(struct dialog_item) + sizeof(struct assoc) + 3 * MAX_STR_LEN))) return;
	memset(d, 0, sizeof(struct dialog) + 9 * sizeof(struct dialog_item) + sizeof(struct assoc) + 3 * MAX_STR_LEN);
	new = (struct assoc *)&d->items[9];
	new->label = label = (unsigned char *)(new + 1);
	new->ct = ct = label + MAX_STR_LEN;
	new->prog = prog = ct + MAX_STR_LEN;
	if (from) {
		strncpy(label, from->label, MAX_STR_LEN - 1);
		strncpy(ct, from->ct, MAX_STR_LEN - 1);
		strncpy(prog, from->prog, MAX_STR_LEN - 1);
		new->cons = from->cons;
		new->xwin = from->xwin;
		new->ask = from->ask;
		new->system = from->system;
		new->cnt = from->cnt;
	} else {
		new->xwin = new->cons = 1;
		new->ask = 1;
		new->system = SYSTEM_ID;
	}
	d->title = get_text("Association");
	d->fn = add_ct_fn;
	d->refresh = (void (*)(void *))update_assoc;
	d->refresh_data = new;
	d->items[0].type = D_FIELD;
	d->items[0].dlen = MAX_STR_LEN;
	d->items[0].data = label;
	d->items[0].fn = check_nonempty;
	d->items[1].type = D_FIELD;
	d->items[1].dlen = MAX_STR_LEN;
	d->items[1].data = ct;
	d->items[1].fn = check_nonempty;
	d->items[2].type = D_FIELD;
	d->items[2].dlen = MAX_STR_LEN;
	d->items[2].data = prog;
	d->items[2].fn = check_nonempty;
	d->items[3].type = D_CHECKBOX;
	d->items[3].data = (unsigned char *)&new->cons;
	d->items[3].dlen = sizeof(int);
	d->items[4].type = D_CHECKBOX;
	d->items[4].data = (unsigned char *)&new->xwin;
	d->items[4].dlen = sizeof(int);
	d->items[5].type = D_CHECKBOX;
	d->items[5].data = (unsigned char *)&new->ask;
	d->items[5].dlen = sizeof(int);
	d->items[6].type = D_BUTTON;
	d->items[6].gid = B_ENTER;
	d->items[6].fn = ok_dialog;
	d->items[6].data = get_text("OK");
	d->items[7].type = D_BUTTON;
	d->items[7].gid = B_ESC;
	d->items[7].data = get_text("Cancel");
	d->items[7].fn = cancel_dialog;
	d->items[8].type = D_END;
	do_dialog(term, d, getml(d, NULL));
}

void menu_list_assoc(struct terminal *term, void *fn, void *xxx)
{
	struct assoc *a;
	struct menu_item *mi;
	int n = 0;
	if (!(mi = new_menu(7))) return;
	foreachback(a, assoc) if (a->system == SYSTEM_ID) add_to_menu(&mi, stracpy(a->label), stracpy(a->ct), 0, MENU_FUNC fn, (void *)a->cnt, 0), n++;
	if (!n) add_to_menu(&mi, stracpy(get_text("No associations")), stracpy(""), M_BAR, NULL, NULL, 0);
	do_menu(term, mi, xxx);
}

unsigned char *ext_msg[] = {
	"Extension(s)",
	"Content-Type",
};

void add_ext_fn(struct dialog_data *dlg)
{
	int max = 0, min = 0;
	int w, rw;
	int x, y = -1;
	max_text_width(ext_msg[0], &max);
	min_text_width(ext_msg[0], &min);
	max_text_width(ext_msg[1], &max);
	min_text_width(ext_msg[1], &min);
	max_buttons_width(dlg->items + 2, 2, &max);
	min_buttons_width(dlg->items + 2, 2, &min);
	w = dlg->win->term->x * 9 / 10 - 2 * DIALOG_LB;
	if (w > max) w = max;
	if (w < min) w = min;
	if (w > dlg->win->term->x - 2 * DIALOG_LB) w = dlg->win->term->x - 2 * DIALOG_LB;
	if (w < 1) w = 1;
	rw = 0;
	dlg_format_text(NULL, ext_msg[0], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_text(NULL, ext_msg[1], 0, &y, w, &rw, COLOR_DIALOG_TEXT, AL_LEFT);
	y += 2;
	dlg_format_buttons(NULL, dlg->items + 2, 2, 0, &y, w, &rw, AL_CENTER);
	w = rw;
	dlg->xw = w + 2 * DIALOG_LB;
	dlg->yw = y + 2 * DIALOG_TB;
	center_dlg(dlg);
	draw_dlg(dlg);
	y = dlg->y + DIALOG_TB;
	dlg_format_text(dlg->win->term, ext_msg[0], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[0], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_text(dlg->win->term, ext_msg[1], dlg->x + DIALOG_LB, &y, w, NULL, COLOR_DIALOG_TEXT, AL_LEFT);
	dlg_format_field(dlg->win->term, &dlg->items[1], dlg->x + DIALOG_LB, &y, w, NULL, AL_LEFT);
	y++;
	dlg_format_buttons(dlg->win->term, &dlg->items[2], 2, dlg->x + DIALOG_LB, &y, w, NULL, AL_CENTER);
}

void update_ext(struct extension *new)
{
	struct extension *repl;
	if (!new->ext[0] || !new->ct[0]) return;
	if (new->cnt) {
		foreach(repl, extensions) if (repl->cnt == new->cnt) {
			mem_free(repl->ext);
			mem_free(repl->ct);
			goto replace;
		}
		return;
	}
	new->cnt = get_assoc_cnt();
	if (!(repl = mem_alloc(sizeof(struct extension)))) return;
	add_to_list(extensions, repl);
	replace:
	repl->ext = stracpy(new->ext);
	repl->ct = stracpy(new->ct);
	repl->cnt = new->cnt;
}

void really_del_ext(void *fcp)
{
	int fc = (int)fcp;
	struct extension *del;
	foreach(del, extensions) if (del->cnt == fc) goto ok;
	return;
	ok:
	delete_extension(del);
}

void menu_del_ext(struct terminal *term, void *fcp, void *xxx2)
{
	unsigned char *str;
	int l;
	int fc = (int)fcp;
	struct extension *del;
	foreach(del, extensions) if (del->cnt == fc) goto ok;
	return;
	ok:
	str = init_str(), l = 0;
	add_to_str(&str, &l, get_text("Delete extension "));
	add_to_str(&str, &l, del->ext);
	add_to_str(&str, &l, " -> ");
	add_to_str(&str, &l, del->ct);
	add_to_str(&str, &l, "?");
	msg_box(term, getml(str, NULL), get_text("Delete extension"), AL_CENTER, str, fcp, 2, get_text("Yes"), really_del_ext, B_ENTER, get_text("No"), NULL, B_ESC);
}

void menu_add_ext(struct terminal *term, void *fcp, void *xxx2)
{
	int fc = (int)fcp;
	struct extension *new, *from;
	unsigned char *ext;
	unsigned char *ct;
	struct dialog *d;
	if (fc) {
		foreach(from, extensions) if (from->cnt == fc) goto ok;
		return;
	}
	from = NULL;
	ok:
	if (!(d = mem_alloc(sizeof(struct dialog) + 5 * sizeof(struct dialog_item) + sizeof(struct extension) + 2 * MAX_STR_LEN))) return;
	memset(d, 0, sizeof(struct dialog) + 5 * sizeof(struct dialog_item) + sizeof(struct extension) + 2 * MAX_STR_LEN);
	new = (struct extension *)&d->items[5];
	new->ext = ext = (unsigned char *)(new + 1);
	new->ct = ct = ext + MAX_STR_LEN;
	if (from) {
		strncpy(ext, from->ext, MAX_STR_LEN - 1);
		strncpy(ct, from->ct, MAX_STR_LEN - 1);
		new->cnt = from->cnt;
	}
	d->title = get_text("Extension");
	d->fn = add_ext_fn;
	d->refresh = (void (*)(void *))update_ext;
	d->refresh_data = new;
	d->items[0].type = D_FIELD;
	d->items[0].dlen = MAX_STR_LEN;
	d->items[0].data = ext;
	d->items[0].fn = check_nonempty;
	d->items[1].type = D_FIELD;
	d->items[1].dlen = MAX_STR_LEN;
	d->items[1].data = ct;
	d->items[1].fn = check_nonempty;
	d->items[2].type = D_BUTTON;
	d->items[2].gid = B_ENTER;
	d->items[2].fn = ok_dialog;
	d->items[2].data = get_text("OK");
	d->items[3].type = D_BUTTON;
	d->items[3].gid = B_ESC;
	d->items[3].data = get_text("Cancel");
	d->items[3].fn = cancel_dialog;
	d->items[4].type = D_END;
	do_dialog(term, d, getml(d, NULL));
}

void menu_list_ext(struct terminal *term, void *fn, void *xxx)
{
	struct extension *a;
	struct menu_item *mi;
	int n = 0;
	if (!(mi = new_menu(7))) return;
	foreachback(a, extensions) add_to_menu(&mi, stracpy(a->ext), stracpy(a->ct), 0, MENU_FUNC fn, (void *)a->cnt, 0), n++;
	if (!n) add_to_menu(&mi, stracpy(get_text("No extensions")), stracpy(""), M_BAR, NULL, NULL, 0);
	do_menu(term, mi, xxx);
}

