/* PEJ */
/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *insock;
extern FILE *outsock;


void mserver_lock(const char *lock_action)
{
	if (!strcasecmp(lock_action, "dial"))
	{
		if (!auth_check("lock", AUTH_CONNECT))
		{
			fprintf(outsock, "ERROR: You are not authorized to lock this connection!!\n");
			return;
		}

		shmem_set_dial_lock(1);
	}
	else
	{
		if (!auth_check("lock", AUTH_DISCONNECT))
		{
			fprintf(outsock, "ERROR: You are not authorized to lock this connection!!\n");
			return;
		}

		shmem_set_kill_lock(1);
	}

	syslog (LOG_DEBUG, "lock action: %s", lock_action);

	fprintf(outsock, "LOCKED\n");
}

void mserver_unlock(const char *unlock_action)
{
	if (!strcasecmp(unlock_action, "dial"))
	{
		if (!auth_check("lock", AUTH_CONNECT))
		{
			fprintf(outsock, "ERROR: You are not authorized to unlock this connection!!\n");
			return;
		}

		shmem_set_dial_lock(-1);
	}
	else
	{
		if (!auth_check("lock", AUTH_DISCONNECT))
		{
			fprintf(outsock, "ERROR: You are not authorized to unlock this connection!!\n");
			return;
		}

		shmem_set_kill_lock(-1);

		if (shmem_get_pending_kill() == true &&
		    shmem_get_kill_lock() == 0)
		{
			mserver_kill_silent();
		}
	}

	syslog (LOG_DEBUG, "unlock action: %s", unlock_action);

	fprintf(outsock, "UNLOCKED\n");
}

void mserver_linfo(void)
{
	int dial_locks;
	int kill_locks;

	dial_locks = shmem_get_dial_lock();
	kill_locks = shmem_get_kill_lock();

	fprintf(outsock, "%i:%i\n", dial_locks, kill_locks);
}

/* PEJ */
