#ifndef __OIDSEQ_H__
#define __OIDSEQ_H__

#include <string.h>

#include "ber.h"

struct TableEntry;

class Assoc{
 public:
  char *str;
  BerOid *oid;
  
  Assoc *next;
  
  Assoc(const char *oidstr,Assoc *nxt);
  Assoc(const char *oidstr,BerOid *oid,Assoc *nxt);
  inline ~Assoc(){ delete str;}

  inline int operator==(const char *oidstr){ return !strcmp(oidstr,str);}
};


class OidSeq {
  BerSequence *seq;
  Assoc *index;

public:
  // converts a list of strings with the ascii representation of oids into
  // an OidSeq. The strings that are passed in are duplicated so that 
  // there is no confusion as to who should delete them.
  inline OidSeq():seq(NULL),index(NULL){}
  OidSeq(unsigned int num...); 
  OidSeq(BerSequence *valseq); // takes ownership of valseq
  //just grabs the oidstrs out of the table doesn't modify the table
  OidSeq(TableEntry *table); 
  ~OidSeq();

  //for gets
  void append(const char *oidstr);

  //for sets of ints and counters.
  void append(const char *oidstr,Tags type, long data);

  //for sets of strings oid's and ipaddrs
  void append(CONST char *oidstr,Tags type, void *data, unsigned int len);

  void remove(const char *oidstr);

  // returns the pointer to the value (keeps ownership)
  BerBase *value(const char* oid); 
  BerBase *value(BerOid &oid);
  // returns the pointer to the value of the child whose oid this is
  BerBase *child(const char *oid);
  // returns the pointer to the beroid who was created with this ascii 
  //version of the oid
  BerOid *key(const char *oid);

  inline int print(char* str,unsigned int len){ return seq->print(str,len);}
  inline BerSequence *Seq(){ return seq;}
};

#endif
