#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>

/* for buggy stdarg.h */

#include "config.h"

#ifdef	BAD_VA_START
# undef va_start
# define	va_start(ap, last) \
    ((ap) = ((va_list)__builtin_next_arg(last)))
#endif

#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>

#include "config.h"

#include "support.h"
#include "xcio.h"
#include "sysmsg.h"
#include "xcmdlist.h"

static u_int8_t xId;

static struct xcqueue_s {
    struct xcqueue_s *next;
    struct xcio_s xc;
} *xqHead;

static int
PPxPPoll(int fd)
{
    int n;
    struct xcio_s xc;
    struct xcqueue_s *xqp, *xq1;

    if ((n = XcioRead(fd, &xc)) < 0) return(-1);
    if (n > 0) {
	xqp = NULL;
	if (xc.xid == XID_UPDATE) {
	    xqp = xqHead;
	    while (xqp) {
		if (xqp->xc.type == xc.type) break;
		xqp = xqp->next;
	    }
	}
	if (!xqp) {
/*printf("%d:%d:%.5s\n", xc.xid, xc.type, xc.buf);*/
	    xqp = TALLOC(struct xcqueue_s);
	    if ((xq1 = xqHead) == NULL) xqHead = xqp;
	    else while (xq1) {
		if (xq1->next) xq1 = xq1->next;
		else {
		    xq1->next = xqp;
		    break;
		}
	    }
	    xqp->next = NULL;
	}
	memcpy(&xqp->xc, &xc, sizeof(xc));
	return(n);
    }
    return(0);
}

int
PPxPRead(int fd, unsigned int id, struct xcio_s *xc)
{
    struct xcqueue_s *xqp, *xq1;
    int n;
    fd_set rfds;
    u_int8_t xid=(id & 0xFF);
    struct timeval tv;

    FD_ZERO(&rfds);
    FD_SET(fd, &rfds);
    memset(&tv, 0, sizeof(tv));
    select(fd + 1, &rfds, NULL, NULL, &tv);
    if (FD_ISSET(fd, &rfds) && (n = PPxPPoll(fd)) < 0) return(-1);
    xq1 = NULL;
    xqp = xqHead;
    while (xqp) {
	if ((id == XID_ANY) || (xqp->xc.xid == xid)) {
	    if (xq1) xq1->next = xqp->next;
	    else xqHead = xqp->next;
	    memcpy(xc, &xqp->xc, sizeof(*xc));
	    Free(xqp);
/*printf("queue=%x\n", xqHead);*/
	    return(1);
	}
	xq1 = xqp;
	xqp = xqp->next;
    }
    return(0);
}

int
PPxPCommand(int fd, xcmd_t type, int argc, char *argv[])
{
    int i;
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = XCIO_XCMD;
    xc.len = 1;
    xc.buf[0] = type;
    for (i = 0; i < argc; i ++) {
	strcpy(xc.buf + xc.len, argv[i]);
	xc.len += strlen(argv[i]) + 1;
    }
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}

int
PPxPCommandv(int fd, xcmd_t type, ...)
{
    va_list ap;
    char *com;
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = XCIO_XCMD;
    xc.len = 1;
    xc.buf[0] = type;
    va_start(ap, type);
    while (com = va_arg(ap, char *)) {
	strcpy(xc.buf + xc.len, com);
	xc.len += strlen(com) + 1;
    }
    va_end(ap);
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}

xcmd_t
PPxPCommandType(char *name)
{
    xcmd_t n;
    int len=strlen(name);

    for (n = 0; n < NUM_XCMD; n ++) {
	if (xcmdList[n].flags & CMD_FULLNAME) {
	    if (!strcasecmp(name, xcmdList[n].name)) break;
	} else {
	    if (!strncasecmp(name, xcmdList[n].name, len)) break;
	}
    }
    return(n);
}

static int
PPxPCommandName(int fd, int argc, char *argv[])
{
    xcmd_t n;
    int len=strlen(argv[0]);

    for (n = 0; n < NUM_XCMD; n ++) {
	if (xcmdList[n].flags & CMD_FULLNAME) {
	    if (!strcasecmp(argv[0], xcmdList[n].name)) break;
	} else {
	    if (!strncasecmp(argv[0], xcmdList[n].name, len)) break;
	}
    }
    if (n < NUM_XCMD)
	return(PPxPCommand(fd, n, argc - 1, &argv[1]));
    return(-1);
}

char *
PPxPEnvGet(int fd, u_int8_t xid)
{
    int n, argc;
    char *argv[6];
    static char env[256];
    struct xcio_s xc;

    env[0] = '\0';
    while ((n = PPxPRead(fd, xid, &xc)) >= 0) if (n > 0) {
	if ((xc.type & XCIO_MASK) == XCIO_ENV_SET) {
	    argc = DecodeArgs(argv, xc.buf, xc.len, 6);
	    strcpy(env, argv[1]);
	    FreeArgs(argc, argv);
	}
	if (xc.type & XCIO_LAST) break;
    }
    return(env);
}

int
PPxPEnvRequestv(int fd, ...)
{
    va_list ap;
    char *com;
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = XCIO_ENV_REQ;
    xc.len = 0;
    va_start(ap, fd);
    while (com = va_arg(ap, char *)) {
	strcpy(xc.buf + xc.len, com);
	xc.len += strlen(com) + 1;
    }
    va_end(ap);
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}

int
PPxPEnvRequest(int fd, int argc, char *argv[])
{
    int a;
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = XCIO_ENV_REQ;
    xc.len = 0;
    for (a = 0; a < argc; a ++) {
	strcpy(xc.buf + xc.len, argv[a]);
	xc.len += strlen(argv[a]) + 1;
    }
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}

void
PPxPUpdateRequest(int fd)
{
    struct xcio_s xc;

    xc.xid = XID_UPDATE;
    xc.type = XCIO_UP_INFO;
    xc.len = 0;
    XcioWrite(fd, &xc);
}

void
PPxPAutoUpdate(int fd, bool_t sw)
{
    struct xcio_s xc;

    xc.xid = XID_UPDATE;
    xc.type = XCIO_UP_AUTO;
    xc.len = 1;
    xc.buf[0] = sw ? 1: 0;
    XcioWrite(fd, &xc);
}

int
PPxPRequest(int fd, u_int8_t x)
{
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = x;
    xc.len = 0;
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}

static void
SendHello(int fd, char *name, int ifnum, int mode)
{
    struct xcio_s hello;
    uid_t uid=getuid();

    strcpy(hello.buf, name);
    hello.len = strlen(name) + 1;
    memcpy(&hello.buf[hello.len], &uid, sizeof(uid));
    hello.len += sizeof(uid);
    hello.buf[hello.len] = (char)ifnum;
    hello.type = XCIO_HELLO;
    hello.xid = XID_UPDATE;
    write(fd, &hello, sizeof(hello));
}

static const char *ifNames[] = {IFNAME};
#define IFNUM ((int)(sizeof(ifNames)/sizeof(ifNames[0]))*16)

char *
GetIfName(int n)
{
    static char name[64];
    int major, minor;

    if (n >= IFNUM)
	return(NULL);

    major = n/16;
    minor = n%16;

    sprintf(name, "%s%1x", ifNames[major], minor);
    return(name);
}

int
GetIfNum(char *name)
{
    int  i, n;
    char *p;
    int ifnum = -1;

    for (p = name; *p && !(isalpha(*p) || isdigit(*p)); p ++)
	;
    n = sizeof(ifNames)/sizeof(ifNames[0]);
    for (i = 0; i < n; i++) {
	if (strncmp(p, ifNames[i], strlen(ifNames[i])) == 0)
	    break;
    }
    if (i < n) {
	for (; *p && !isdigit(*p); p ++)
	    ;
	if (*p)
	    ifnum = i*16 + atoi(p);
    }
    return(ifnum);
}

int
PPxPLocalOpen(int *ifnum)
{
    int i, fd=-1;
    size_t j;
    struct sockaddr sa;
    char *ifname;

    memset(&sa, 0, sizeof(struct sockaddr));
    sa.sa_family = AF_UNIX;
    if (chdir("/tmp")) return(-1);
    if (*ifnum >= 0) {
	ifname = GetIfName(*ifnum);
	if (ifname) {
	    sprintf(sa.sa_data, ".ppxp-%s", ifname);
	    if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
		perror("socket");
	    }
	    if (connect(fd, &sa, LEN_SA_DATA(sa)) < 0) {
#ifdef todo_lib_polling
		fprintf(stderr, "connect(/tmp/%s): %s\n",
			sa.sa_data, strerror(errno));
#endif
		close(fd);
		fd = -1;
	    }
	}
    } else {
	for (i = 0; i < IFNUM; i ++) {
	    ifname = GetIfName(i);
	    if (!ifname) break;
	    sprintf(sa.sa_data, ".ppxp-%s", ifname);
	    *ifnum = i;
	    if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) >= 0) {
		if (connect(fd, &sa, LEN_SA_DATA(sa)) >= 0) break;
		close(fd);
		*ifnum = fd = -1;
	    }
	}
	if (fd < 0) {
	    FILE *fp;
	    char buf[40], *p;

	    *ifnum = -1;
	    if ((fp = popen(PATH_PPXPD, "r")) == NULL) return(-1);
	    while (fgets(buf, sizeof(buf), fp)) {
		if ((p = strstr(buf, "interface:")) != NULL) {
		    p += sizeof("interface:");
		    *ifnum = GetIfNum(p);
		    break;
		}
	    }
	    pclose(fp);
	    return(*ifnum < 0 ? -1: PPxPLocalOpen(ifnum));
	}
    }
    if (fd < 0) {
#ifdef todo_lib_polling
	fprintf(stderr, "daemon not found\n");
#endif
	return(-1);
    }
    return(fd);
}

static int
PPxPRemoteOpen(char *host)
{
    struct servent *sp;
    struct sockaddr_in sa;
    int sfd=-1;

    if ((sp = getservbyname("ppxp", "tcp")) == NULL) return(-1);
    memset(&sa, 0, sizeof(sa));
    sa.sin_family = AF_INET;
    sa.sin_addr.s_addr = inet_addr(host);
    if (sa.sin_addr.s_addr == INADDR_NONE) {
	struct hostent *hp;

	if ((hp = gethostbyname(host)) == NULL) return(-1);
	memcpy(&sa.sin_addr, hp->h_addr, 4);
    }
    if ((sfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) return(-1);
    sa.sin_port = sp->s_port;
    if (connect(sfd, (struct sockaddr *)&sa, sizeof(sa)) < 0) {
	close(sfd);
	return(-1);
    }
    return(sfd);
}

int
PPxPSetup(int *argc, char **argv)
{
    int oargc, i, n, fd, mode=XCIO_HELLO, ifnum=-1;
    int narg, parg, sargc, nargc;
    char *p, **sargv, *host=NULL, buf[256];

    /*
     * ppxp [<script file> ...] ... [-i [remote:]<ifnum>]
     *                                      [-c <ppxpd commands ...>]
     *                          ^               ^
     * 0                        narg            parg
     */
    nargc = sargc = narg = parg = 0;
    oargc = *argc;
    sargv = (char **)Malloc(sizeof(char *) * oargc);
    SysMsgInit();
    for (n = i = 1; i < oargc; i ++) {
	p = argv[i];
	if (*p == '-') {
	    if (!narg) narg = i;
	    p ++;
	    if (!strcmp(p, "c")) {
		parg = i;
		i = oargc; /* == break */
		continue;
	    }
	    if (!strcmp(p, "h")) {
		printf("%s [<script file> ...] "
		       "... [-i [remote:]<ifnum>] "
		       "[-c <ppxpd commands ...>]\n", argv[0]);
		continue;
	    }
	    if (ifnum < 0 && !strcmp(p, "i")) {
		i ++;
		if (i >= oargc) return(-1);
		if ((p = strchr(argv[i], ':')) != NULL) {
		    host = Strdup(argv[i]);
		    p = strchr(host, ':');
		    *p = '\0';
		    p ++;
		} else p = argv[i];
		while (*p && !isdigit(*p)) p ++;
		ifnum = *p ? atoi(p): -1;
		continue;
	    }
	} else if (!narg) {
	    sargv[sargc ++] = argv[i];
	    continue;
	}
	argv[n ++] = argv[i];
    }
    *argc = n;

    if (host) {
	fd = PPxPRemoteOpen(host);
	Free(host);
    } else {
	p = getcwd(buf, sizeof(buf));
	fd = PPxPLocalOpen(&ifnum);
	if (p) chdir(p);
    }
    if ((p = strrchr(argv[0], '/')) != NULL) p ++;
    else p = argv[0];
    sprintf(buf, "%s", p);
    if (fd >= 0) {
	struct xcio_s xc;

	SendHello(fd, buf, ifnum, mode);
	XcioOpen(fd);
	if (sargc > 0) {
	    PPxPCommandv(fd, XCMD_SET, "NAME", sargv[0], NULL);
	    while ((n = XcioRead(fd, &xc)) >= 0 && n != XCIO_RETURN);
	    PPxPCommandv(fd, XCMD_SET, "AUTH.PASSWD", sargv[0], NULL);
	    while ((n = XcioRead(fd, &xc)) >= 0 && n != XCIO_RETURN);
	    for (i = 0; i < sargc; i ++) {
		PPxPCommandv(fd, XCMD_SOURCE, sargv[i], NULL);
		while ((n = XcioRead(fd, &xc)) >= 0 && n != XCIO_RETURN);
	    }
	    if (n < 0) return(-1);
	    Free(sargv);
	}
	if (parg > 0) {
	    int a;

	    for (a = parg; a < oargc;) {
		a ++;
		for (i = a; i < oargc; i ++)
		    if (!strcmp(argv[i], "-")) break;
		if (PPxPCommandName(fd, i - a, &argv[a]) >= 0)
		    while ((n = XcioRead(fd, &xc)) >= 0
			   && n != XCIO_RETURN);
		if (n < 0) return(-1);
		a = i;
	    }
	}
    }
    return(fd);
}

int
PPxPwdRequest(int fd, char *entry)
{
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = XCIO_PWD_REQ;
    if (entry) {
	if ((xc.len = strlen(entry)) > 0) {
	    strcpy(xc.buf, entry);
	    xc.len ++;
	}
    } else xc.len = 0;
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}

int
PPxPwdSet(int fd, char *entry, char *name, char *key)
{
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.len = 0;
    xc.type = XCIO_PWD_SET;

    strcpy(xc.buf + xc.len, name);
    xc.len += strlen(name) + 1;

    strcpy(xc.buf + xc.len, key);
    xc.len += strlen(key) + 1;

    if (entry) {
	strcpy(xc.buf + xc.len, entry);
	xc.len += strlen(entry) + 1;
    }
    return(XcioWrite(fd, &xc) > 0 ? xc.xid: 0);
}

int
PPxPwdGet(int fd, char **name, char **key)
{
    struct xcio_s xc;
    char *argv[3];
    int n, argc;
    u_int8_t xid;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.len = 0;
    xc.type = XCIO_PWD_SET;

    if (XcioWrite(fd, &xc) <= 0) return(-1);

    xid = xc.xid;
    while ((n = PPxPRead(fd, xid, &xc)) >= 0) if (n > 0) {
	if ((xc.type & XCIO_MASK) == XCIO_PWD_SET) {
	    argc = DecodeArgs(argv, xc.buf, xc.len, 3);
	    if (argc > 0 && name) *name = Strdup(argv[0]);
	    if (argc > 1 && key) *key = Strdup(argv[1]);
	    FreeArgs(argc, argv);
	}
	if (xc.type & XCIO_LAST) break;
    }
    return(0);
}

int
PPxPListupRequest(int fd)
{
    struct xcio_s xc;

    if ((++ xId) == XID_UPDATE) xId = 1;
    xc.xid = xId;
    xc.type = XCIO_LISTUP;
    xc.len = 0;
    return((XcioWrite(fd, &xc) > 0) ? xc.xid: 0);
}
