/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef TN5250_H
#define TN5250_H

#ifdef __cplusplus
extern "C" {
#endif

#include <tn5250/config.h>

	/* We need this */
#include <stdio.h>

#include <tn5250/buffer.h>
#include <tn5250/utility.h>
#include <tn5250/codes5250.h>
#include <tn5250/dbuffer.h>
#include <tn5250/field.h>
#include <tn5250/formattable.h>
#include <tn5250/record.h>
#include <tn5250/stream.h>

#include <tn5250/terminal.h>
#include <tn5250/session.h>
#include <tn5250/printsession.h>
#ifdef USE_CURSES
#include <tn5250/cursesterm.h>
#endif
#ifdef USE_SLANG
#include <tn5250/slangterm.h>
#endif
#include <tn5250/debug.h>

#ifdef __cplusplus
}
#endif

#endif				/* TN5250_H */
