/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_LIST_H__
#define __ARTICLE_LIST_H__

#include <gdk/gdk.h>
#include <gtk/gtkstyle.h>
#include <gtk/gtkctree.h>

#include "article-db.h"
#include "server.h"
#include "group.h"
#include "pan-callback.h"
#include "status-item.h"

extern GdkColormap *cmap;
extern GdkColor read_color;
extern GdkColor unread_color;
extern GdkColor new_color;
extern GdkColor killfile_color;
extern GdkColor watched_color;

extern GtkStyle *unread_style;
extern GtkStyle *read_style;
extern GtkStyle *new_style;
extern GtkStyle *killfile_style;
extern GtkStyle *watched_style;

extern gboolean hide_mpart_child_nodes;

/****
*****  CALLBACKS
****/

/**
 * called whenever the article tree's active state filter changes.
 *
 * @param call_object the article ctree
 * @param call_arg an unsigned int of the state filter bitfields
 */
extern PanCallback* articlelist_state_filter_changed;

/**
 * called whenever the article tree's active group changes.
 *
 * @param call_object the article ctree
 * @param call_arg the new active group
 */
extern PanCallback* articlelist_group_changed;

/**
 * called whenever the article tree's sorting changes.
 *
 * @param call_object the article ctree
 * @param call_arg a GINT_TO_POINTER of the new sort type.
 */
extern PanCallback* articlelist_sort_changed;

/**
 * called whenever the article tree's threaded state changes.
 *
 * @param call_object the article ctree
 * @param call_arg NULL if threading is off, non-NULL if threading is on
 */
extern PanCallback* articlelist_thread_changed;

/**
 * called whenever the article tree's selection state changes.
 *
 * @param call_object the article ctree
 * @param call_arg adata of the selected article, or NULL if none
 */
extern PanCallback* articlelist_selection_changed;

/****
***** 
****/

/**
 * This pokes any given flag in the current state filter,
 * saves the state to disk,
 * and fires off the articlelist_state_filter_changed callbacks.
 */
extern void articlelist_poke_state_filter(guint flag, gboolean on);




/**
***
***
***
***
**/


/* state info */
extern group_data* articlelist_get_current_group(void);
extern const server_data* articlelist_get_current_server(void);
extern void articlelist_set_current_group (server_data *, group_data *);
extern void articlelist_set_sort_type (int sort_type);
extern void articlelist_set_threaded (gboolean threaded_on);
extern void articlelist_refresh (StatusItem*);
extern article_data* articlelist_get_adata_from_node (GtkCTreeNode*);
extern GtkCTreeNode* articlelist_get_selected_node (void);
extern article_data* articlelist_get_selected_adata (void);


/* stepping through the articles */
const char* articlelist_get_selected_message_id (void);
void articlelist_set_selected_message_id (const char* message_id);
void articlelist_set_selected_node (GtkCTreeNode*);
const article_data* articlelist_get_previous_article (void);
const article_data* articlelist_get_next_article (void);
GtkCTreeNode* articlelist_node_next (GtkCTreeNode*, gboolean sibling_only);
GtkCTreeNode* articlelist_node_prev (GtkCTreeNode*, gboolean sibling_only);



/* more stepping */
extern void articlelist_read_next_article(void);
extern void articlelist_read_next_unread_article(void);
extern void articlelist_read_next_thread(void);
extern void articlelist_read_prev_article(void);
extern void articlelist_read_prev_unread_article(void);
extern void articlelist_read_prev_thread(void);

/* contents */
extern void articlelist_load (server_data*, group_data*, StatusItem*);
/* this emits the "next step" signal between alist_total*2 and alist_total*3 times, depending on the killfile */
extern void articlelist_set_contents (server_data*, group_data*, GSList* adata_list, int adata_qty, StatusItem*);
extern void articlelist_clear (void);
extern void articlelist_queue_reload (void);
extern void articlelist_update_node (const article_data* adata);

/* article operations */
extern void articlelist_select_all (void);
extern void articlelist_selected_decode (void);
extern void articlelist_selected_decode_as (void);
extern void articlelist_selected_delete (void);
extern void articlelist_selected_delete_thread (void);
extern void articlelist_selected_mark_read (void);
extern void articlelist_selected_mark_unread (void);
extern void articlelist_selected_open (void);
extern void articlelist_selected_thread_track (void);
extern void articlelist_selected_thread_download (void);
extern void articlelist_selected_thread_kill (void);
extern void articlelist_all_mark_read (void);
extern void articlelist_expire (article_db, group_data *);

/* util */
extern GtkWidget* create_articlelist_ctree (void);

extern void articlelist_adata_read_changed (const article_data*);


#endif /* __ARTICLE_LIST_H__ */
