/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __NNTP_H__
#define __NNTP_H__

#include "server.h"
#include "group.h"
#include "article.h"
#include "sockets.h"

extern gboolean must_exit;
extern gboolean online_prompt;

extern void nntp_disconnect (PanSocket*);

extern const char*  nntp_login(PanSocket*, server_data*);
extern GSList* nntp_grouplist_download_all (PanSocket*);
extern GSList* nntp_grouplist_download_new (PanSocket*, server_data*);
extern GSList* nntp_articlelist_download (PanSocket*, server_data*, group_data*, int, int*);

extern gboolean nntp_set_group (PanSocket*, const group_data *data);

extern int nntp_post (PanSocket*, const char*);

extern gboolean is_online (void);

extern gint nntp_send_noop(PanSocket*);

#endif /* __NNTP_H__ */
