#include <errno.h>
#include <signal.h>
#include "npcompose.h"

#include <gtk/gtk.h>

void SIGTERM_handler( int signo )
{
   gtk_main_quit();
   return;
}

void signal_handler( int signo )
{
   _exit( signo );
}

NP_Compose::NP_Compose( int *argc, char ***argv )
{
   home = getenv( "HOME" );

   text = server = group = type = NULL;

   window = header_widget = text_widget = message_window = message_label 
      = NULL;
   
   offset = 0;

   gtk_init( argc, argv );

   signal( SIGTERM, SIGTERM_handler );
   signal( SIGQUIT, SIGTERM_handler );
   signal( SIGSEGV, signal_handler );

   window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_realize( window );
   gtk_window_set_policy( GTK_WINDOW( window ), TRUE, TRUE, TRUE );
   gtk_container_border_width( GTK_CONTAINER( window ), 10 );
   gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_button_callback ), this );
   gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                       GTK_SIGNAL_FUNC( close_button_callback ), this );
   gtk_window_set_title( GTK_WINDOW( window ),
                         "News Peruser Message Composer" );
   
   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_add( GTK_CONTAINER( window ), frame );

   GtkWidget *table = gtk_table_new( 20, 20, FALSE );
   gtk_widget_show( table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_table_set_row_spacings( GTK_TABLE( table ), 10 );
   
   GtkWidget *pane = gtk_vpaned_new();
   gtk_widget_show( pane );
   gtk_table_attach_defaults( GTK_TABLE( table ), pane, 0, 20, 0, 19 );
   
   GtkWidget *vbox = gtk_vbox_new( 0, FALSE );
   gtk_widget_show( vbox );
   gtk_paned_add1( GTK_PANED( pane ), vbox );

   GtkWidget *label = gtk_label_new( "If desired, modify the"
                                     " automatically-generated header..." );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );
   
   GtkWidget *hbox = gtk_hbox_new( 0, FALSE );
   gtk_widget_show( hbox );
   gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 0 );

   header_widget = gtk_text_new( NULL, NULL );
   gtk_widget_show( header_widget );
   gtk_text_set_editable( GTK_TEXT( header_widget ), TRUE );
   gtk_box_pack_start( GTK_BOX( hbox ), header_widget, TRUE, TRUE, 0 );

   GtkWidget *vscroll = gtk_vscrollbar_new( GTK_TEXT( header_widget )->vadj );
   gtk_widget_show( vscroll );
   gtk_widget_realize( header_widget );
   gtk_box_pack_start( GTK_BOX( hbox ), vscroll, FALSE, FALSE, 0 );

   vbox = gtk_vbox_new( 0, FALSE );
   gtk_widget_show( vbox );
   gtk_paned_add2( GTK_PANED( pane ), vbox );
   
   label = gtk_label_new( "...then enter the body of the message below" );
   gtk_widget_show( label );
   gtk_box_pack_start( GTK_BOX( vbox ), label, FALSE, FALSE, 0 );

   hbox = gtk_hbox_new( 0, FALSE );
   gtk_widget_show( hbox );
   gtk_box_pack_start(  GTK_BOX( vbox ), hbox, TRUE, TRUE, 0 );

   text_widget = gtk_text_new( NULL, NULL );
   gtk_widget_show( text_widget );
   gtk_text_set_editable( GTK_TEXT( text_widget ), TRUE );
   gtk_box_pack_start( GTK_BOX( hbox ), text_widget, TRUE, TRUE, 0 );

   vscroll = gtk_vscrollbar_new( GTK_TEXT( text_widget )->vadj );
   gtk_widget_show( vscroll );
   gtk_widget_realize( text_widget );
   gtk_box_pack_start( GTK_BOX( hbox ), vscroll, FALSE, FALSE, 0 );

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 19, 19, 20 );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " External Editor ",
                            "Launch the configured external editor program"
                            " with the current message text.", NULL, NULL,
                            GTK_SIGNAL_FUNC( editor_button_callback ), this );

   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_TEXT );
   gtk_widget_show( toolbar );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 19, 20, 19, 20 );

   
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Cancel ",
                            "Close the composition window and discard the "
                            "message.", NULL, NULL,
                            GTK_SIGNAL_FUNC( cancel_button_callback ), NULL );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Save ",
                            "Close the composition window and save the"
                            " message.", NULL, NULL,
                            GTK_SIGNAL_FUNC( close_button_callback ), this );
   
   text = NULL;

   process_args( *argc, *argv );
   
	set_size();
   gtk_widget_show( window );
   
   return;
}
