#include "npconfig.h"

void sort_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   if ( !config->active_groups )
      return;

   char buffer[ 256 ];

   int which_list = ( int )gtk_object_get_data( GTK_OBJECT( widget ), "list" );

   config->busy_cursor_and_block_signals( 1 );

   if ( which_list )
   {
      if ( !config->group_clist_lines || config->group_clist_lines == 1 )
      {
         config->busy_cursor_and_block_signals( 0 );
         return;
      }
      
      struct array_t
      {
         char *name;
         char *number;
      }
      *array;

      if (( array = ( array_t *)calloc( config->group_clist_lines,
                                        sizeof *array )) == NULL )
      {
         perror( "calloc" );
         exit( 1 );
      }

      struct array_t *pointer = array;
      
      for( int i = 0; i < config->group_clist_lines; ++i )
      {
         char *text;
         gtk_clist_get_text( GTK_CLIST( config->edit_group_clist ),
                             i, 0, &text );
         
         if (( pointer->name = strdup( text )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }

         gtk_clist_get_text( GTK_CLIST( config->edit_group_clist ),
                             i, 1, &text );
         
         if (( pointer->number = strdup( text )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }

         ++pointer;
      }

      qsort( array, config->group_clist_lines, sizeof *array, compare );

      gtk_clist_freeze( GTK_CLIST( config->edit_group_clist ));
      gtk_clist_clear( GTK_CLIST( config->edit_group_clist ));

      pointer = array;
      for( int i = 0; i < config->group_clist_lines; ++i )
      {
         char *text[ 2 ];
         text[ 0 ] = pointer->name;
         text[ 1 ] = pointer->number;
         
         gtk_clist_append( GTK_CLIST( config->edit_group_clist ), text );

         free( pointer->name );
         free( pointer->number );
         ++pointer;
      }

      free( array );

      gtk_clist_thaw( GTK_CLIST( config->edit_group_clist ));
   }
   else
   {
      if ( config->server.sort_list(
         ( char *)config->subscription[ config->current_server ],
         SIGALRM_handler ) )
      {
         snprintf( buffer, sizeof buffer, "sort_button_callback(): %s",
                   config->server.get_error() );
         config->show_message( buffer, 0 );
      }

      GtkWidget *active
         = ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                              "active" );
      config->load_clist( active );
   }

   config->busy_cursor_and_block_signals( 0 );
   
   return;
}
