/*
** Copyright (C) 12 Mar 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include "selection_IO.h"
#include "common_gtk.h"
#include "filepicker.h"
#include "vector_commands.h"
#include "modify_file_set.h"
#include "audio.h"
#include "globals.h"

/* a selection file is an ascii file with keyword=value lines:
 * first line is one of: */
#define SEL_TYPE_ISO "sel_type=iso\n"
#define SEL_TYPE_AUDIO "sel_type=audio\n"
/* iso:
 *	paths of the form iso_sel_path=/foo/bar
 * audio:
 *	paths of the form audio_sel_path=/foo/bar
 *	paths of the form audio_data_sel_path=/foo/iso
 */

static char buffer[BUF_S];

/* saves a selection to file from type 
 * type == 0:
 *	the iso-image clist, mkisofs options and iso-filepaths saved
 * type == 1:
 *	the audio_clist, audio related options and audio-filepaths saved
 * TODO: option saving not yet implemented, will be added when preferences
 *	 get done, data images are not saved as data images with type == 1 (audio_data_sel_path)
 */

void save_selection(char *save_to_filename, int type) {
	int i;
	GtkWidget *fclist;
	FILE *out_file;
	file_data *info;
	char *keyword;

	if (NULL == (out_file = fopen(save_to_filename, "w"))) {
		g_warning("select_IO.c::save_selection: fopen() of %s failed",
				save_to_filename);
		return;
	}

	switch (type) {
		case 0:
			fclist = clist;
			keyword = "iso_sel_path=";
			if (EOF == fputs(SEL_TYPE_ISO, out_file))
				g_warning("selection_IO.c::save_selection: fputs() failed");
			break;
		case 1:
			fclist = audio_clist;
			keyword = "audio_sel_path=";
			if (EOF == fputs(SEL_TYPE_AUDIO, out_file))
				g_warning("selection_IO.c::save_selection: fputs() failed");
			break;
		default:
			g_warning("selection_IO.c::save_selection: type not implemented");
			if (EOF == fclose(out_file))
				g_warning("selection_IO.c::save_selection: fclose() failed");
			return;
	}

	for (i = 0; i < GTK_CLIST(fclist)->rows; i++) {
		info = gtk_clist_get_row_data(GTK_CLIST(fclist), i);
		g_assert(NULL != info);
		if (EOF == fputs(keyword, out_file))
			g_warning("selection_IO.c::save_selection: fputs() failed");
		if (EOF == fputs(info->path, out_file))
			g_warning("selection_IO.c::save_selection: fputs() failed");
		if (EOF == fputs("\n", out_file))
			g_warning("selection_IO.c::save_selection: fputs() failed");
	}
	if (EOF == fclose(out_file))
		g_warning("selection_IO.c::save_selection: fclose() failed");
}

/* loads selection from file, auto determines type
 * TODO: read audio_data_sel_path=, too
 */

void load_selection(char *load_from_filename) {
	FILE *in_file;

	if (NULL == (in_file = fopen(load_from_filename, "r"))) {
		g_warning("seleciont_IO.c::load_selection: fopen() of %s failed",
				load_from_filename);
		return;
	}

	if (NULL == fgets(buffer, BUF_S, in_file))
		g_warning("selection_IO.c::load_selection: fgets() failed");

	if (!strcmp(buffer, SEL_TYPE_ISO)) {
		gtk_clist_clear(GTK_CLIST(clist));

		while (NULL != fgets(buffer, BUF_S, in_file)) {
			if (!strncmp(buffer, "iso_sel_path=", strlen("iso_sel_path="))) {
				buffer[strlen(buffer)-1] = '\0';
				selected_file(0, buffer + strlen("iso_sel_path="));
			}
		}
	} else if (!strcmp(buffer, SEL_TYPE_AUDIO)) {
		gtk_clist_clear(GTK_CLIST(audio_clist));

		while (NULL != fgets(buffer, BUF_S, in_file)) {
			if (!strncmp(buffer, "audio_sel_path=", strlen("audio_sel_path="))) {
				buffer[strlen(buffer)-1] = '\0';
				add_track(0, buffer + strlen("audio_sel_path="));
			}
		}
	} else {
		g_warning("selection_IO.c::load_selection: file format not implemented");
		if (EOF == fclose(in_file))
			g_warning("selection_IO.c::load_selection: fclose() failed");
		return;
	}

	if (EOF == fclose(in_file))
		g_warning("selection_IO.c::load_selection: fclose() failed");
}

