/* ".HEX" file output for gpasm
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "gpasm.h"
#include "hex.h"

static int sum;
static FILE *hex;

static void new_record()
{
  fprintf(hex, ":");
  sum = 0;
}

static void write_byte(int b)
{
  sum += b;
    
  assert((0 <= b) && (b <= 255));
  fprintf(hex, "%02X", b);
}

/* Write big-endian word */
static void write_bg_word(int w)
{
  write_byte((w >> 8) & 0xff);
  write_byte(w & 0xff);
}

/* Write little-endian word */
static void write_word(int w)
{
  write_byte(w & 0xff);
  write_byte((w >> 8) & 0xff);
}

static void end_record()
{
  write_byte((-sum) & 0xff);
  fprintf(hex, "\n");
}

void dump_hex()
{
  int i, j;
  char *pc;

  switch (state.hexfile) {
  case normal:
    strcpy(state.hexfilename, state.srcfilename);
    pc = strrchr(state.hexfilename, '.');
    if (pc == NULL)
      pc = state.hexfilename + strlen(state.hexfilename);
    strcpy(pc, ".hex");
    break;
  case suppress:
    return;
  case named:
    /* Don't need to do anything - name is already set up */
    ;
  }

  if (state.num.errors) {
    /* Remove the hex file (if any) */
    unlink(state.hexfilename);
    return;
  }

  /* No error: overwrite the hex file */

  hex = fopen(state.hexfilename, "w");
  i = 0;
  while (i < MAX_I_MEM) {
    if ((state.i_memory[i] & MEM_USED_MASK) == 0) {
      ++i;
    } else {
      j = i;
      while ((state.i_memory[i] & MEM_USED_MASK)) {
	++i;
	if ((i & 7) == 0)
	  break;
      }
      /* Now we have a run of (i - j) occupied memory locations. */
      new_record();
      write_byte(2 * (i - j));
      write_bg_word(2 * j);
      write_byte(0);
      while (j < i)
	write_word(state.i_memory[j++]);
      end_record();
    }
  }

  new_record();
  write_byte(0);
  write_word(0);
  write_byte(1);
  end_record();

  fclose(hex);
}
